/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.Versions;
import com.lowagie.tools.Executable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Toolbox
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3766198389452935073L;
    private JDesktopPane desktop;
    private JScrollPane console;
    private Properties toolmap = new Properties();
    private int locationX = 0;
    private int locationY = 0;
    private ArrayList<AbstractTool> toolarray = new ArrayList();
    private Vector<String> menulist = new Vector();
    private Vector<String> menuitemlist = new Vector();

    public Toolbox() {
        this.setSize(600, 500);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("iText Toolbox");
        this.desktop = new JDesktopPane();
        this.setJMenuBar(this.getMenubar());
        this.setIconImage(new ImageIcon(Toolbox.class.getResource("1t3xt.gif")).getImage());
        try {
            Console c = new Console();
            this.console = new JScrollPane(c.textArea);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSplitPane splitPane = new JSplitPane(0, this.desktop, this.console);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(300);
        this.setContentPane(splitPane);
        Toolbox.centerFrame(this);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            Class.forName("com.lowagie.text.Document");
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(null, "You need the iText.jar in your CLASSPATH!", e.getClass().getName(), 0);
            System.exit(1);
        }
        Toolbox toolbox = new Toolbox();
        if (args.length > 0) {
            try {
                AbstractTool tool = toolbox.createFrame(args[0]);
                String[] nargs = new String[args.length - 1];
                System.arraycopy(args, 1, nargs, 0, args.length - 1);
                tool.setMainArguments(nargs);
                tool.execute();
            }
            catch (PropertyVetoException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                // empty catch block
            }
        }
    }

    private JMenuBar getMenubar() {
        Properties p = new Properties();
        try {
            p.load(Toolbox.class.getClassLoader().getResourceAsStream("com/lowagie/toolbox/tools.txt"));
            String usertoolstxt = System.getProperty("user.home") + System.getProperty("file.separator") + "tools.txt";
            File uttf = new File(usertoolstxt);
            if (uttf.isFile() && uttf.exists()) {
                p.load(new FileInputStream(usertoolstxt));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.toolmap = new Properties();
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(84);
        JMenuItem close = new JMenuItem("Close");
        close.setMnemonic(67);
        close.addActionListener(this);
        file.add(close);
        JMenu view = new JMenu("View");
        JMenuItem reset = new JMenuItem("Reset");
        reset.addActionListener(this);
        view.add(reset);
        JMenu tools = new JMenu("Tools");
        this.buildPluginMenuItems(new TreeMap<Object, Object>(p), tools);
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic(65);
        about.addActionListener(this);
        help.add(about);
        JMenuItem versions = new JMenuItem("Version");
        versions.addActionListener(this);
        help.add(versions);
        menubar.add(file);
        menubar.add(tools);
        menubar.add(view);
        menubar.add(Box.createGlue());
        menubar.add(help);
        return menubar;
    }

    private void buildPluginMenuItems(Map<Object, Object> tmp, JMenu tools) {
        AbstractButton current = null;
        for (Map.Entry<Object, Object> entry : tmp.entrySet()) {
            String name = (String)entry.getKey();
            if (current == null || !name.startsWith(current.getText())) {
                String menu = name.substring(0, name.indexOf(46));
                this.menulist.add(menu);
                current = new JMenu(menu);
                tools.add((JMenuItem)current);
            }
            String menuitem = name.substring(current.getText().length() + 1);
            this.menuitemlist.add(menuitem);
            JMenuItem item = new JMenuItem(menuitem);
            item.addActionListener(this);
            String tool = (String)entry.getValue();
            try {
                if (Class.forName(tool) == null) continue;
                this.toolmap.put(item.getText(), tool);
                ((JMenu)current).add(item);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Plugin " + name + " was not found in your CLASSPATH.");
            }
        }
    }

    public AbstractTool createFrame(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException, PropertyVetoException {
        AbstractTool ti = null;
        String classname = (String)this.toolmap.get(name);
        ti = (AbstractTool)Class.forName(classname).newInstance();
        this.toolarray.add(ti);
        JInternalFrame f = ti.getInternalFrame();
        f.setLocation(this.locationX, this.locationY);
        this.locationX += 25;
        if (this.locationX > this.getWidth() + 50) {
            this.locationX = 0;
        }
        this.locationY += 25;
        if (this.locationY > this.getHeight() + 50) {
            this.locationY = 0;
        }
        f.setVisible(true);
        this.desktop.add(f);
        f.setSelected(true);
        return ti;
    }

    public static void centerFrame(Frame f) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = f.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        f.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if ("Close".equals(evt.getActionCommand())) {
            System.out.println("The Toolbox is closed.");
            System.exit(0);
        } else if ("About".equals(evt.getActionCommand())) {
            System.out.println("The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://itexttoolbox.sourceforge.net/ for more info.");
            try {
                Executable.launchBrowser("http://itexttoolbox.sourceforge.net/");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://itexttoolbox.sourceforge.net/ for more info.");
            }
        } else if ("Reset".equals(evt.getActionCommand())) {
            JInternalFrame[] framearray = this.desktop.getAllFrames();
            int xx = 0;
            int yy = 0;
            for (JInternalFrame jInternalFrame : framearray) {
                if (jInternalFrame.isIcon()) continue;
                try {
                    int frameDistance = jInternalFrame.getHeight() - jInternalFrame.getContentPane().getHeight();
                    jInternalFrame.setMaximum(false);
                    int fwidth = jInternalFrame.getWidth();
                    int fheight = jInternalFrame.getHeight();
                    jInternalFrame.reshape(xx, yy, fwidth, fheight);
                    yy += frameDistance;
                    if ((xx += frameDistance) + fwidth > this.desktop.getWidth()) {
                        xx = 0;
                    }
                    if (yy + fheight <= this.desktop.getHeight()) continue;
                    yy = 0;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        } else if ("Version".equals(evt.getActionCommand())) {
            Versions f = new Versions();
            Toolbox.centerFrame(f);
            f.setVisible(true);
        } else {
            try {
                this.createFrame(evt.getActionCommand());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector<String> getMenulist() {
        return this.menulist;
    }

    public class Console {
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        ErrorContext errorcontext = new ErrorContext();
        JTextPane textArea = new JTextPane(new DefaultStyledDocument(this.errorcontext));
        PrintStream oriout;
        PrintStream orierr;

        public Console() throws IOException {
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            this.oriout = System.out;
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            this.orierr = System.err;
            System.setErr(new PrintStream(this.poErr, true));
            this.textArea.setEditable(false);
            new ReaderThread(this.piOut, "StdOut").start();
            new ReaderThread(this.piErr, "Error").start();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;
            String type;

            ReaderThread(PipedInputStream pi, String type) {
                this.pi = pi;
                this.type = type;
            }

            @Override
            public void run() {
                byte[] buf = new byte[1024];
                while (true) {
                    try {
                        int len;
                        while ((len = this.pi.read(buf)) != -1) {
                            Document doc = Console.this.textArea.getDocument();
                            Style attset = Console.this.errorcontext.getStyle(this.type);
                            String snippet = new String(buf, 0, len);
                            doc.insertString(doc.getLength(), snippet, attset);
                            Console.this.oriout.print(snippet);
                            Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                        }
                    }
                    catch (IOException | BadLocationException exception) {
                        continue;
                    }
                    break;
                }
            }
        }

        class ErrorContext
        extends StyleContext {
            private static final long serialVersionUID = 7766294638325167438L;
            public static final String STDERROR = "Error";
            public static final String STDOUT = "StdOut";

            public ErrorContext() {
                Style root = this.getStyle("default");
                Style s = this.addStyle(STDERROR, root);
                StyleConstants.setForeground(s, Color.RED);
                s = this.addStyle(STDOUT, root);
                StyleConstants.setForeground(s, Color.BLACK);
            }
        }
    }
}

