/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.model;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.openpdf.rups.model.IndirectObjectFactory;
import org.openpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import org.openpdf.rups.view.itext.treenodes.PdfPagesTreeNode;
import org.openpdf.text.pdf.PdfArray;
import org.openpdf.text.pdf.PdfDictionary;
import org.openpdf.text.pdf.PdfIndirectReference;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfNull;
import org.openpdf.text.pdf.PdfObject;

public class TreeNodeFactory {
    protected IndirectObjectFactory objects;
    protected ArrayList<PdfObjectTreeNode> nodes = new ArrayList();

    public TreeNodeFactory(IndirectObjectFactory objects) {
        this.objects = objects;
        for (int i = 0; i < objects.size(); ++i) {
            int ref = objects.getRefByIndex(i);
            this.nodes.add(PdfObjectTreeNode.getInstance((PdfObject)PdfNull.PDFNULL, ref));
        }
    }

    public PdfObjectTreeNode getNode(int ref) {
        int idx = this.objects.getIndexByRef(ref);
        PdfObjectTreeNode node = this.nodes.get(idx);
        if (node.getPdfObject().isNull()) {
            node = PdfObjectTreeNode.getInstance(this.objects.loadObjectByReference(ref), ref);
            this.nodes.set(idx, node);
        }
        return node;
    }

    public void expandNode(PdfObjectTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        PdfObject object = node.getPdfObject();
        switch (object.type()) {
            case 10: {
                PdfIndirectReference ref = (PdfIndirectReference)object;
                PdfObjectTreeNode leaf = this.getNode(ref.getNumber());
                this.addNodes(node, leaf);
                if (leaf instanceof PdfPagesTreeNode) {
                    this.expandNode(leaf);
                }
                return;
            }
            case 5: {
                PdfArray array = (PdfArray)object;
                for (PdfObject pdfObject : array.getElements()) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance(pdfObject);
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary dict = (PdfDictionary)object;
                for (PdfName pdfName : dict.getKeys()) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance(dict, pdfName);
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                return;
            }
        }
    }

    public PdfObjectTreeNode getChildNode(PdfObjectTreeNode node, PdfName key) {
        Enumeration<TreeNode> children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            PdfObjectTreeNode child = (PdfObjectTreeNode)children.nextElement();
            if (!child.isDictionaryNode(key)) continue;
            if (child.isIndirectReference()) {
                this.expandNode(child);
                child = (PdfObjectTreeNode)child.getFirstChild();
            }
            this.expandNode(child);
            return child;
        }
        return null;
    }

    private void addNodes(PdfObjectTreeNode parent, PdfObjectTreeNode child) {
        try {
            parent.add(child);
        }
        catch (IllegalArgumentException iae) {
            parent.setRecursive(true);
        }
    }
}

