/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.model;

import javax.swing.SwingUtilities;

public abstract class BackgroundTask {
    private ThreadWrapper thread;

    public BackgroundTask() {
        Runnable doFinished = this::finished;
        Runnable doConstruct = () -> {
            try {
                this.doTask();
            }
            finally {
                this.thread.clear();
            }
            SwingUtilities.invokeLater(doFinished);
        };
        Thread t = new Thread(doConstruct);
        this.thread = new ThreadWrapper(t);
    }

    public abstract void doTask();

    public void start() {
        Thread t = this.thread.get();
        if (t != null) {
            t.start();
        }
    }

    public void interrupt() {
        Thread t = this.thread.get();
        if (t != null) {
            t.interrupt();
        }
        this.thread.clear();
    }

    public void finished() {
    }

    private static class ThreadWrapper {
        private Thread thread;

        ThreadWrapper(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

