/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.view.PageSelectionListener;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPageTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.rups.view.models.JTableAutoModel;
import com.lowagie.rups.view.models.JTableAutoModelInterface;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.TreeNode;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PagesTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    private static final long serialVersionUID = -6523261089453886508L;
    protected ArrayList<PdfPageTreeNode> list = new ArrayList();
    protected PdfReaderController controller;
    protected PageSelectionListener listener;

    public PagesTable(PdfReaderController controller, PageSelectionListener listener) {
        this.controller = controller;
        this.listener = listener;
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.list = new ArrayList();
            this.repaint();
            return;
        }
        if (obj instanceof ObjectLoader) {
            PdfTrailerTreeNode trailer;
            PdfObjectTreeNode catalog;
            ObjectLoader loader = (ObjectLoader)obj;
            String[] pagelabels = PdfPageLabels.getPageLabels((PdfReader)loader.getReader());
            int i = 0;
            TreeNodeFactory factory = loader.getNodes();
            PdfPagesTreeNode pages = (PdfPagesTreeNode)factory.getChildNode(catalog = factory.getChildNode(trailer = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.PAGES);
            if (pages == null) {
                return;
            }
            Enumeration<TreeNode> p = pages.depthFirstEnumeration();
            while (p.hasMoreElements()) {
                PdfObjectTreeNode child = (PdfObjectTreeNode)p.nextElement();
                if (!(child instanceof PdfPageTreeNode)) continue;
                StringBuffer buf = new StringBuffer("Page ");
                buf.append(++i);
                if (pagelabels != null) {
                    buf.append(" ( ");
                    buf.append(pagelabels[i - 1]);
                    buf.append(" )");
                }
                child.setUserObject(buf.toString());
                this.list.add((PdfPageTreeNode)child);
            }
        }
        this.setModel(new JTableAutoModel(this));
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return "Object " + this.list.get(rowIndex).getNumber();
            }
            case 1: {
                return this.list.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Object";
            }
            case 1: {
                return "Page";
            }
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt != null) {
            super.valueChanged(evt);
        }
        if (this.controller == null) {
            return;
        }
        if (this.getRowCount() > 0) {
            this.controller.selectNode(this.list.get(this.getSelectedRow()));
            if (this.listener != null) {
                this.listener.gotoPage(this.getSelectedRow() + 1);
            }
        }
    }
}

