/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext.treenodes;

import com.lowagie.rups.view.icons.IconFetcher;
import com.lowagie.rups.view.icons.IconTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPageTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfObjectTreeNode
extends IconTreeNode {
    private static final long serialVersionUID = -5617844659397445879L;
    protected PdfObject object;
    protected PdfName key = null;
    protected int number = -1;
    protected boolean recursive = false;

    protected PdfObjectTreeNode(PdfObject object) {
        super(null, PdfObjectTreeNode.getCaption(object));
        this.object = object;
        switch (object.type()) {
            case 10: {
                this.icon = this.isRecursive() ? IconFetcher.getIcon("ref_recursive.png") : IconFetcher.getIcon("ref.png");
                return;
            }
            case 5: {
                this.icon = IconFetcher.getIcon("array.png");
                return;
            }
            case 6: {
                this.icon = IconFetcher.getIcon("dictionary.png");
                return;
            }
            case 7: {
                this.icon = IconFetcher.getIcon("stream.png");
                return;
            }
            case 1: {
                this.icon = IconFetcher.getIcon("boolean.png");
                return;
            }
            case 4: {
                this.icon = IconFetcher.getIcon("name.png");
                return;
            }
            case 8: {
                this.icon = IconFetcher.getIcon("null.png");
                return;
            }
            case 2: {
                this.icon = IconFetcher.getIcon("number.png");
                return;
            }
            case 3: {
                this.icon = IconFetcher.getIcon("string.png");
                return;
            }
        }
    }

    protected PdfObjectTreeNode(String icon, PdfObject object) {
        super(icon, PdfObjectTreeNode.getCaption(object));
        this.object = object;
    }

    public static PdfObjectTreeNode getInstance(PdfObject object) {
        if (object.isDictionary()) {
            if (PdfName.PAGE.equals((Object)((PdfDictionary)object).get(PdfName.TYPE))) {
                return new PdfPageTreeNode((PdfDictionary)object);
            }
            if (PdfName.PAGES.equals((Object)((PdfDictionary)object).get(PdfName.TYPE))) {
                return new PdfPagesTreeNode((PdfDictionary)object);
            }
        }
        return new PdfObjectTreeNode(object);
    }

    public static PdfObjectTreeNode getInstance(PdfObject object, int number) {
        PdfObjectTreeNode node = PdfObjectTreeNode.getInstance(object);
        node.number = number;
        return node;
    }

    public static PdfObjectTreeNode getInstance(PdfDictionary dict, PdfName key) {
        PdfObjectTreeNode node = PdfObjectTreeNode.getInstance(dict.get(key));
        node.setUserObject(PdfObjectTreeNode.getDictionaryEntryCaption(dict, key));
        node.key = key;
        return node;
    }

    public static String getCaption(PdfObject object) {
        if (object == null) {
            return "null";
        }
        switch (object.type()) {
            case 10: {
                String reffedCaption = PdfObjectTreeNode.getCaption(PdfReader.getPdfObject((PdfObject)object));
                return object.toString() + " -> " + reffedCaption;
            }
            case 5: {
                return "Array";
            }
            case 7: {
                return "Stream";
            }
            case 3: {
                return ((PdfString)object).toUnicodeString();
            }
        }
        return object.toString();
    }

    public static String getDictionaryEntryCaption(PdfDictionary dict, PdfName key) {
        StringBuilder buf = new StringBuilder(key.toString());
        buf.append(": ");
        PdfObject valObj = dict.get(key);
        if (valObj.isIndirect()) {
            buf.append(PdfObjectTreeNode.getCaption(valObj));
        } else {
            buf.append(dict.get(key).toString());
        }
        return buf.toString();
    }

    public PdfObject getPdfObject() {
        return this.object;
    }

    public int getNumber() {
        if (this.isIndirectReference()) {
            return ((PdfIndirectReference)this.object).getNumber();
        }
        return this.number;
    }

    public boolean isIndirectReference() {
        return this.object.type() == 10;
    }

    public boolean isIndirect() {
        return this.isIndirectReference() || this.number > -1;
    }

    public boolean isArray() {
        return this.object.isArray();
    }

    public boolean isDictionaryNode(PdfName key) {
        if (key == null) {
            return false;
        }
        return key.equals((Object)this.key);
    }

    public boolean isDictionary() {
        return this.object.isDictionary();
    }

    public boolean isStream() {
        return this.object.isStream();
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public PdfObjectTreeNode getAncestor() {
        if (this.isRecursive()) {
            PdfObjectTreeNode node = this;
            while (!(node = (PdfObjectTreeNode)node.getParent()).isIndirectReference() || node.getNumber() != this.getNumber()) {
            }
            return node;
        }
        return null;
    }
}

