/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.view.models.DictionaryTableModel;
import com.lowagie.rups.view.models.PdfArrayTableModel;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfObject;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfObjectPanel
extends JPanel
implements Observer {
    private static final String TEXT = "text";
    private static final String TABLE = "table";
    protected CardLayout layout = new CardLayout();
    JTable table = new JTable();
    JTextArea text = new JTextArea();
    private static final long serialVersionUID = 1302283071087762494L;

    public PdfObjectPanel() {
        this.setLayout(this.layout);
        JScrollPane dict_scrollpane = new JScrollPane();
        dict_scrollpane.setViewportView(this.table);
        this.add((Component)dict_scrollpane, TABLE);
        JScrollPane text_scrollpane = new JScrollPane();
        text_scrollpane.setViewportView(this.text);
        this.add((Component)text_scrollpane, TEXT);
    }

    public void clear() {
        this.text.setText(null);
        this.layout.show(this, TEXT);
    }

    @Override
    public void update(Observable observable, Object obj) {
        this.clear();
    }

    public void render(PdfObject object) {
        if (object == null) {
            this.text.setText(null);
            this.layout.show(this, TEXT);
            this.repaint();
            this.text.repaint();
            return;
        }
        switch (object.type()) {
            case 6: 
            case 7: {
                this.table.setModel(new DictionaryTableModel((PdfDictionary)object));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            case 5: {
                this.table.setModel(new PdfArrayTableModel((PdfArray)object));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            default: {
                this.text.setText(object.toString());
                this.layout.show(this, TEXT);
            }
        }
    }
}

