/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view;

import com.lowagie.rups.io.FileChooserAction;
import com.lowagie.rups.io.FileCloseAction;
import com.lowagie.rups.io.filters.PdfFilter;
import com.lowagie.rups.view.MessageAction;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RupsMenuBar
extends JMenuBar
implements Observer {
    public static final String FILE_MENU = "File";
    public static final String OPEN = "Open";
    public static final String CLOSE = "Close";
    public static final String HELP_MENU = "Help";
    public static final String ABOUT = "About";
    public static final String VERSION = "Version";
    private static final long serialVersionUID = 6403040037592308742L;
    protected Observable observable;
    protected FileChooserAction fileChooserAction;
    protected HashMap<String, JMenuItem> items;

    public RupsMenuBar(Observable observable) {
        this.observable = observable;
        this.items = new HashMap();
        this.fileChooserAction = new FileChooserAction(observable, OPEN, PdfFilter.INSTANCE, false);
        MessageAction message = new MessageAction();
        JMenu file = new JMenu(FILE_MENU);
        this.addItem(file, OPEN, this.fileChooserAction);
        this.addItem(file, CLOSE, new FileCloseAction(observable));
        this.add(file);
        this.add(Box.createGlue());
        JMenu help = new JMenu(HELP_MENU);
        this.addItem(help, ABOUT, message);
        this.addItem(help, VERSION, message);
        this.add(help);
        this.enableItems(false);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (OPEN.equals(obj)) {
            this.enableItems(true);
            return;
        }
        if (CLOSE.equals(obj)) {
            this.enableItems(false);
            return;
        }
        if (FILE_MENU.equals(obj)) {
            this.fileChooserAction.actionPerformed(null);
        }
    }

    protected void addItem(JMenu menu, String caption, ActionListener action) {
        JMenuItem item = new JMenuItem(caption);
        item.addActionListener(action);
        menu.add(item);
        this.items.put(caption, item);
    }

    protected void enableItems(boolean enabled) {
        this.enableItem(CLOSE, enabled);
    }

    protected void enableItem(String caption, boolean enabled) {
        this.items.get(caption).setEnabled(enabled);
    }
}

