/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = DocWriter.getISOBytes((String)"\\pard");
    public static final byte[] PLAIN = DocWriter.getISOBytes((String)"\\plain");
    public static final byte[] IN_TABLE = DocWriter.getISOBytes((String)"\\intbl");
    public static final byte[] LINE_SPACING = DocWriter.getISOBytes((String)"\\sl");
    protected final ArrayList<RtfBasicElement> chunks = new ArrayList();
    private int lineLeading = 0;

    protected RtfPhrase(RtfDocument doc) {
        super(doc);
    }

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.hasLeading() ? (int)((double)phrase.getLeading() * 20.0) : 0;
        RtfFont phraseFont = new RtfFont(null, phrase.getFont());
        for (Element chunk : phrase) {
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(phraseFont.difference(((Chunk)chunk).getFont()));
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                Collections.addAll(this.chunks, rtfElements);
            }
            catch (DocumentException documentException) {}
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(PARAGRAPH_DEFAULTS);
        result.write(PLAIN);
        if (this.inTable) {
            result.write(IN_TABLE);
        }
        if (this.lineLeading > 0) {
            result.write(LINE_SPACING);
            result.write(this.intToByteArray(this.lineLeading));
        }
        for (RtfBasicElement rbe : this.chunks) {
            rbe.writeContent(result);
        }
    }

    @Override
    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (RtfBasicElement rbe : this.chunks) {
            rbe.setInTable(inTable);
        }
    }

    @Override
    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (RtfBasicElement rbe : this.chunks) {
            rbe.setInHeader(inHeader);
        }
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        for (RtfBasicElement rbe : this.chunks) {
            rbe.setRtfDocument(this.document);
        }
    }
}

