/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.parser;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openpdf.text.pdf.PdfString;
import org.openpdf.text.pdf.parser.GraphicsState;
import org.openpdf.text.pdf.parser.MatchedPattern;
import org.openpdf.text.pdf.parser.Matrix;
import org.openpdf.text.pdf.parser.ParsedText;
import org.openpdf.text.pdf.parser.PdfContentStreamHandler;
import org.openpdf.text.pdf.parser.TextAssembler;
import org.openpdf.text.pdf.parser.Vector;

public class PdfContentTextLocator
extends PdfContentStreamHandler {
    private final ArrayList<MatchedPattern> accumulator = new ArrayList();
    private final ArrayList<ParsedText> fragments = new ArrayList();
    private final ArrayList<Float> fragmentsWidths = new ArrayList();
    private final int page;
    private final Pattern p;

    public PdfContentTextLocator(TextAssembler renderListener, String pattern, int page) {
        super(renderListener);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern sequence must be longer than 0");
        }
        this.p = Pattern.compile(pattern);
        this.page = page;
        this.installDefaultOperators();
        this.reset();
    }

    @Override
    protected void installDefaultOperators() {
        super.installDefaultOperators();
        this.registerContentOperator(new PdfContentStreamHandler.Do(this));
    }

    @Override
    void popContext() {
        this.renderListener.reset();
    }

    @Override
    void pushContext(String newContextName) {
    }

    @Override
    public void reset() {
        if (this.gsStack == null || this.gsStack.isEmpty()) {
            this.gsStack = new Stack();
        }
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
    }

    @Override
    void displayPdfString(PdfString string) {
        byte[] bytes = "Identity-H".equals(this.graphicsState().getFont().getEncoding()) ? string.toString().getBytes(StandardCharsets.UTF_16) : string.toString().getBytes();
        String decoded = this.graphicsState().getFont().decode(bytes, 0, bytes.length);
        char[] chars = decoded.toCharArray();
        float[] widths = new float[chars.length + 1];
        Vector startPoint = new Vector(0.0f, 0.0f, 1.0f).cross(this.textMatrix);
        float startWidth = startPoint.get(0);
        float totalWidth = 0.0f;
        widths[0] = startWidth;
        int counter = 1;
        for (char c : chars) {
            float w = (float)this.graphicsState().getFont().getWidth(c) / 1000.0f;
            float wordSpacing = Character.isSpaceChar(c) ? this.graphicsState().getWordSpacing() : 0.0f;
            float blockWidth = (w * this.graphicsState().getFontSize() + this.graphicsState().getCharacterSpacing() + wordSpacing) * this.graphicsState().getHorizontalScaling();
            widths[counter] = startWidth + (totalWidth += blockWidth);
            ++counter;
        }
        float pdfStringWidth = startWidth + totalWidth;
        float y = new Vector(0.0f, 0.0f, 1.0f).cross(this.textMatrix).get(1);
        float y1 = y + this.graphicsState().getFontDescentDescriptor();
        float y2 = y + this.graphicsState().getFontAscentDescriptor();
        Matcher m = this.p.matcher(decoded);
        while (m.find()) {
            float x1 = widths[m.start()];
            float x2 = widths[m.end()];
            MatchedPattern mp = new MatchedPattern(decoded, this.page, x1, y1, x2, y2);
            this.accumulator.add(mp);
        }
        this.textMatrix = new Matrix(totalWidth, 0.0f).multiply(this.textMatrix);
    }

    private float convertHeightToUser(float height) {
        Vector endPos = new Vector(0.0f, height, 1.0f).cross(this.textMatrix);
        return endPos.get(1);
    }

    @Override
    public String getResultantText() {
        return "";
    }

    public ArrayList<MatchedPattern> getMatchedPatterns() {
        return this.accumulator;
    }
}

