/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.draw;

import java.util.ArrayList;
import org.openpdf.text.Chunk;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Element;
import org.openpdf.text.ElementListener;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.draw.DrawInterface;

public class VerticalPositionMark
implements DrawInterface,
Element {
    protected DrawInterface drawInterface = null;
    protected float offset = 0.0f;

    public VerticalPositionMark() {
    }

    public VerticalPositionMark(DrawInterface drawInterface, float offset) {
        this.drawInterface = drawInterface;
        this.offset = offset;
    }

    @Override
    public void draw(PdfContentByte canvas, float llx, float lly, float urx, float ury, float y) {
        if (this.drawInterface != null) {
            this.drawInterface.draw(canvas, llx, lly, urx, ury, y + this.offset);
        }
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException e) {
            return false;
        }
    }

    @Override
    public int type() {
        return 55;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(new Chunk((DrawInterface)this, true));
        return list;
    }

    public DrawInterface getDrawInterface() {
        return this.drawInterface;
    }

    public void setDrawInterface(DrawInterface drawInterface) {
        this.drawInterface = drawInterface;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }
}

