/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.font.cid;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.font.cid.PDFCMap;

public class ToUnicodeMap
extends PDFCMap {
    private final Map<Character, Character> singleCharMappings = new HashMap<Character, Character>();
    private final List<CharRangeMapping> charRangeMappings = new ArrayList<CharRangeMapping>();
    private final List<CodeRangeMapping> codeRangeMappings = new ArrayList<CodeRangeMapping>();

    public ToUnicodeMap(PDFObject map) throws IOException {
        this.parseMappings(map);
    }

    private void parseMappings(PDFObject map) throws IOException {
        try {
            StringReader reader = new StringReader(new String(map.getStream(), "ASCII"));
            BufferedReader bf = new BufferedReader(reader);
            String line = bf.readLine();
            while (line != null) {
                if (line.contains("beginbfchar") || line.contains("begincidchar")) {
                    this.parseSingleCharMappingSection(bf, line.contains("begincidchar"));
                }
                if (line.contains("beginbfrange") || line.contains("begincidrange")) {
                    this.parseCharRangeMappingSection(bf, line.contains("begincidrange"));
                }
                if (line.contains("begincodespacerange")) {
                    this.parseCodeRangeMappingSection(bf, line);
                }
                line = bf.readLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    private void parseCharRangeMappingSection(BufferedReader bf, boolean isCid) throws IOException {
        String line = bf.readLine();
        while (line != null && !line.contains("endbfrange") && !line.contains("endcidrange")) {
            this.parseRangeLine(line, isCid);
            line = bf.readLine();
        }
    }

    private void parseCodeRangeMappingSection(BufferedReader bf, String line) throws IOException {
        if (line.contains("endcodespacerange")) {
            int indexOf = line.indexOf("endcodespacerange");
            line = line.substring(0, indexOf);
            indexOf = line.indexOf("begincodespacerange");
            line = line.substring(indexOf + "begincodespacerange".length(), line.length());
            line = line.trim();
            this.parseCodeRangeLine(line);
        } else {
            String rline = bf.readLine();
            while (rline != null && !rline.contains("endcodespacerange")) {
                this.parseCodeRangeLine(rline);
                rline = bf.readLine();
            }
        }
    }

    private void parseRangeLine(String line, boolean isCid) {
        String[] mapping = line.split(" ");
        if (mapping.length == 3) {
            Character srcStart = this.parseChar(mapping[0]);
            Character srcEnd = this.parseChar(mapping[1]);
            Character destStart = isCid ? Character.valueOf((char)Integer.parseInt(mapping[2])) : this.parseChar(mapping[2]);
            this.charRangeMappings.add(new CharRangeMapping(srcStart.charValue(), srcEnd.charValue(), destStart.charValue()));
        } else {
            int indexOf1 = line.indexOf(">");
            String substring1 = line.substring(0, indexOf1 + 1);
            int indexOf2 = line.indexOf("<", indexOf1);
            int indexOf3 = line.indexOf(">", indexOf2);
            String substring2 = line.substring(indexOf2, indexOf3 + 1);
            int indexOf4 = line.indexOf("<", indexOf3);
            String substring3 = line.substring(indexOf4, line.length());
            if (!(substring1.isEmpty() || substring2.isEmpty() || substring3.isEmpty())) {
                Character srcStart = this.parseChar(substring1);
                Character srcEnd = this.parseChar(substring2);
                Character destStart = this.parseChar(substring3);
                this.charRangeMappings.add(new CharRangeMapping(srcStart.charValue(), srcEnd.charValue(), destStart.charValue()));
            }
        }
    }

    private void parseCodeRangeLine(String line) {
        String[] mapping = line.split(" ");
        if (mapping.length == 2) {
            Character srcStart = this.parseChar(mapping[0]);
            Character srcEnd = this.parseChar(mapping[1]);
            this.codeRangeMappings.add(new CodeRangeMapping(srcStart.charValue(), srcEnd.charValue()));
        } else {
            int indexOf1 = line.indexOf(">");
            String substring1 = line.substring(0, indexOf1 + 1);
            int indexOf2 = line.indexOf("<", indexOf1);
            String substring2 = line.substring(indexOf2, line.length());
            if (!substring1.isEmpty() && !substring2.isEmpty()) {
                Character srcStart = this.parseChar(substring1);
                Character srcEnd = this.parseChar(substring2);
                this.codeRangeMappings.add(new CodeRangeMapping(srcStart.charValue(), srcEnd.charValue()));
            }
        }
    }

    private void parseSingleCharMappingSection(BufferedReader bf, boolean isCID) throws IOException {
        String line = bf.readLine();
        while (line != null && !line.contains("endbfchar") && !line.contains("endcidchar")) {
            this.parseSingleCharMappingLine(line, isCID);
            line = bf.readLine();
        }
    }

    private void parseSingleCharMappingLine(String line, boolean isCID) {
        String[] mapping = line.split(" ");
        if (mapping.length == 2) {
            if (isCID) {
                this.singleCharMappings.put(this.parseChar(mapping[0]), Character.valueOf((char)Integer.parseInt(mapping[1])));
            } else {
                this.singleCharMappings.put(this.parseChar(mapping[0]), this.parseChar(mapping[1]));
            }
        }
    }

    private Character parseChar(String charDef) {
        if (charDef.startsWith("<")) {
            charDef = charDef.substring(1);
        }
        if (charDef.endsWith(">")) {
            charDef = charDef.substring(0, charDef.length() - 1);
        }
        try {
            long result = Long.decode("0x" + charDef);
            return Character.valueOf((char)result);
        }
        catch (NumberFormatException e) {
            return Character.valueOf(' ');
        }
    }

    @Override
    public char map(char src) {
        Character mappedChar = null;
        for (CodeRangeMapping codeRange : this.codeRangeMappings) {
            if (!codeRange.contains(src)) continue;
            mappedChar = this.singleCharMappings.get(Character.valueOf(src));
            if (mappedChar != null) break;
            mappedChar = this.lookupInRanges(src);
            break;
        }
        if (mappedChar == null) {
            mappedChar = Character.valueOf('\u0000');
        }
        return mappedChar.charValue();
    }

    private Character lookupInRanges(char src) {
        Character mappedChar = null;
        for (CharRangeMapping rangeMapping : this.charRangeMappings) {
            if (!rangeMapping.contains(src)) continue;
            mappedChar = Character.valueOf(rangeMapping.map(src));
            break;
        }
        return mappedChar;
    }

    private static class CharRangeMapping {
        char srcStart;
        char srcEnd;
        char destStart;

        CharRangeMapping(char srcStart, char srcEnd, char destStart) {
            this.srcStart = srcStart;
            this.srcEnd = srcEnd;
            this.destStart = destStart;
        }

        boolean contains(char c) {
            return this.srcStart <= c && c <= this.srcEnd;
        }

        char map(char src) {
            return (char)(this.destStart + (src - this.srcStart));
        }
    }

    private static class CodeRangeMapping {
        char srcStart;
        char srcEnd;

        CodeRangeMapping(char srcStart, char srcEnd) {
            this.srcStart = srcStart;
            this.srcEnd = srcEnd;
        }

        boolean contains(char c) {
            return this.srcStart <= c && c <= this.srcEnd;
        }
    }
}

