/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.colorspace;

import java.awt.color.ColorSpace;
import org.openpdf.renderer.PDFPaint;
import org.openpdf.renderer.colorspace.AltColorSpace;
import org.openpdf.renderer.colorspace.PDFColorSpace;
import org.openpdf.renderer.function.PDFFunction;

public class AlternateColorSpace
extends PDFColorSpace {
    private PDFColorSpace alternate;
    private PDFFunction function;
    private AltColorSpace altcolorspace;

    public AlternateColorSpace(PDFColorSpace alternate, PDFFunction function) {
        super(null);
        this.alternate = alternate;
        this.function = function;
    }

    @Override
    public int getNumComponents() {
        if (this.function != null) {
            return this.function.getNumInputs();
        }
        return this.alternate.getNumComponents();
    }

    @Override
    public PDFPaint getPaint(float[] components) {
        if (this.function != null) {
            components = this.function.calculate(components);
        }
        return this.alternate.getPaint(components);
    }

    @Override
    public ColorSpace getColorSpace() {
        if (this.altcolorspace == null) {
            this.altcolorspace = new AltColorSpace(this.function, this.alternate.getColorSpace());
        }
        return this.altcolorspace;
    }

    public PDFFunction getFunktion() {
        return this.function;
    }
}

