/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.annotation;

import org.openpdf.renderer.Configuration;
import org.openpdf.renderer.annotation.CircleAnnotation;
import org.openpdf.renderer.annotation.FreetextAnnotation;
import org.openpdf.renderer.annotation.LinkAnnotation;
import org.openpdf.renderer.annotation.MarkupAnnotation;
import org.openpdf.renderer.annotation.PDFAnnotation;
import org.openpdf.renderer.annotation.SquareAnnotation;
import org.openpdf.renderer.annotation.StampAnnotation;
import org.openpdf.renderer.annotation.TextMarkupAnnotation;
import org.openpdf.renderer.annotation.WidgetAnnotation;

public enum AnnotationType {
    UNKNOWN("-", 0, PDFAnnotation.class),
    LINK("Link", 1, LinkAnnotation.class),
    WIDGET("Widget", 2, WidgetAnnotation.class),
    STAMP("Stamp", 3, StampAnnotation.class),
    FREETEXT("FreeText", 5, FreetextAnnotation.class),
    SIGNATURE("Sig", 6, WidgetAnnotation.class),
    TEXT("Text", 7, MarkupAnnotation.class),
    LINE("Line", 8, MarkupAnnotation.class),
    SQUARE("Square", 9, SquareAnnotation.class),
    CIRCLE("Circle", 10, CircleAnnotation.class),
    POLYGON("Polygon", 11, MarkupAnnotation.class),
    POLYLINE("PolyLine", 12, MarkupAnnotation.class),
    HIGHLIGHT("Highlight", 13, TextMarkupAnnotation.class),
    UNDERLINE("Underline", 14, TextMarkupAnnotation.class),
    SQUIGGLY("Squiggly", 15, TextMarkupAnnotation.class),
    STRIKEOUT("StrikeOut", 16, TextMarkupAnnotation.class),
    CARET("Caret", 17, MarkupAnnotation.class),
    INK("Ink", 18, MarkupAnnotation.class),
    FILEATTACHMENT("FileAttachment", 20, PDFAnnotation.class),
    SOUND("Sound", 21, PDFAnnotation.class),
    MOVIE("Movie", 22, PDFAnnotation.class),
    SCREEN("Screen", 23, PDFAnnotation.class),
    PRINTERMARK("PrinterMark", 24, PDFAnnotation.class),
    TRAPNET("TrapNet", 25, PDFAnnotation.class),
    WATERMARK("Watermark", 26, PDFAnnotation.class),
    THREED("3D", 27, PDFAnnotation.class),
    REDACT("Redact", 28, MarkupAnnotation.class);

    private String definition;
    private int internalId;
    private Class<?> className;

    boolean displayAnnotation() {
        switch (this.ordinal()) {
            case 3: {
                return Configuration.getInstance().isPrintStampAnnotations();
            }
            case 2: {
                return Configuration.getInstance().isPrintWidgetAnnotations();
            }
            case 4: {
                return Configuration.getInstance().isPrintFreetextAnnotations();
            }
            case 1: {
                return Configuration.getInstance().isPrintLinkAnnotations();
            }
            case 5: {
                return Configuration.getInstance().isPrintSignatureFields();
            }
            case 0: {
                return false;
            }
        }
        return MarkupAnnotation.class.isAssignableFrom(this.className) && Configuration.getInstance().isPrintFreetextAnnotations();
    }

    private AnnotationType(String definition, int typeId, Class<?> className) {
        this.definition = definition;
        this.internalId = typeId;
        this.className = className;
    }

    public String getDefinition() {
        return this.definition;
    }

    public int getInternalId() {
        return this.internalId;
    }

    public Class<?> getClassName() {
        return this.className;
    }

    public static AnnotationType getByDefinition(String definition) {
        for (AnnotationType type : AnnotationType.values()) {
            if (!type.definition.equals(definition)) continue;
            return type;
        }
        return UNKNOWN;
    }
}

