/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer;

import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class PdfSubByteSampleModel
extends SampleModel {
    private final int transferBytesPerPixel;
    private final int storageBitsPerPixel;
    private final int bitsPerLine;
    private final int bitsPerBand;
    private final int componentMask;
    private final int[] sampleSize;
    private final int ignoredBitsPerComponentPerByte;

    public PdfSubByteSampleModel(int w, int h, int numComponents, int bitsPerComponent) {
        super(0, w, h, numComponents);
        assert (bitsPerComponent < 8) : "This is designed just for use with per-component sizes of less than 8 bits; you should probably use PixelInterleavedSampleModel";
        assert (bitsPerComponent == 1 || bitsPerComponent == 2 || bitsPerComponent == 4) : "we don't want to grab components across byte boundaries";
        this.transferBytesPerPixel = (numComponents * bitsPerComponent + 7) / 8;
        this.storageBitsPerPixel = numComponents * bitsPerComponent;
        this.bitsPerLine = 8 * ((this.storageBitsPerPixel * w + 7) / 8);
        this.bitsPerBand = bitsPerComponent;
        this.componentMask = (1 << this.bitsPerBand) - 1;
        this.sampleSize = new int[numComponents];
        for (int i = 0; i < this.sampleSize.length; ++i) {
            this.sampleSize[i] = bitsPerComponent;
        }
        this.ignoredBitsPerComponentPerByte = 8 - this.bitsPerBand;
    }

    @Override
    public int getNumDataElements() {
        return this.transferBytesPerPixel;
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        byte[] elements = obj != null ? (byte[])obj : new byte[this.numBands];
        int bitIndex = y * this.bitsPerLine + this.storageBitsPerPixel * x;
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = (byte)this.getComponent(data, bitIndex);
            bitIndex += this.bitsPerBand;
        }
        return elements;
    }

    private int getComponent(DataBuffer data, int aBitIndex) {
        int boffset = aBitIndex >> 3;
        int b = data.getElem(boffset);
        int bitIndexInB = aBitIndex & 7;
        int shift = this.ignoredBitsPerComponentPerByte - bitIndexInB;
        return b >>> shift & this.componentMask;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        return this.getComponent(data, y * this.bitsPerLine + this.storageBitsPerPixel * x + this.bitsPerBand * b);
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public DataBuffer createDataBuffer() {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public int[] getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int getSampleSize(int band) {
        return this.bitsPerBand;
    }
}

