/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import org.openpdf.util.DownscaleQuality;

public class ScalingOptions {
    private final DownscaleQuality downscalingHint;
    private final Object renderingHint;
    private final int targetWidth;
    private final int targetHeight;

    public ScalingOptions(int targetWidth, int targetHeight, DownscaleQuality downscalingHint, Object hint) {
        this.downscalingHint = downscalingHint;
        this.renderingHint = hint;
        this.targetWidth = Math.max(1, targetWidth);
        this.targetHeight = Math.max(1, targetHeight);
    }

    public DownscaleQuality getDownscalingHint() {
        return this.downscalingHint;
    }

    public Object getRenderingHint() {
        return this.renderingHint;
    }

    public void applyRenderingHints(Graphics2D g2) {
        g2.setRenderingHints(this.getRenderingHints());
    }

    protected Map<RenderingHints.Key, Object> getRenderingHints() {
        return Collections.singletonMap(RenderingHints.KEY_INTERPOLATION, this.getRenderingHint());
    }

    public boolean sizeMatches(int w, int h) {
        return w == this.getTargetWidth() && h == this.getTargetHeight();
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public ScalingOptions withTarget(int targetWidth, int targetHeight) {
        return new ScalingOptions(targetWidth, targetHeight, this.downscalingHint, this.renderingHint);
    }
}

