/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.newtable;

import com.google.errorprone.annotations.CheckReturnValue;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.style.derived.BorderPropertySet;

public class CollapsedBorderValue {
    private final @Nullable IdentValue _style;
    private final int _width;
    private final FSColor _color;
    private final int _precedence;

    public CollapsedBorderValue(@Nullable IdentValue style, int width, FSColor color, int precedence) {
        this._style = style;
        this._width = width;
        this._color = color;
        this._precedence = precedence;
    }

    public FSColor color() {
        return this._color;
    }

    @CheckReturnValue
    public @Nullable IdentValue style() {
        return this._style;
    }

    @CheckReturnValue
    public int width() {
        return this._width;
    }

    @CheckReturnValue
    public CollapsedBorderValue withWidth(int width) {
        return new CollapsedBorderValue(this._style, width, this._color, this._precedence);
    }

    @CheckReturnValue
    public int precedence() {
        return this._precedence;
    }

    @CheckReturnValue
    public boolean defined() {
        return this._style != null;
    }

    @CheckReturnValue
    public boolean exists() {
        return this._style != null && this._style != IdentValue.NONE && this._style != IdentValue.HIDDEN;
    }

    @CheckReturnValue
    public boolean hidden() {
        return this._style == IdentValue.HIDDEN;
    }

    @CheckReturnValue
    public static CollapsedBorderValue borderLeft(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.leftStyle(), (int)border.left(), border.leftColor(), precedence);
    }

    @CheckReturnValue
    public static CollapsedBorderValue borderRight(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.rightStyle(), (int)border.right(), border.rightColor(), precedence);
    }

    @CheckReturnValue
    public static CollapsedBorderValue borderTop(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.topStyle(), (int)border.top(), border.topColor(), precedence);
    }

    @CheckReturnValue
    public static CollapsedBorderValue borderBottom(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.bottomStyle(), (int)border.bottom(), border.bottomColor(), precedence);
    }
}

