/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openpdf.context.ContentFunctionFactory;
import org.openpdf.context.StyleReference;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.CounterData;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.CssContext;
import org.openpdf.css.value.FontSpecification;
import org.openpdf.extend.FSCanvas;
import org.openpdf.extend.FontContext;
import org.openpdf.extend.NamespaceHandler;
import org.openpdf.extend.ReplacedElementFactory;
import org.openpdf.extend.TextRenderer;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.layout.BlockFormattingContext;
import org.openpdf.layout.BreakAtLineContext;
import org.openpdf.layout.Layer;
import org.openpdf.layout.LayoutState;
import org.openpdf.layout.SharedContext;
import org.openpdf.layout.StyleTracker;
import org.openpdf.render.Box;
import org.openpdf.render.FSFont;
import org.openpdf.render.FSFontMetrics;
import org.openpdf.render.MarkerData;
import org.openpdf.render.PageBox;

public class LayoutContext
implements CssContext {
    private final SharedContext _sharedContext;
    private @Nullable Layer _rootLayer;
    private StyleTracker _firstLines;
    private StyleTracker _firstLetters;
    private @Nullable MarkerData _currentMarkerData;
    private final Deque<BlockFormattingContext> _blockFormattingContexts = new ArrayDeque<BlockFormattingContext>();
    private final Deque<Layer> _layers = new ArrayDeque<Layer>();
    private final FontContext _fontContext;
    private final ContentFunctionFactory _contentFunctionFactory = new ContentFunctionFactory();
    private int _extraSpaceTop;
    private int _extraSpaceBottom;
    private final Map<CalculatedStyle, CounterContext> _counterContextMap = new HashMap<CalculatedStyle, CounterContext>();
    private @Nullable String _pendingPageName;
    private @Nullable String _pageName;
    private int _noPageBreak;
    private @Nullable Layer _rootDocumentLayer;
    private @Nullable PageBox _page;
    private boolean _mayCheckKeepTogether = true;
    private @Nullable BreakAtLineContext _breakAtLineContext;

    public TextRenderer getTextRenderer() {
        return this._sharedContext.getTextRenderer();
    }

    @Override
    @CheckReturnValue
    public StyleReference getCss() {
        return this._sharedContext.getCss();
    }

    public FSCanvas getCanvas() {
        return this._sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        return this._sharedContext.getFixedRectangle();
    }

    public NamespaceHandler getNamespaceHandler() {
        return this._sharedContext.getNamespaceHandler();
    }

    LayoutContext(SharedContext sharedContext, FontContext fontContext) {
        this._sharedContext = sharedContext;
        this._firstLines = new StyleTracker();
        this._firstLetters = new StyleTracker();
        this._fontContext = fontContext;
    }

    public void reInit(boolean keepLayers) {
        this._firstLines = new StyleTracker();
        this._firstLetters = new StyleTracker();
        this._currentMarkerData = null;
        this._blockFormattingContexts.clear();
        if (!keepLayers) {
            this._rootLayer = null;
            this._layers.clear();
        }
        this._extraSpaceTop = 0;
        this._extraSpaceBottom = 0;
    }

    public LayoutState captureLayoutState() {
        return this.isPrint() ? new LayoutState(this._firstLines, this._firstLetters, this._currentMarkerData, this._blockFormattingContexts, this.getPageName(), this.getExtraSpaceBottom(), this.getExtraSpaceTop(), this.getNoPageBreak()) : new LayoutState(this._firstLines, this._firstLetters, this._currentMarkerData, this._blockFormattingContexts);
    }

    public void restoreLayoutState(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        this._blockFormattingContexts.clear();
        this._blockFormattingContexts.addAll(layoutState.getBFCs());
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
            this.setExtraSpaceBottom(layoutState.getExtraSpaceBottom());
            this.setExtraSpaceTop(layoutState.getExtraSpaceTop());
            this.setNoPageBreak(layoutState.getNoPageBreak());
        }
    }

    public LayoutState copyStateForRelayout() {
        return this.isPrint() ? new LayoutState(this._firstLines.copyOf(), this._firstLetters.copyOf(), this._currentMarkerData, Collections.emptyList(), this.getPageName(), 0, 0, 0) : new LayoutState(this._firstLines.copyOf(), this._firstLetters.copyOf(), this._currentMarkerData, Collections.emptyList());
    }

    public void restoreStateForRelayout(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
        }
    }

    public BlockFormattingContext getBlockFormattingContext() {
        return this._blockFormattingContexts.getLast();
    }

    public void pushBFC(BlockFormattingContext bfc) {
        this._blockFormattingContexts.add(bfc);
    }

    public void popBFC() {
        this._blockFormattingContexts.removeLast();
    }

    public void pushLayer(Box master) {
        Layer layer;
        if (this._rootLayer == null) {
            this._rootLayer = layer = new Layer(master);
        } else {
            Layer parent = this.getLayer();
            layer = new Layer(parent, master);
            parent.addChild(layer);
        }
        this.pushLayer(layer);
    }

    public void pushLayer(Layer layer) {
        this._layers.add(layer);
    }

    public void popLayer() {
        Layer layer = this.getLayer();
        layer.finish(this);
        this._layers.removeLast();
    }

    public Layer getLayer() {
        return this._layers.getLast();
    }

    public @Nullable Layer getRootLayer() {
        return this._rootLayer;
    }

    public void translate(int x, int y) {
        this.getBlockFormattingContext().translate(x, y);
    }

    public void addBoxId(String id, Box box) {
        this._sharedContext.addBoxId(id, box);
    }

    public void removeBoxId(String id) {
        this._sharedContext.removeBoxId(id);
    }

    public boolean isInteractive() {
        return this._sharedContext.isInteractive();
    }

    @Override
    public float getMmPerDot() {
        return this._sharedContext.getMmPerPx();
    }

    @Override
    public int getDotsPerPixel() {
        return this._sharedContext.getDotsPerPixel();
    }

    @Override
    public float getFontSize2D(FontSpecification font) {
        return this._sharedContext.getFont(font).getSize2D();
    }

    @Override
    public float getXHeight(FontSpecification parentFont) {
        return this._sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    @Override
    @CheckReturnValue
    public @Nullable FSFont getFont(FontSpecification font) {
        return this._sharedContext.getFont(font);
    }

    @CheckReturnValue
    public UserAgentCallback getUac() {
        return this._sharedContext.getUac();
    }

    public boolean isPrint() {
        return this._sharedContext.isPrint();
    }

    public StyleTracker getFirstLinesTracker() {
        return this._firstLines;
    }

    public StyleTracker getFirstLettersTracker() {
        return this._firstLetters;
    }

    @CheckReturnValue
    public @Nullable MarkerData getCurrentMarkerData() {
        return this._currentMarkerData;
    }

    public void setCurrentMarkerData(@Nullable MarkerData currentMarkerData) {
        this._currentMarkerData = currentMarkerData;
    }

    public ReplacedElementFactory getReplacedElementFactory() {
        return this._sharedContext.getReplacedElementFactory();
    }

    public FontContext getFontContext() {
        return this._fontContext;
    }

    public ContentFunctionFactory getContentFunctionFactory() {
        return this._contentFunctionFactory;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public int getExtraSpaceBottom() {
        return this._extraSpaceBottom;
    }

    public void setExtraSpaceBottom(int extraSpaceBottom) {
        this._extraSpaceBottom = extraSpaceBottom;
    }

    public int getExtraSpaceTop() {
        return this._extraSpaceTop;
    }

    public void setExtraSpaceTop(int extraSpaceTop) {
        this._extraSpaceTop = extraSpaceTop;
    }

    public void resolveCounters(CalculatedStyle style, @Nullable Integer startIndex) {
        CounterContext cc = new CounterContext(this, style, startIndex);
        this._counterContextMap.put(style, cc);
    }

    public void resolveCounters(CalculatedStyle style) {
        this.resolveCounters(style, null);
    }

    public CounterContext getCounterContext(CalculatedStyle style) {
        return this._counterContextMap.get(style);
    }

    @Override
    @CheckReturnValue
    public FSFontMetrics getFSFontMetrics(FSFont font) {
        return this.getTextRenderer().getFSFontMetrics(this.getFontContext(), font, "");
    }

    @CheckReturnValue
    public @Nullable String getPageName() {
        return this._pageName;
    }

    public void setPageName(@Nullable String currentPageName) {
        this._pageName = currentPageName;
    }

    public int getNoPageBreak() {
        return this._noPageBreak;
    }

    public void setNoPageBreak(int noPageBreak) {
        this._noPageBreak = noPageBreak;
    }

    public boolean isPageBreaksAllowed() {
        return this._noPageBreak == 0;
    }

    @CheckReturnValue
    public @Nullable String getPendingPageName() {
        return this._pendingPageName;
    }

    public void setPendingPageName(@Nullable String pendingPageName) {
        this._pendingPageName = pendingPageName;
    }

    @CheckReturnValue
    public @Nullable Layer getRootDocumentLayer() {
        return this._rootDocumentLayer;
    }

    public void setRootDocumentLayer(Layer rootDocumentLayer) {
        this._rootDocumentLayer = rootDocumentLayer;
    }

    @CheckReturnValue
    public @Nullable PageBox getPage() {
        return this._page;
    }

    public void setPage(PageBox page) {
        this._page = page;
    }

    public boolean isMayCheckKeepTogether() {
        return this._mayCheckKeepTogether;
    }

    public void setMayCheckKeepTogether(boolean mayKeepTogether) {
        this._mayCheckKeepTogether = mayKeepTogether;
    }

    @CheckReturnValue
    public @Nullable BreakAtLineContext getBreakAtLineContext() {
        return this._breakAtLineContext;
    }

    public void setBreakAtLineContext(@Nullable BreakAtLineContext breakAtLineContext) {
        this._breakAtLineContext = breakAtLineContext;
    }

    public class CounterContext {
        private final Map<String, Integer> _counters = new HashMap<String, Integer>();
        private @Nullable CounterContext _parent;

        CounterContext(LayoutContext this$0, @Nullable CalculatedStyle style, Integer startIndex) {
            List<CounterData> increments;
            List<CounterData> resets;
            if (startIndex != null) {
                this._counters.put("list-item", startIndex);
            }
            this._parent = this$0._counterContextMap.get(style.getParent());
            if (this._parent == null) {
                this._parent = new CounterContext(this$0);
            }
            if ((resets = style.getCounterReset()) != null) {
                for (CounterData cd : resets) {
                    this._parent.resetCounter(cd);
                }
            }
            if ((increments = style.getCounterIncrement()) != null) {
                for (CounterData cd : increments) {
                    if (this._parent.incrementCounter(cd)) continue;
                    this._parent.resetCounter(new CounterData(cd.getName(), 0));
                    this._parent.incrementCounter(cd);
                }
            }
            if (style.isIdent(CSSName.DISPLAY, IdentValue.LIST_ITEM)) {
                if (startIndex != null) {
                    this._parent._counters.put("list-item", startIndex);
                }
                this._parent.incrementListItemCounter(1);
            }
        }

        private CounterContext(LayoutContext this$0) {
        }

        private boolean incrementCounter(CounterData cd) {
            if ("list-item".equals(cd.getName())) {
                this.incrementListItemCounter(cd.getValue());
                return true;
            }
            Integer currentValue = this._counters.get(cd.getName());
            if (currentValue == null) {
                if (this._parent == null) {
                    return false;
                }
                return this._parent.incrementCounter(cd);
            }
            this._counters.put(cd.getName(), currentValue + cd.getValue());
            return true;
        }

        private void incrementListItemCounter(int increment) {
            Integer currentValue = this._counters.get("list-item");
            if (currentValue == null) {
                currentValue = 0;
            }
            this._counters.put("list-item", currentValue + increment);
        }

        private void resetCounter(CounterData cd) {
            this._counters.put(cd.getName(), cd.getValue());
        }

        public int getCurrentCounterValue(String name) {
            Integer value = this._parent.getCounter(name);
            if (value == null) {
                this._parent.resetCounter(new CounterData(name, 0));
                return 0;
            }
            return value;
        }

        private @Nullable Integer getCounter(String name) {
            Integer value = this._counters.get(name);
            if (value != null) {
                return value;
            }
            if (this._parent == null) {
                return null;
            }
            return this._parent.getCounter(name);
        }

        public List<Integer> getCurrentCounterValues(String name) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            this._parent.getCounterValues(name, values);
            if (values.isEmpty()) {
                this._parent.resetCounter(new CounterData(name, 0));
                values.add(0);
            }
            return values;
        }

        private void getCounterValues(String name, List<Integer> values) {
            Integer value;
            if (this._parent != null) {
                this._parent.getCounterValues(name, values);
            }
            if ((value = this._counters.get(name)) != null) {
                values.add(value);
            }
        }
    }
}

