/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.openpdf.css.constants.IdentValue;

public class CounterFunction {
    private final IdentValue _listStyleType;
    private int _counterValue;
    private List<Integer> _counterValues;
    private String _separator;

    public CounterFunction(int counterValue, IdentValue listStyleType) {
        this._counterValue = counterValue;
        this._listStyleType = listStyleType;
    }

    public CounterFunction(List<Integer> counterValues, String separator, IdentValue listStyleType) {
        this._counterValues = counterValues;
        this._separator = separator;
        this._listStyleType = listStyleType;
    }

    public String evaluate() {
        if (this._counterValues == null) {
            return CounterFunction.createCounterText(this._listStyleType, this._counterValue);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> i = this._counterValues.iterator();
        while (i.hasNext()) {
            Integer value = i.next();
            sb.append(CounterFunction.createCounterText(this._listStyleType, value));
            if (!i.hasNext()) continue;
            sb.append(this._separator);
        }
        return sb.toString();
    }

    public static String createCounterText(IdentValue listStyle, int listCounter) {
        if (listStyle == IdentValue.LOWER_LATIN || listStyle == IdentValue.LOWER_ALPHA) {
            return CounterFunction.toLatin(listCounter).toLowerCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.UPPER_LATIN || listStyle == IdentValue.UPPER_ALPHA) {
            return CounterFunction.toLatin(listCounter).toUpperCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.LOWER_ROMAN) {
            return CounterFunction.toRoman(listCounter).toLowerCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.UPPER_ROMAN) {
            return CounterFunction.toRoman(listCounter).toUpperCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.DECIMAL_LEADING_ZERO) {
            return (listCounter >= 10 ? "" : "0") + listCounter;
        }
        return Integer.toString(listCounter);
    }

    private static String toLatin(int index) {
        StringBuilder result = new StringBuilder(5);
        int val = index - 1;
        while (val >= 0) {
            int letter = val % 26;
            val = val / 26 - 1;
            result.insert(0, (char)(letter + 65));
        }
        return result.toString();
    }

    private static String toRoman(int val) {
        int[] ints = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] nums = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ints.length; ++i) {
            int count = val / ints[i];
            sb.append(nums[i].repeat(Math.max(0, count)));
            val -= ints[i] * count;
        }
        return sb.toString();
    }
}

