/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.sheet;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StylesheetInfo {
    private final String uri;
    private final Origin origin;
    private final List<String> mediaTypes;
    private final @Nullable String content;

    public StylesheetInfo(Origin origin, String uri, List<String> mediaTypes, @Nullable String content) {
        this.origin = origin;
        this.uri = uri;
        this.mediaTypes = mediaTypes;
        this.content = content;
    }

    public boolean appliesToMedia(String media) {
        String mLowerCase = media.toLowerCase(Locale.ROOT);
        return mLowerCase.equals("all") || this.mediaTypes.contains("all") || this.mediaTypes.contains(mLowerCase);
    }

    public static List<String> mediaTypes(String media) {
        if (media.isEmpty()) {
            return List.of("all");
        }
        return Stream.of(media.split(",")).map(mediaType -> mediaType.trim().toLowerCase(Locale.ROOT)).toList();
    }

    @CheckReturnValue
    public String getUri() {
        return this.uri;
    }

    @CheckReturnValue
    public @NonNull List<String> getMedia() {
        return this.mediaTypes;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    @CheckReturnValue
    public Optional<String> getContent() {
        return Optional.ofNullable(this.content);
    }

    public String toString() {
        return "CSS %s".formatted(this.uri);
    }

    public static enum Origin {
        USER_AGENT,
        USER,
        AUTHOR;

    }
}

