/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.simple;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.sheet.StylesheetInfo;
import org.openpdf.extend.NamespaceHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class NoNamespaceHandler
implements NamespaceHandler {
    private static final String _namespace = "http://www.w3.org/XML/1998/namespace";
    private static final Pattern _typePattern = Pattern.compile("type\\s?=\\s?");
    private static final Pattern _hrefPattern = Pattern.compile("href\\s?=\\s?");
    private static final Pattern _alternatePattern = Pattern.compile("alternate\\s?=\\s?");
    private static final Pattern _mediaPattern = Pattern.compile("media\\s?=\\s?");

    @Override
    @CheckReturnValue
    public String getNamespace() {
        return _namespace;
    }

    @Override
    @CheckReturnValue
    public String getAttributeValue(Element e, String attrName) {
        return e.getAttribute(attrName);
    }

    @Override
    @CheckReturnValue
    public String getAttributeValue(Element e, @Nullable String namespaceURI, String attrName) {
        if ("".equals(namespaceURI)) {
            return e.getAttribute(attrName);
        }
        if (namespaceURI == null) {
            if (e.getLocalName() == null) {
                return e.getAttribute(attrName);
            }
            NamedNodeMap attrs = e.getAttributes();
            int l = attrs.getLength();
            for (int i = 0; i < l; ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (!attrName.equals(attr.getLocalName())) continue;
                return attr.getValue();
            }
            return "";
        }
        return e.getAttributeNS(namespaceURI, attrName);
    }

    @Override
    @CheckReturnValue
    public @Nullable String getClass(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getID(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public String getLang(Element e) {
        return e.getAttribute("lang");
    }

    @Override
    @CheckReturnValue
    public @Nullable String getElementStyling(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getNonCssStyling(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getLinkUri(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getDocumentTitle(Document doc) {
        return null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getAnchorName(@Nullable Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean isImageElement(Element e) {
        return false;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getImageSourceURI(Element e) {
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean isFormElement(Element e) {
        return false;
    }

    @Override
    @CheckReturnValue
    public List<StylesheetInfo> getStylesheets(Document doc) {
        ArrayList<StylesheetInfo> list = new ArrayList<StylesheetInfo>();
        NodeList nl = doc.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            String type;
            int start;
            String alternate;
            String pi;
            Matcher m;
            ProcessingInstruction piNode;
            Node node = nl.item(i);
            if (node.getNodeType() != 7 || !(piNode = (ProcessingInstruction)node).getTarget().equals("xml-stylesheet") || (m = _alternatePattern.matcher(pi = piNode.getData())).matches() && (alternate = pi.substring((start = m.end()) + 1, pi.indexOf(pi.charAt(start), start + 1))).equals("yes") || !Objects.equals(type = this.detectType(pi), "text/css")) continue;
            StylesheetInfo info = new StylesheetInfo(StylesheetInfo.Origin.AUTHOR, this.detectUri(pi), StylesheetInfo.mediaTypes(this.detectMediaTypes(pi)), null);
            list.add(info);
        }
        return list;
    }

    @CheckReturnValue
    private @Nullable String detectType(String pi) {
        Matcher m = _typePattern.matcher(pi);
        if (m.find()) {
            int start = m.end();
            return pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
        }
        return null;
    }

    @CheckReturnValue
    private @Nullable String detectUri(String pi) {
        Matcher m = _hrefPattern.matcher(pi);
        if (m.find()) {
            int start = m.end();
            return pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
        }
        return null;
    }

    @CheckReturnValue
    private @NonNull String detectMediaTypes(String pi) {
        Matcher m = _mediaPattern.matcher(pi);
        if (m.find()) {
            int start = m.end();
            return pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
        }
        return "screen";
    }

    @Override
    @CheckReturnValue
    public Optional<StylesheetInfo> getDefaultStylesheet() {
        return Optional.empty();
    }
}

