/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.render;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.FSRGBColor;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.CssContext;
import org.openpdf.layout.BoxCollector;
import org.openpdf.layout.InlineBoxing;
import org.openpdf.layout.InlinePaintable;
import org.openpdf.layout.Layer;
import org.openpdf.layout.LayoutContext;
import org.openpdf.layout.PaintingInfo;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.CharCounts;
import org.openpdf.render.ContentLimitContainer;
import org.openpdf.render.FloatDistances;
import org.openpdf.render.InlineLayoutBox;
import org.openpdf.render.InlineText;
import org.openpdf.render.JustificationInfo;
import org.openpdf.render.MarkerData;
import org.openpdf.render.PageBox;
import org.openpdf.render.RenderingContext;
import org.openpdf.render.TextDecoration;
import org.openpdf.util.XRRuntimeException;
import org.w3c.dom.Element;

public class LineBox
extends Box
implements InlinePaintable {
    private static final float JUSTIFY_NON_SPACE_SHARE = 0.2f;
    private static final float JUSTIFY_SPACE_SHARE = 0.8f;
    private boolean _endsOnNL;
    private boolean _containsContent;
    private boolean _containsBlockLevelContent;
    private @Nullable FloatDistances _floatDistances;
    private @Nullable List<TextDecoration> _textDecorations;
    private int _paintingTop;
    private int _paintingHeight;
    private @Nullable List<Box> _nonFlowContent;
    private @Nullable MarkerData _markerData;
    private boolean _containsDynamicFunction;
    private int _contentStart;
    private int _baseline;
    private @Nullable JustificationInfo _justificationInfo;

    public LineBox(@Nullable Box parent, @Nullable CalculatedStyle style) {
        super(parent, style);
    }

    @Override
    public String dump(LayoutContext c, String indent, Box.Dump which) {
        if (which != Box.Dump.RENDER) {
            throw new IllegalArgumentException(String.format("Unsupported which: %s (expected: %s)", new Object[]{which, Box.Dump.RENDER}));
        }
        StringBuilder result = new StringBuilder(indent);
        result.append(this);
        result.append('\n');
        this.dumpBoxes(c, indent, this.getNonFlowContent(), Box.Dump.RENDER, result);
        if (!this.getNonFlowContent().isEmpty()) {
            result.append('\n');
        }
        this.dumpBoxes(c, indent, this.getChildren(), Box.Dump.RENDER, result);
        return result.toString();
    }

    @Override
    public Rectangle getMarginEdge(CssContext cssCtx, int tx, int ty) {
        Rectangle result = new Rectangle(this.getX(), this.getY(), this.getContentWidth(), this.getHeight());
        result.translate(tx, ty);
        return result;
    }

    @Override
    public void paintInline(RenderingContext c) {
        if (!this.getParent().getStyle().isVisible()) {
            return;
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c);
            int totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c, this, 0);
            this.setContentWidth(totalLineWidth);
            this.calcChildLocations();
            this.align(true);
            this.calcPaintingInfo(c, false);
        }
        if (this._textDecorations != null) {
            c.getOutputDevice().drawTextDecoration(c, this);
        }
        if (c.debugDrawLineBoxes()) {
            c.getOutputDevice().drawDebugOutline(c, this, FSRGBColor.GREEN);
        }
    }

    private void lookForDynamicFunctions(RenderingContext c) {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Box b = this.getChild(i);
                if (!(b instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)b).lookForDynamicFunctions(c);
            }
        }
    }

    public boolean isFirstLine() {
        Box parent = this.getParent();
        return parent != null && parent.getChildCount() > 0 && parent.getChild(0) == this;
    }

    public void prunePendingInlineBoxes() {
        if (this.getChildCount() > 0) {
            Box b;
            for (int i = this.getChildCount() - 1; i >= 0 && (b = this.getChild(i)) instanceof InlineLayoutBox; --i) {
                InlineLayoutBox iB = (InlineLayoutBox)b;
                iB.prunePending();
                if (!iB.isPending()) continue;
                this.removeChild(i);
            }
        }
    }

    public boolean isContainsContent() {
        return this._containsContent;
    }

    public void setContainsContent(boolean containsContent) {
        this._containsContent = containsContent;
    }

    public boolean isEndsOnNL() {
        return this._endsOnNL;
    }

    public void setEndsOnNL(boolean endsOnNL) {
        this._endsOnNL = endsOnNL;
    }

    public void align(boolean dynamic) {
        IdentValue align = this.getParent().getStyle().getIdent(CSSName.TEXT_ALIGN);
        int calcX = 0;
        if (align == IdentValue.LEFT || align == IdentValue.JUSTIFY) {
            int floatDistance = this.getFloatDistances().leftFloatDistance();
            calcX = this.getContentStart() + floatDistance;
            if (align == IdentValue.JUSTIFY && dynamic) {
                this.justify();
            }
        } else if (align == IdentValue.CENTER) {
            int leftFloatDistance = this.getFloatDistances().leftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().rightFloatDistance();
            int midpoint = leftFloatDistance + (this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance) / 2;
            calcX = midpoint - (this.getContentWidth() + this.getContentStart()) / 2;
        } else if (align == IdentValue.RIGHT) {
            int floatDistance = this.getFloatDistances().rightFloatDistance();
            calcX = this.getParent().getContentWidth() - floatDistance - this.getContentWidth();
        }
        if (calcX != this.getX()) {
            this.setX(calcX);
            this.calcCanvasLocation();
            this.calcChildLocations();
        }
    }

    public void justify() {
        if (!this.isLastLineWithContent()) {
            int leftFloatDistance = this.getFloatDistances().leftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().rightFloatDistance();
            int available = this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance - this.getContentStart();
            if (available > this.getContentWidth()) {
                int toAdd = available - this.getContentWidth();
                CharCounts counts = this.countJustifiableChars();
                JustificationInfo info = !this.getParent().getStyle().isIdent(CSSName.LETTER_SPACING, IdentValue.NORMAL) ? new JustificationInfo(0.0f, (float)toAdd / (float)counts.getSpaceCount()) : LineBox.justificationInfo(counts, toAdd);
                this.adjustChildren(info);
                this.setJustificationInfo(info);
            }
        }
    }

    private static JustificationInfo justificationInfo(CharCounts counts, int toAdd) {
        float nonSpaceAdjust = counts.getNonSpaceCount() > 1 ? (float)toAdd * 0.2f / (float)(counts.getNonSpaceCount() - 1) : 0.0f;
        float spaceAdjust = counts.getSpaceCount() > 0 ? (float)toAdd * 0.8f / (float)counts.getSpaceCount() : 0.0f;
        return new JustificationInfo(nonSpaceAdjust, spaceAdjust);
    }

    private void adjustChildren(JustificationInfo info) {
        float adjust = 0.0f;
        for (Box b : this.getChildren()) {
            b.setX(b.getX() + Math.round(adjust));
            if (!(b instanceof InlineLayoutBox)) continue;
            adjust += ((InlineLayoutBox)b).adjustHorizontalPosition(info, adjust);
        }
        this.calcChildLocations();
    }

    private boolean isLastLineWithContent() {
        if (!this._endsOnNL) {
            for (LineBox current = (LineBox)this.getNextSibling(); current != null; current = (LineBox)current.getNextSibling()) {
                if (!current.isContainsContent()) continue;
                return false;
            }
        }
        return true;
    }

    private CharCounts countJustifiableChars() {
        CharCounts result = new CharCounts();
        for (Box b : this.getChildren()) {
            if (!(b instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)b).countJustifiableChars(result);
        }
        return result;
    }

    public FloatDistances getFloatDistances() {
        return this._floatDistances;
    }

    public void setFloatDistances(@Nullable FloatDistances floatDistances) {
        this._floatDistances = floatDistances;
    }

    public boolean isContainsBlockLevelContent() {
        return this._containsBlockLevelContent;
    }

    public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
        this._containsBlockLevelContent = containsBlockLevelContent;
    }

    @Override
    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || this.intersectsLine(cssCtx, clip) || this.isContainsBlockLevelContent() && this.intersectsInlineBlocks(cssCtx, clip);
    }

    private boolean intersectsLine(CssContext cssCtx, Shape clip) {
        Rectangle result = this.getPaintingClipEdge(cssCtx);
        return clip.intersects(result);
    }

    @Override
    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        Box parent = this.getParent();
        if (parent.getStyle().isIdent(CSSName.FS_TEXT_DECORATION_EXTENT, IdentValue.BLOCK) || this.getJustificationInfo() != null) {
            return new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, parent.getAbsX() + parent.getTx() + parent.getContentWidth() - this.getAbsX(), this._paintingHeight);
        }
        return new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, this.getContentWidth(), this._paintingHeight);
    }

    private boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            BoxCollector collector;
            boolean possibleResult;
            Box child = this.getChild(i);
            if (!(child instanceof InlineLayoutBox ? (possibleResult = ((InlineLayoutBox)child).intersectsInlineBlocks(cssCtx, clip)) : (collector = new BoxCollector()).intersectsAny(cssCtx, clip, child))) continue;
            return true;
        }
        return false;
    }

    @CheckReturnValue
    public @Nullable List<TextDecoration> getTextDecorations() {
        return this._textDecorations;
    }

    public void setTextDecorations(List<TextDecoration> textDecorations) {
        this._textDecorations = textDecorations;
    }

    public int getPaintingHeight() {
        return this._paintingHeight;
    }

    public void setPaintingHeight(int paintingHeight) {
        this._paintingHeight = paintingHeight;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public void addAllChildren(List<Box> list, Layer layer) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            if (this.getContainingLayer() != layer) continue;
            list.add(child);
            if (!(child instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)child).addAllChildren(list, layer);
        }
    }

    @CheckReturnValue
    public List<Box> getNonFlowContent() {
        return this._nonFlowContent == null ? Collections.emptyList() : this._nonFlowContent;
    }

    public void addNonFlowContent(BlockBox box) {
        if (this._nonFlowContent == null) {
            this._nonFlowContent = new ArrayList<Box>();
        }
        this._nonFlowContent.add(box);
    }

    @Override
    public void reset(LayoutContext c) {
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = this.getNonFlowContent().get(i);
            content.reset(c);
        }
        if (this._markerData != null) {
            this._markerData.restorePreviousReferenceLine(this);
        }
        super.reset(c);
    }

    @Override
    public void calcCanvasLocation() {
        Box parent = this.getParent();
        if (parent == null) {
            throw new XRRuntimeException("calcCanvasLocation() called with no parent");
        }
        this.setAbsX(parent.getAbsX() + parent.getTx() + this.getX());
        this.setAbsY(parent.getAbsY() + parent.getTy() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        super.calcChildLocations();
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = this.getNonFlowContent().get(i);
            if (!content.getStyle().isAbsolute()) continue;
            content.calcCanvasLocation();
            content.calcChildLocations();
        }
    }

    @CheckReturnValue
    public @Nullable MarkerData getMarkerData() {
        return this._markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this._markerData = markerData;
    }

    public boolean isContainsDynamicFunction() {
        return this._containsDynamicFunction;
    }

    public void setContainsDynamicFunction(boolean containsPageCounter) {
        this._containsDynamicFunction |= containsPageCounter;
    }

    public int getContentStart() {
        return this._contentStart;
    }

    public void setContentStart(int contentOffset) {
        this._contentStart = contentOffset;
    }

    @CheckReturnValue
    public @Nullable InlineText findTrailingText() {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (int offset = this.getChildCount() - 1; offset >= 0; --offset) {
            Box child = this.getChild(offset);
            if (child instanceof InlineLayoutBox) {
                InlineText result = ((InlineLayoutBox)child).findTrailingText();
                if (result != null && result.isEmpty()) continue;
                return result;
            }
            return null;
        }
        return null;
    }

    public void trimTrailingSpace(LayoutContext c) {
        InlineLayoutBox iB;
        IdentValue whitespace;
        InlineText text = this.findTrailingText();
        if (text != null && ((whitespace = (iB = text.getParent()).getStyle().getWhitespace()) == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP)) {
            text.trimTrailingSpace(c);
        }
    }

    @Override
    @CheckReturnValue
    public @Nullable Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            Box result = child.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public boolean isContainsOnlyBlockLevelContent() {
        if (!this.isContainsBlockLevelContent()) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box b = this.getChild(i);
            if (b instanceof BlockBox) continue;
            return false;
        }
        return true;
    }

    @Override
    public Box getRestyleTarget() {
        return this.getParent();
    }

    @Override
    public void restyle(LayoutContext c) {
        Box parent = this.getParent();
        Element e = parent.getElement();
        if (e != null) {
            CalculatedStyle style = c.getSharedContext().getStyle(e, true);
            this.setStyle(style.createAnonymousStyle(IdentValue.BLOCK));
        }
        this.restyleChildren(c);
    }

    public boolean isContainsVisibleContent() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean maybeResult;
            Box b = this.getChild(i);
            if (!(b instanceof BlockBox ? b.getWidth() > 0 || b.getHeight() > 0 : (maybeResult = ((InlineLayoutBox)b).isContainsVisibleContent()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearSelection(List<Box> modified) {
        for (Box b : this.getNonFlowContent()) {
            b.clearSelection(modified);
        }
        super.clearSelection(modified);
    }

    @Override
    public void selectAll() {
        for (Box value : this.getNonFlowContent()) {
            BlockBox box = (BlockBox)value;
            box.selectAll();
        }
        super.selectAll();
    }

    @Override
    public void collectText(RenderingContext c, StringBuilder buffer) throws IOException {
        for (Box b : this.getNonFlowContent()) {
            b.collectText(c, buffer);
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c);
        }
        super.collectText(c, buffer);
    }

    @Override
    public void exportText(RenderingContext c, Writer writer) throws IOException {
        int baselinePos = this.getAbsY() + this.getBaseline();
        if (baselinePos >= c.getPage().getBottom() && this.isInDocumentFlow()) {
            this.exportPageBoxText(c, writer, baselinePos);
        }
        for (Box b : this.getNonFlowContent()) {
            b.exportText(c, writer);
        }
        if (this.isContainsContent()) {
            StringBuilder result = new StringBuilder();
            this.collectText(c, result);
            writer.write(result.toString().trim());
            writer.write(System.lineSeparator());
        }
    }

    @Override
    public void analyzePageBreaks(LayoutContext c, ContentLimitContainer container) {
        container.updateTop(c, this.getAbsY());
        container.updateBottom(c, this.getAbsY() + this.getHeight());
    }

    public void checkPagePosition(LayoutContext c, boolean alwaysBreak) {
        if (!c.isPageBreaksAllowed()) {
            return;
        }
        PageBox pageBox = c.getRootLayer().getFirstPage(c, this);
        if (pageBox != null) {
            boolean needsPageBreak;
            boolean bl = needsPageBreak = alwaysBreak || this.getAbsY() + this.getHeight() >= pageBox.getBottom() - c.getExtraSpaceBottom();
            if (needsPageBreak) {
                this.forcePageBreakBefore(c, IdentValue.ALWAYS, false);
                this.calcCanvasLocation();
            } else if (pageBox.getTop() + c.getExtraSpaceTop() > this.getAbsY()) {
                int diff = pageBox.getTop() + c.getExtraSpaceTop() - this.getAbsY();
                this.setY(this.getY() + diff);
                this.calcCanvasLocation();
            }
        }
    }

    public JustificationInfo getJustificationInfo() {
        return this._justificationInfo;
    }

    private void setJustificationInfo(JustificationInfo justificationInfo) {
        this._justificationInfo = justificationInfo;
    }
}

