/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jspecify.annotations.Nullable;
import org.openpdf.extend.FSImage;
import org.openpdf.pdf.ITextFSImage;
import org.openpdf.pdf.ITextOutputDevice;
import org.openpdf.pdf.PDFAsImage;
import org.openpdf.resource.ImageResource;
import org.openpdf.swing.NaiveUserAgent;
import org.openpdf.text.BadElementException;
import org.openpdf.text.Image;
import org.openpdf.text.Rectangle;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.util.Configuration;
import org.openpdf.util.ContentTypeDetectingInputStreamWrapper;
import org.openpdf.util.IOUtil;
import org.openpdf.util.ImageUtil;
import org.openpdf.util.XRLog;

public class ITextUserAgent
extends NaiveUserAgent {
    private static final int IMAGE_CACHE_CAPACITY = 32;
    private final ITextOutputDevice _outputDevice;
    private final int dotsPerPixel;

    public ITextUserAgent(ITextOutputDevice outputDevice, int dotsPerPixel) {
        super(Configuration.valueAsInt("xr.image.cache-capacity", 32));
        this._outputDevice = outputDevice;
        this.dotsPerPixel = dotsPerPixel;
    }

    int getDotsPerPixel() {
        return this.dotsPerPixel;
    }

    @Override
    public ImageResource getImageResource(String uriStr) {
        ImageResource resource;
        String unresolvedUri = uriStr;
        if (!ImageUtil.isEmbeddedBase64Image(uriStr)) {
            uriStr = this.resolveURI(uriStr);
        }
        if ((resource = (ImageResource)this._imageCache.get(unresolvedUri)) == null) {
            resource = this.loadImageResource(uriStr);
            this._imageCache.put(unresolvedUri, resource);
        }
        if (resource != null) {
            FSImage image = resource.getImage();
            if (image instanceof ITextFSImage) {
                image = (FSImage)((ITextFSImage)resource.getImage()).clone();
            }
            return new ImageResource(resource.getImageUri(), image);
        }
        return new ImageResource(uriStr, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private @Nullable ImageResource loadImageResource(String uriStr) {
        block16: {
            if (ImageUtil.isEmbeddedBase64Image(uriStr)) {
                return this.loadEmbeddedBase64ImageResource(uriStr);
            }
            try (InputStream is = this.resolveAndOpenStream(uriStr);){
                ContentTypeDetectingInputStreamWrapper cis;
                block17: {
                    ImageResource imageResource;
                    if (is == null) break block16;
                    cis = new ContentTypeDetectingInputStreamWrapper(is);
                    try {
                        if (!cis.isPdf()) break block17;
                        URI uri = new URI(uriStr);
                        PdfReader reader = this._outputDevice.getReader(uri);
                        Rectangle rect = reader.getPageSizeWithRotation(1);
                        float initialWidth = rect.getWidth() * this._outputDevice.getDotsPerPoint();
                        float initialHeight = rect.getHeight() * this._outputDevice.getDotsPerPoint();
                        PDFAsImage image = new PDFAsImage(uri, initialWidth, initialHeight);
                        imageResource = new ImageResource(uriStr, image);
                    }
                    catch (Throwable throwable) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    cis.close();
                    return imageResource;
                }
                Image image = Image.getInstance((byte[])IOUtil.readBytes(cis));
                this.scaleToOutputResolution(image);
                ImageResource imageResource = new ImageResource(uriStr, new ITextFSImage(image));
                cis.close();
                return imageResource;
            }
            catch (IOException | URISyntaxException | BadElementException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + uriStr + "'", e);
            }
        }
        return null;
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        try {
            byte[] buffer = ImageUtil.getEmbeddedBase64Image(uri);
            Image image = Image.getInstance((byte[])buffer);
            this.scaleToOutputResolution(image);
            return new ImageResource(null, new ITextFSImage(image));
        }
        catch (IOException | BadElementException e) {
            XRLog.exception("Can't read XHTML embedded image.", e);
            return new ImageResource(null, null);
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.dotsPerPixel;
        if (factor != 1.0f) {
            image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
        }
    }
}

