/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.sheet;

import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.PropertyValue;
import org.openpdf.css.sheet.StylesheetInfo;
import org.w3c.dom.css.CSSPrimitiveValue;

public class PropertyDeclaration {
    private final String propName;
    private final CSSName cssName;
    private final CSSPrimitiveValue cssPrimitiveValue;
    private final boolean important;
    private final StylesheetInfo.Origin origin;
    private IdentValue _identVal;
    private boolean identIsSet;
    private String _fingerprint;
    public static final int IMPORTANCE_AND_ORIGIN_COUNT = 6;
    private static final int USER_AGENT = 1;
    private static final int USER_NORMAL = 2;
    private static final int AUTHOR_NORMAL = 3;
    private static final int AUTHOR_IMPORTANT = 4;
    private static final int USER_IMPORTANT = 5;

    public PropertyDeclaration(CSSName cssName, CSSPrimitiveValue value, boolean imp, StylesheetInfo.Origin orig) {
        this.propName = cssName.toString();
        this.cssName = cssName;
        this.cssPrimitiveValue = value;
        this.important = imp;
        this.origin = orig;
    }

    public String toString() {
        return "%s: %s".formatted(this.getPropertyName(), this.getValue().toString());
    }

    public IdentValue asIdentValue() {
        if (!this.identIsSet) {
            this._identVal = IdentValue.getByIdentString(this.cssPrimitiveValue.getCssText());
            this.identIsSet = true;
        }
        return this._identVal;
    }

    public String getDeclarationStandardText() {
        return String.valueOf(this.cssName) + ": " + this.cssPrimitiveValue.getCssText() + ";";
    }

    public String getFingerprint() {
        if (this._fingerprint == null) {
            this._fingerprint = 80 + this.cssName.FS_ID + 58 + ((PropertyValue)this.cssPrimitiveValue).getFingerprint() + ";";
        }
        return this._fingerprint;
    }

    public int getImportanceAndOrigin() {
        return switch (this.origin) {
            default -> throw new MatchException(null, null);
            case StylesheetInfo.Origin.USER_AGENT -> 1;
            case StylesheetInfo.Origin.USER -> {
                if (this.important) {
                    yield 5;
                }
                yield 2;
            }
            case StylesheetInfo.Origin.AUTHOR -> this.important ? 4 : 3;
        };
    }

    public String getPropertyName() {
        return this.propName;
    }

    public CSSName getCSSName() {
        return this.cssName;
    }

    public CSSPrimitiveValue getValue() {
        return this.cssPrimitiveValue;
    }

    public boolean isImportant() {
        return this.important;
    }

    public StylesheetInfo.Origin getOrigin() {
        return this.origin;
    }
}

