/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.parser;

import org.openpdf.css.parser.FSRGBColor;

public record HSBColor(float hue, float saturation, float brightness) {
    public FSRGBColor toRGB() {
        int r = 0;
        int g = 0;
        int b = 0;
        if (this.saturation == 0.0f) {
            g = b = (int)(this.brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (this.hue - (float)Math.floor(this.hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = this.brightness * (1.0f - this.saturation);
            float q = this.brightness * (1.0f - this.saturation * f);
            float t = this.brightness * (1.0f - this.saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(this.brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(this.brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(this.brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(this.brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(this.brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(this.brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new FSRGBColor(r, g, b);
    }
}

