/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.newmatch;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.MarginBoxName;
import org.openpdf.css.extend.AttributeResolver;
import org.openpdf.css.extend.StylesheetFactory;
import org.openpdf.css.extend.TreeResolver;
import org.openpdf.css.newmatch.CascadedStyle;
import org.openpdf.css.newmatch.PageInfo;
import org.openpdf.css.newmatch.Selector;
import org.openpdf.css.sheet.FontFaceRule;
import org.openpdf.css.sheet.MediaRule;
import org.openpdf.css.sheet.PageRule;
import org.openpdf.css.sheet.PropertyDeclaration;
import org.openpdf.css.sheet.Ruleset;
import org.openpdf.css.sheet.Stylesheet;
import org.openpdf.css.sheet.StylesheetInfo;
import org.openpdf.util.Util;
import org.openpdf.util.XRLog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Matcher {
    private final Mapper docMapper;
    private final AttributeResolver _attRes;
    private final TreeResolver _treeRes;
    private final StylesheetFactory _styleFactory;
    private final Map<Node, Mapper> _map = Collections.synchronizedMap(new HashMap());
    private final Set<Node> _hoverElements = Collections.synchronizedSet(new HashSet(0));
    private final List<PageRule> _pageRules = new ArrayList<PageRule>(0);
    private final List<FontFaceRule> _fontFaceRules = new ArrayList<FontFaceRule>(0);

    public Matcher(TreeResolver tr, AttributeResolver ar, StylesheetFactory factory, List<Stylesheet> stylesheets, String medium) {
        this._treeRes = tr;
        this._attRes = ar;
        this._styleFactory = factory;
        this.docMapper = this.createDocumentMapper(stylesheets, medium);
    }

    public CascadedStyle getCascadedStyle(Element e, boolean restyle) {
        Mapper em = restyle ? this.matchElement(e) : this.getMapper(e);
        return em.getCascadedStyle(e);
    }

    public @Nullable CascadedStyle getPECascadedStyle(Element e, String pseudoElement) {
        Mapper em = this.getMapper(e);
        return em.getPECascadedStyle(pseudoElement);
    }

    @CheckReturnValue
    public @NonNull PageInfo getPageCascadedStyle(@Nullable String pageName, String pseudoPage) {
        ArrayList<PropertyDeclaration> props = new ArrayList<PropertyDeclaration>();
        HashMap<MarginBoxName, List<PropertyDeclaration>> marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
        for (PageRule pageRule : this._pageRules) {
            if (!pageRule.applies(pageName, pseudoPage)) continue;
            props.addAll(pageRule.getRuleset().getPropertyDeclarations());
            marginBoxes.putAll(pageRule.getMarginBoxes());
        }
        CascadedStyle style = props.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(props);
        return new PageInfo(props, style, marginBoxes);
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._fontFaceRules;
    }

    public boolean isHoverStyled(Node e) {
        return this._hoverElements.contains(e);
    }

    private Mapper matchElement(Node e) {
        Node parent = this._treeRes.getParentElement(e);
        if (parent != null) {
            return this.getMapper(parent).mapChild(e);
        }
        return this.docMapper.mapChild(e);
    }

    private Mapper createDocumentMapper(List<Stylesheet> stylesheets, String medium) {
        TreeMap<String, Selector> sorter = new TreeMap<String, Selector>();
        this.addAllStylesheets(stylesheets, sorter, medium);
        XRLog.match("Matcher created with " + sorter.size() + " selectors");
        return new Mapper(sorter.values());
    }

    private void addAllStylesheets(List<Stylesheet> stylesheets, Map<String, Selector> sorter, String medium) {
        int count = 0;
        int pCount = 0;
        for (Stylesheet stylesheet : stylesheets) {
            for (Object obj : stylesheet.getContents()) {
                MediaRule mediaRule;
                if (obj instanceof Ruleset) {
                    Ruleset ruleSet = (Ruleset)obj;
                    for (Selector selector : ruleSet.getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                    continue;
                }
                if (obj instanceof PageRule) {
                    PageRule pageRule = (PageRule)obj;
                    pageRule.setPos(++pCount);
                    this._pageRules.add(pageRule);
                    continue;
                }
                if (!(obj instanceof MediaRule) || !(mediaRule = (MediaRule)obj).matches(medium)) continue;
                for (Ruleset ruleset : mediaRule.getContents()) {
                    for (Selector selector : ruleset.getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                }
            }
            this._fontFaceRules.addAll(stylesheet.getFontFaceRules());
        }
        this._pageRules.sort(Comparator.comparingLong(PageRule::getOrder));
    }

    private void link(Node e, Mapper m) {
        this._map.put(e, m);
    }

    private Mapper getMapper(Node e) {
        return Objects.requireNonNullElseGet(this._map.get(e), () -> this.matchElement(e));
    }

    private Ruleset getElementStyle(Node e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getElementStyling(e);
        if (Util.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(StylesheetInfo.Origin.AUTHOR, style);
    }

    private Ruleset getNonCssStyle(Node e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getNonCssStyling(e);
        if (Util.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(StylesheetInfo.Origin.AUTHOR, style);
    }

    private class Mapper {
        private final List<Selector> axes;
        private final Map<String, List<Selector>> pseudoSelectors;
        private final List<Selector> mappedSelectors;
        private Map<List<Integer>, Mapper> children;

        Mapper(Collection<Selector> selectors) {
            this(new ArrayList<Selector>(selectors), null, null);
        }

        private Mapper(List<Selector> childAxes, Map<String, List<Selector>> pseudoSelectors, List<Selector> mappedSelectors) {
            this.axes = childAxes;
            this.pseudoSelectors = pseudoSelectors;
            this.mappedSelectors = mappedSelectors;
        }

        Mapper mapChild(Node e) {
            ArrayList<Selector> childAxes = new ArrayList<Selector>(this.axes.size() + 10);
            HashMap<String, List> pseudoSelectors = new HashMap<String, List>();
            ArrayList<Selector> mappedSelectors = new ArrayList<Selector>();
            ArrayList<Integer> key = new ArrayList<Integer>();
            for (Selector axe : this.axes) {
                switch (axe.getAxis()) {
                    case DESCENDANT_AXIS: {
                        childAxes.add(axe);
                        break;
                    }
                    case IMMEDIATE_SIBLING_AXIS: {
                        throw new RuntimeException("Selector axis: " + String.valueOf((Object)Selector.Axis.IMMEDIATE_SIBLING_AXIS));
                    }
                }
                if (!axe.matches(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                String pseudoElement = axe.getPseudoElement();
                if (pseudoElement != null) {
                    List l = pseudoSelectors.computeIfAbsent(pseudoElement, k -> new ArrayList());
                    l.add(axe);
                    key.add(axe.getSelectorID());
                    continue;
                }
                if (axe.isPseudoClass(4)) {
                    Matcher.this._hoverElements.add(e);
                }
                if (!axe.matchesDynamic(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                key.add(axe.getSelectorID());
                Selector chain = axe.getChainedSelector();
                if (chain == null) {
                    mappedSelectors.add(axe);
                    continue;
                }
                switch (chain.getAxis()) {
                    case IMMEDIATE_SIBLING_AXIS: {
                        throw new RuntimeException("Selector axis: " + String.valueOf((Object)Selector.Axis.IMMEDIATE_SIBLING_AXIS));
                    }
                    case DESCENDANT_AXIS: 
                    case CHILD_AXIS: {
                        childAxes.add(chain);
                    }
                }
            }
            if (this.children == null) {
                this.children = new HashMap<List<Integer>, Mapper>();
            }
            Mapper childMapper = this.children.computeIfAbsent(key, k -> new Mapper(childAxes, pseudoSelectors, mappedSelectors));
            Matcher.this.link(e, childMapper);
            return childMapper;
        }

        CascadedStyle getCascadedStyle(Node e) {
            Ruleset elementStyling = Matcher.this.getElementStyle(e);
            Ruleset nonCssStyling = Matcher.this.getNonCssStyle(e);
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            if (nonCssStyling != null) {
                propList.addAll(nonCssStyling.getPropertyDeclarations());
            }
            for (Selector selector : this.mappedSelectors) {
                propList.addAll(selector.getRuleset().getPropertyDeclarations());
            }
            if (elementStyling != null) {
                propList.addAll(elementStyling.getPropertyDeclarations());
            }
            return propList.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList);
        }

        public @Nullable CascadedStyle getPECascadedStyle(String pseudoElement) {
            Iterator<Map.Entry<String, List<Selector>>> si = this.pseudoSelectors.entrySet().iterator();
            if (!si.hasNext()) {
                return null;
            }
            List<Selector> pe = this.pseudoSelectors.get(pseudoElement);
            if (pe == null) {
                return null;
            }
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            for (Selector selector : pe) {
                propList.addAll(selector.getRuleset().getPropertyDeclarations());
            }
            if (propList.isEmpty()) {
                return CascadedStyle.emptyCascadedStyle;
            }
            return new CascadedStyle(propList);
        }
    }
}

