/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.test;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.openpdf.render.Box;
import org.openpdf.simple.Graphics2DRenderer;
import org.openpdf.util.ImageUtil;
import org.openpdf.util.Uu;
import org.openpdf.util.XMLUtil;
import org.openpdf.util.XRLog;
import org.w3c.dom.Document;

public class DocumentDiffTest {
    public static void generateTestFile(String test, String diff, int width, int height) throws Exception {
        Uu.p("test = " + test);
        String out = DocumentDiffTest.xhtmlToDiff(test, width, height);
        DocumentDiffTest.string_to_file(out, new File(diff));
    }

    public static String xhtmlToDiff(String xhtml, int width, int height) throws Exception {
        Document doc = XMLUtil.documentFromFile(xhtml);
        Graphics2DRenderer renderer = new Graphics2DRenderer(doc, new File(xhtml).toURI().toURL().toString());
        BufferedImage buff = new BufferedImage(width, height, 6);
        ImageUtil.withGraphics(buff, g -> {
            Dimension dim = new Dimension(width, height);
            renderer.layout((Graphics2D)g, dim);
            renderer.render((Graphics2D)g);
        });
        DocumentDiffTest.getDiff(renderer.getPanel().getRootBox(), "");
        return "";
    }

    public boolean compareTestFile(String test, String diff, int width, int height) throws Exception {
        String din;
        String tin = DocumentDiffTest.xhtmlToDiff(test, width, height);
        try {
            din = DocumentDiffTest.file_to_string(diff);
        }
        catch (FileNotFoundException ex) {
            XRLog.log("unittests", Level.WARNING, "diff file missing");
            return false;
        }
        if (tin.equals(din)) {
            return true;
        }
        XRLog.log("unittests", Level.WARNING, "warning not equals");
        File dfile = new File("correct.diff");
        File tfile = new File("test.diff");
        XRLog.log("unittests", Level.WARNING, "writing to " + String.valueOf(dfile) + " and " + String.valueOf(tfile));
        DocumentDiffTest.string_to_file(tin, tfile);
        DocumentDiffTest.string_to_file(din, dfile);
        return false;
    }

    private static void getDiff(Box box, String tab) {
        for (int i = 0; i < box.getChildCount(); ++i) {
            DocumentDiffTest.getDiff(box.getChild(i), tab + " ");
        }
    }

    private static String file_to_string(String filename) throws IOException {
        File file = new File(filename);
        return DocumentDiffTest.file_to_string(file);
    }

    private static String file_to_string(File file) throws IOException {
        try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
            String string;
            try (StringWriter writer = new StringWriter();){
                int n;
                char[] buf = new char[1000];
                while ((n = reader.read(buf, 0, 1000)) != -1) {
                    writer.write(buf, 0, n);
                }
                string = writer.toString();
            }
            return string;
        }
    }

    public static void string_to_file(String text, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);
             StringReader reader = new StringReader(text);){
            int n;
            char[] buf = new char[1000];
            while ((n = reader.read(buf, 0, 1000)) != -1) {
                writer.write(buf, 0, n);
            }
            writer.flush();
        }
    }
}

