/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.style.derived;

import com.google.errorprone.annotations.CheckReturnValue;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.CssContext;

public class RectPropertySet {
    public static final RectPropertySet ALL_ZEROS = new RectPropertySet(0.0f, 0.0f, 0.0f, 0.0f);
    private float _top;
    private float _right;
    private float _bottom;
    private float _left;

    public RectPropertySet(float top, float right, float bottom, float left) {
        this._top = top;
        this._right = right;
        this._bottom = bottom;
        this._left = left;
    }

    public static RectPropertySet newInstance(CalculatedStyle style, CSSName.CSSSideProperties sideProperties, float cbWidth, CssContext ctx) {
        return new RectPropertySet(!style.isLengthOrNumber(sideProperties.top()) ? 0.0f : style.getFloatPropertyProportionalHeight(sideProperties.top(), cbWidth, ctx), !style.isLengthOrNumber(sideProperties.right()) ? 0.0f : style.getFloatPropertyProportionalWidth(sideProperties.right(), cbWidth, ctx), !style.isLengthOrNumber(sideProperties.bottom()) ? 0.0f : style.getFloatPropertyProportionalHeight(sideProperties.bottom(), cbWidth, ctx), !style.isLengthOrNumber(sideProperties.left()) ? 0.0f : style.getFloatPropertyProportionalWidth(sideProperties.left(), cbWidth, ctx));
    }

    public String toString() {
        return "RectPropertySet[top=%s,right=%s,bottom=%s,left=%s]".formatted(Float.valueOf(this._top), Float.valueOf(this._right), Float.valueOf(this._bottom), Float.valueOf(this._left));
    }

    public float top() {
        return this._top;
    }

    public float right() {
        return this._right;
    }

    public float bottom() {
        return this._bottom;
    }

    public float left() {
        return this._left;
    }

    public float getLeftRightDiff() {
        return this._left - this._right;
    }

    public float height() {
        return this._top + this._bottom;
    }

    public float width() {
        return this._left + this._right;
    }

    public void setTop(float _top) {
        this._top = _top;
    }

    public void setRight(float _right) {
        this._right = _right;
    }

    public void setBottom(float _bottom) {
        this._bottom = _bottom;
    }

    public void setLeft(float _left) {
        this._left = _left;
    }

    public RectPropertySet copyOf() {
        return new RectPropertySet(this._top, this._right, this._bottom, this._left);
    }

    public boolean isAllZeros() {
        return this._top == 0.0f && this._right == 0.0f && this._bottom == 0.0f && this._left == 0.0f;
    }

    public boolean hasNegativeValues() {
        return this._top < 0.0f || this._right < 0.0f || this._bottom < 0.0f || this._left < 0.0f;
    }

    @CheckReturnValue
    public RectPropertySet resetNegativeValues() {
        return new RectPropertySet(Math.max(0.0f, this.top()), Math.max(0.0f, this.right()), Math.max(0.0f, this.bottom()), Math.max(0.0f, this.left()));
    }
}

