/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.parser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.MarginBoxName;
import org.openpdf.css.newmatch.Selector;
import org.openpdf.css.parser.CSSErrorHandler;
import org.openpdf.css.parser.CSSParseException;
import org.openpdf.css.parser.FSCMYKColor;
import org.openpdf.css.parser.FSFunction;
import org.openpdf.css.parser.FSRGBColor;
import org.openpdf.css.parser.Lexer;
import org.openpdf.css.parser.PropertyValue;
import org.openpdf.css.parser.Token;
import org.openpdf.css.parser.property.PropertyBuilder;
import org.openpdf.css.sheet.FontFaceRule;
import org.openpdf.css.sheet.MediaRule;
import org.openpdf.css.sheet.PageRule;
import org.openpdf.css.sheet.PropertyDeclaration;
import org.openpdf.css.sheet.Ruleset;
import org.openpdf.css.sheet.RulesetContainer;
import org.openpdf.css.sheet.Stylesheet;
import org.openpdf.css.sheet.StylesheetInfo;

public class CSSParser {
    private @Nullable Token _saved;
    private final Lexer _lexer;
    private final CSSErrorHandler _errorHandler;
    private @Nullable String _uri;
    private final Map<String, String> _namespaces = new HashMap<String, String>();
    private boolean _supportCMYKColors;

    public CSSParser(CSSErrorHandler errorHandler) {
        this._lexer = new Lexer(new StringReader(""));
        this._errorHandler = errorHandler;
    }

    @CheckReturnValue
    public Stylesheet parseStylesheet(@Nullable String uri, StylesheetInfo.Origin origin, Reader reader) throws IOException {
        this._uri = uri;
        this.reset(reader);
        Stylesheet result = new Stylesheet(uri, origin);
        this.stylesheet(result);
        return result;
    }

    public Ruleset parseDeclaration(StylesheetInfo.Origin origin, String text) {
        try {
            this._uri = "style attribute";
            this.reset(new StringReader(text));
            this.skip_whitespace();
            Ruleset result = new Ruleset(origin);
            try {
                this.declaration_list(result, true, false, false);
            }
            catch (CSSParseException cSSParseException) {
                // empty catch block
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public @Nullable PropertyValue parsePropertyValue(CSSName cssName, StylesheetInfo.Origin origin, String expr) {
        this._uri = String.valueOf(cssName) + " property value";
        try {
            List<PropertyDeclaration> props;
            this.reset(new StringReader(expr));
            List<PropertyValue> values = this.expr(cssName.equals(CSSName.FONT_FAMILY) || cssName.equals(CSSName.FONT_SHORTHAND) || cssName.equals(CSSName.FS_PDF_FONT_ENCODING));
            PropertyBuilder builder = CSSName.getPropertyBuilder(cssName);
            try {
                props = builder.buildDeclarations(cssName, values, origin, false);
            }
            catch (CSSParseException e) {
                e.setLine(this.getCurrentLine());
                throw e;
            }
            if (props.size() != 1) {
                throw new CSSParseException("Builder created " + props.size() + "properties, expected 1", this.getCurrentLine());
            }
            return (PropertyValue)props.get(0).getValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (CSSParseException e) {
            this.error(e, "property value", false);
            return null;
        }
    }

    private void stylesheet(Stylesheet stylesheet) throws IOException {
        block19: {
            Token t = this.la();
            try {
                block18: {
                    if (t == Token.TK_CHARSET_SYM) {
                        try {
                            t = this.next();
                            this.skip_whitespace();
                            t = this.next();
                            if (t == Token.TK_STRING) {
                                this.skip_whitespace();
                                t = this.next();
                                if (t != Token.TK_SEMICOLON) {
                                    this.push(t);
                                    throw new CSSParseException(t, Token.TK_SEMICOLON, this.getCurrentLine());
                                }
                                break block18;
                            }
                            this.push(t);
                            throw new CSSParseException(t, Token.TK_STRING, this.getCurrentLine());
                        }
                        catch (CSSParseException e) {
                            this.error(e, "@charset rule", true);
                            this.recover(false, false);
                        }
                    }
                }
                this.skip_whitespace_and_cdocdc();
                while ((t = this.la()) == Token.TK_IMPORT_SYM) {
                    this.import_rule(stylesheet);
                    this.skip_whitespace_and_cdocdc();
                }
                while ((t = this.la()) == Token.TK_NAMESPACE_SYM) {
                    this.namespace();
                    this.skip_whitespace_and_cdocdc();
                }
                while ((t = this.la()) != Token.TK_EOF) {
                    switch (t.getType()) {
                        case PAGE_SYM: {
                            this.page(stylesheet);
                            break;
                        }
                        case MEDIA_SYM: {
                            this.media(stylesheet);
                            break;
                        }
                        case FONT_FACE_SYM: {
                            this.font_face(stylesheet);
                            break;
                        }
                        case IMPORT_SYM: {
                            this.next();
                            this.error(new CSSParseException("@import not allowed here", this.getCurrentLine()), "@import rule", true);
                            this.recover(false, false);
                            break;
                        }
                        case NAMESPACE_SYM: {
                            this.next();
                            this.error(new CSSParseException("@namespace not allowed here", this.getCurrentLine()), "@namespace rule", true);
                            this.recover(false, false);
                            break;
                        }
                        case AT_RULE: {
                            this.next();
                            this.error(new CSSParseException("Invalid at-rule", this.getCurrentLine()), "at-rule", true);
                            this.recover(false, false);
                            this.ruleset(stylesheet);
                            break;
                        }
                        default: {
                            this.ruleset(stylesheet);
                        }
                    }
                    this.skip_whitespace_and_cdocdc();
                }
            }
            catch (CSSParseException e) {
                if (e.isCallerNotified()) break block19;
                this.error(e, "stylesheet", false);
            }
        }
    }

    private void import_rule(Stylesheet stylesheet) throws IOException {
        try {
            String uri;
            ArrayList<String> mediaTypes;
            Token t = this.next();
            if (t == Token.TK_IMPORT_SYM) {
                mediaTypes = new ArrayList<String>(1);
                this.skip_whitespace();
                t = this.next();
                switch (t.getType()) {
                    case STRING: 
                    case URI: {
                        try {
                            uri = new URL(new URL(stylesheet.getURI()), this.getTokenValue(t)).toString();
                        }
                        catch (MalformedURLException mue) {
                            try {
                                URI parent = new URI(stylesheet.getURI());
                                String tokenValue = this.getTokenValue(t);
                                String resolvedUri = parent.resolve(tokenValue).toString();
                                System.out.println("Token: " + tokenValue + " resolved " + resolvedUri);
                                uri = resolvedUri;
                            }
                            catch (URISyntaxException use) {
                                throw new CSSParseException("Invalid URL, " + use.getMessage(), this.getCurrentLine(), use);
                            }
                        }
                        this.skip_whitespace();
                        t = this.la();
                        if (t == Token.TK_IDENT) {
                            mediaTypes.add(this.medium());
                            while ((t = this.la()) == Token.TK_COMMA) {
                                this.next();
                                this.skip_whitespace();
                                t = this.la();
                                if (t == Token.TK_IDENT) {
                                    mediaTypes.add(this.medium());
                                    continue;
                                }
                                throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
                            }
                        }
                        if ((t = this.next()) == Token.TK_SEMICOLON) {
                            this.skip_whitespace();
                            break;
                        }
                        this.push(t);
                        throw new CSSParseException(t, Token.TK_SEMICOLON, this.getCurrentLine());
                    }
                    default: {
                        this.push(t);
                        throw new CSSParseException(t, new Token[]{Token.TK_STRING, Token.TK_URI}, this.getCurrentLine());
                    }
                }
                if (mediaTypes.isEmpty()) {
                    mediaTypes.add("all");
                }
            } else {
                this.push(t);
                throw new CSSParseException(t, Token.TK_IMPORT_SYM, this.getCurrentLine());
            }
            StylesheetInfo info = new StylesheetInfo(stylesheet.getOrigin(), uri, mediaTypes, null);
            stylesheet.addImportRule(info);
        }
        catch (CSSParseException e) {
            this.error(e, "@import rule", true);
            this.recover(false, false);
        }
    }

    private void namespace() throws IOException {
        try {
            String url;
            String prefix;
            Token t = this.next();
            if (t == Token.TK_NAMESPACE_SYM) {
                this.skip_whitespace();
                t = this.next();
                prefix = null;
                if (t == Token.TK_IDENT) {
                    prefix = this.getTokenValue(t);
                    this.skip_whitespace();
                    t = this.next();
                }
                if (t != Token.TK_STRING && t != Token.TK_URI) {
                    throw new CSSParseException(t, new Token[]{Token.TK_STRING, Token.TK_URI}, this.getCurrentLine());
                }
                url = this.getTokenValue(t);
                this.skip_whitespace();
                t = this.next();
                if (t != Token.TK_SEMICOLON) {
                    throw new CSSParseException(t, Token.TK_SEMICOLON, this.getCurrentLine());
                }
            } else {
                throw new CSSParseException(t, Token.TK_NAMESPACE_SYM, this.getCurrentLine());
            }
            this.skip_whitespace();
            this._namespaces.put(prefix, url);
        }
        catch (CSSParseException e) {
            this.error(e, "@namespace rule", true);
            this.recover(false, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void media(Stylesheet stylesheet) throws IOException {
        Token t = this.next();
        try {
            MediaRule mediaRule;
            if (t == Token.TK_MEDIA_SYM) {
                mediaRule = new MediaRule(stylesheet.getOrigin());
                this.skip_whitespace();
                t = this.la();
                if (t != Token.TK_IDENT) throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
                mediaRule.addMedium(this.medium());
                while ((t = this.la()) == Token.TK_COMMA) {
                    this.next();
                    this.skip_whitespace();
                    t = this.la();
                    if (t != Token.TK_IDENT) throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
                    mediaRule.addMedium(this.medium());
                }
                t = this.next();
                if (t == Token.TK_LBRACE) {
                    this.skip_whitespace();
                    while ((t = this.la()) != null) {
                        if (t.getType() == Token.Type.RBRACE) {
                            this.next();
                            break;
                        }
                        this.ruleset(mediaRule);
                    }
                } else {
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_LBRACE, this.getCurrentLine());
                }
                this.skip_whitespace();
            } else {
                this.push(t);
                throw new CSSParseException(t, Token.TK_MEDIA_SYM, this.getCurrentLine());
            }
            stylesheet.addContent(mediaRule);
            return;
        }
        catch (CSSParseException e) {
            this.error(e, "@media rule", true);
            this.recover(false, false);
        }
    }

    private String medium() throws IOException {
        Token t = this.next();
        if (t == Token.TK_IDENT) {
            String result = this.getTokenValue(t);
            this.skip_whitespace();
            return result;
        }
        this.push(t);
        throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
    }

    private void font_face(Stylesheet stylesheet) throws IOException {
        Token t = this.next();
        try {
            Ruleset ruleset;
            FontFaceRule fontFaceRule = new FontFaceRule(stylesheet.getOrigin());
            if (t == Token.TK_FONT_FACE_SYM) {
                this.skip_whitespace();
                ruleset = new Ruleset(stylesheet.getOrigin());
                this.skip_whitespace();
                t = this.next();
                if (t == Token.TK_LBRACE) {
                    int maxLoops = 0x100000;
                    int i = 0;
                    while (true) {
                        if (++i >= maxLoops) {
                            throw new CSSParseException(t, Token.TK_RBRACE, this.getCurrentLine());
                        }
                        this.skip_whitespace();
                        t = this.la();
                        if (t != Token.TK_RBRACE) {
                            this.declaration_list(ruleset, false, true, true);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_LBRACE, this.getCurrentLine());
                }
                this.next();
                this.skip_whitespace();
            } else {
                this.push(t);
                throw new CSSParseException(t, Token.TK_FONT_FACE_SYM, this.getCurrentLine());
            }
            fontFaceRule.addContent(ruleset);
            stylesheet.addFontFaceRule(fontFaceRule);
        }
        catch (CSSParseException e) {
            this.error(e, "@font-face rule", true);
            this.recover(false, false);
        }
    }

    private void page(Stylesheet stylesheet) throws IOException {
        Token t = this.next();
        try {
            Ruleset ruleset;
            HashMap<MarginBoxName, List<PropertyDeclaration>> margins;
            String pseudoPage;
            String pageName;
            if (t == Token.TK_PAGE_SYM) {
                pageName = null;
                pseudoPage = null;
                margins = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
                this.skip_whitespace();
                t = this.la();
                if (t == Token.TK_IDENT) {
                    pageName = this.getTokenValue(t);
                    if (pageName.equals("auto")) {
                        throw new CSSParseException("page name may not be auto", this.getCurrentLine());
                    }
                    this.next();
                    t = this.la();
                }
                if (t == Token.TK_COLON) {
                    pseudoPage = this.pseudo_page();
                }
                ruleset = new Ruleset(stylesheet.getOrigin());
                this.skip_whitespace();
                t = this.next();
                if (t == Token.TK_LBRACE) {
                    while (true) {
                        this.skip_whitespace();
                        t = this.la();
                        if (t != Token.TK_RBRACE) {
                            if (t == Token.TK_AT_RULE) {
                                margins.putAll(this.margin(stylesheet));
                                continue;
                            }
                            this.declaration_list(ruleset, false, true, false);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_LBRACE, this.getCurrentLine());
                }
                this.next();
                this.skip_whitespace();
            } else {
                this.push(t);
                throw new CSSParseException(t, Token.TK_PAGE_SYM, this.getCurrentLine());
            }
            PageRule pageRule = new PageRule(stylesheet.getOrigin(), pageName, pseudoPage, margins, ruleset);
            stylesheet.addContent(pageRule);
        }
        catch (CSSParseException e) {
            this.error(e, "@page rule", true);
            this.recover(false, false);
        }
    }

    private Map<MarginBoxName, List<PropertyDeclaration>> margin(Stylesheet stylesheet) throws IOException {
        Token t = this.next();
        if (t != Token.TK_AT_RULE) {
            this.error(new CSSParseException(t, Token.TK_AT_RULE, this.getCurrentLine()), "at rule", true);
            this.recover(true, false);
            return Collections.emptyMap();
        }
        String name = this.getTokenValue(t);
        MarginBoxName marginBoxName = MarginBoxName.valueOf(name);
        if (marginBoxName == null) {
            this.error(new CSSParseException(name + " is not a valid margin box name", this.getCurrentLine()), "at rule", true);
            this.recover(true, false);
            return Collections.emptyMap();
        }
        this.skip_whitespace();
        try {
            t = this.next();
            if (t == Token.TK_LBRACE) {
                this.skip_whitespace();
                Ruleset ruleset = new Ruleset(stylesheet.getOrigin());
                this.declaration_list(ruleset, false, false, false);
                t = this.next();
                if (t != Token.TK_RBRACE) {
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_RBRACE, this.getCurrentLine());
                }
                return Map.of(marginBoxName, ruleset.getPropertyDeclarations());
            }
            this.push(t);
            throw new CSSParseException(t, Token.TK_LBRACE, this.getCurrentLine());
        }
        catch (CSSParseException e) {
            this.error(e, "margin box", true);
            this.recover(false, false);
            return Collections.emptyMap();
        }
    }

    private String pseudo_page() throws IOException {
        Token t = this.next();
        if (t == Token.TK_COLON) {
            t = this.next();
            if (t == Token.TK_IDENT) {
                String result = this.getTokenValue(t);
                if (!(result.equals("first") || result.equals("left") || result.equals("right"))) {
                    throw new CSSParseException("Pseudo page must be one of first, left, or right", this.getCurrentLine());
                }
                return result;
            }
            this.push(t);
            throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
        }
        this.push(t);
        throw new CSSParseException(t, Token.TK_COLON, this.getCurrentLine());
    }

    private void operator() throws IOException {
        Token t = this.la();
        switch (t.getType()) {
            case VIRGULE: 
            case COMMA: {
                this.next();
                this.skip_whitespace();
            }
        }
    }

    private Token combinator() throws IOException {
        Token t = this.next();
        if (t == Token.TK_PLUS || t == Token.TK_GREATER) {
            this.skip_whitespace();
        } else if (t != Token.TK_S) {
            this.push(t);
            throw new CSSParseException(t, new Token[]{Token.TK_PLUS, Token.TK_GREATER, Token.TK_S}, this.getCurrentLine());
        }
        return t;
    }

    private int unary_operator() throws IOException {
        Token t = this.next();
        if (t != Token.TK_MINUS && t != Token.TK_PLUS) {
            this.push(t);
            throw new CSSParseException(t, new Token[]{Token.TK_MINUS, Token.TK_PLUS}, this.getCurrentLine());
        }
        if (t == Token.TK_MINUS) {
            return -1;
        }
        return 1;
    }

    private String property() throws IOException {
        Token t = this.next();
        if (t != Token.TK_IDENT) {
            this.push(t);
            throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
        }
        String result = this.getTokenValue(t);
        this.skip_whitespace();
        return result;
    }

    private void declaration_list(Ruleset ruleset, boolean expectEOF, boolean expectAtRule, boolean inFontFace) throws IOException {
        block6: while (true) {
            Token t = this.la();
            switch (t.getType()) {
                case SEMICOLON: {
                    this.next();
                    this.skip_whitespace();
                    continue block6;
                }
                case RBRACE: {
                    break block6;
                }
                case AT_RULE: {
                    if (expectAtRule) break block6;
                    this.declaration(ruleset, inFontFace);
                    continue block6;
                }
                case EOF: {
                    if (expectEOF) break block6;
                    this.declaration(ruleset, inFontFace);
                    continue block6;
                }
                default: {
                    this.declaration(ruleset, inFontFace);
                    continue block6;
                }
            }
            break;
        }
    }

    private void ruleset(RulesetContainer container) throws IOException {
        try {
            Token t;
            Ruleset ruleset = new Ruleset(container.getOrigin());
            this.selector(ruleset);
            while ((t = this.la()) == Token.TK_COMMA) {
                this.next();
                this.skip_whitespace();
                this.selector(ruleset);
            }
            t = this.next();
            if (t == Token.TK_LBRACE) {
                this.skip_whitespace();
                this.declaration_list(ruleset, false, false, false);
                t = this.next();
                if (t != Token.TK_RBRACE) {
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_RBRACE, this.getCurrentLine());
                }
            } else {
                this.push(t);
                throw new CSSParseException(t, new Token[]{Token.TK_COMMA, Token.TK_LBRACE}, this.getCurrentLine());
            }
            this.skip_whitespace();
            if (!ruleset.getPropertyDeclarations().isEmpty()) {
                container.addContent(ruleset);
            }
        }
        catch (CSSParseException e) {
            this.error(e, "ruleset", true);
            this.recover(true, false);
        }
    }

    private void selector(Ruleset ruleset) throws IOException {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        ArrayList<Token> combinators = new ArrayList<Token>();
        selectors.add(this.simple_selector(ruleset));
        block6: while (true) {
            Token t = this.la();
            switch (t.getType()) {
                case PLUS: 
                case GREATER: 
                case S: {
                    combinators.add(this.combinator());
                    t = this.la();
                    switch (t.getType()) {
                        case IDENT: 
                        case ASTERISK: 
                        case HASH: 
                        case PERIOD: 
                        case LBRACKET: 
                        case COLON: {
                            selectors.add(this.simple_selector(ruleset));
                            continue block6;
                        }
                    }
                    throw new CSSParseException(t, new Token[]{Token.TK_IDENT, Token.TK_ASTERISK, Token.TK_HASH, Token.TK_PERIOD, Token.TK_LBRACKET, Token.TK_COLON}, this.getCurrentLine());
                }
            }
            break;
        }
        ruleset.addFSSelector(this.mergeSimpleSelectors(selectors, combinators));
    }

    @CheckReturnValue
    private @Nullable Selector mergeSimpleSelectors(List<Selector> selectors, List<Token> combinators) {
        int count = selectors.size();
        if (count == 1) {
            return selectors.get(0);
        }
        Selector.Axis lastDescendantOrChildAxis = Selector.Axis.DESCENDANT_AXIS;
        Selector result = null;
        block0: for (int i = 0; i < count - 1; ++i) {
            Selector first = selectors.get(i);
            Selector second = selectors.get(i + 1);
            Token combinator = combinators.get(i);
            if (first.getPseudoElement() != null) {
                throw new CSSParseException("A simple selector with a pseudo element cannot be combined with another simple selector", this.getCurrentLine());
            }
            boolean sibling = false;
            if (combinator == Token.TK_S) {
                second.setAxis(Selector.Axis.DESCENDANT_AXIS);
                lastDescendantOrChildAxis = Selector.Axis.DESCENDANT_AXIS;
            } else if (combinator == Token.TK_GREATER) {
                second.setAxis(Selector.Axis.CHILD_AXIS);
                lastDescendantOrChildAxis = Selector.Axis.CHILD_AXIS;
            } else if (combinator == Token.TK_PLUS) {
                first.setAxis(Selector.Axis.IMMEDIATE_SIBLING_AXIS);
                sibling = true;
            }
            second.setSpecificityB(second.getSpecificityB() + first.getSpecificityB());
            second.setSpecificityC(second.getSpecificityC() + first.getSpecificityC());
            second.setSpecificityD(second.getSpecificityD() + first.getSpecificityD());
            if (!sibling) {
                if (result == null) {
                    result = first;
                }
                first.setChainedSelector(second);
                continue;
            }
            second.setSiblingSelector(first);
            if (result == null || result == first) {
                result = second;
            }
            if (i <= 0) continue;
            for (int j = i - 1; j >= 0; --j) {
                Selector selector = selectors.get(j);
                if (selector.getChainedSelector() != first) continue;
                selector.setChainedSelector(second);
                second.setAxis(lastDescendantOrChildAxis);
                continue block0;
            }
        }
        return result;
    }

    private Selector simple_selector(Ruleset ruleset) throws IOException {
        Selector selector = new Selector();
        selector.setParent(ruleset);
        Token t = this.la();
        switch (t.getType()) {
            case IDENT: 
            case ASTERISK: 
            case VERTICAL_BAR: {
                NamespacePair pair = this.typed_value(false);
                selector.setNamespaceURI(pair.getNamespaceURI());
                selector.setName(pair.getName());
                block15: while (true) {
                    t = this.la();
                    switch (t.getType()) {
                        case HASH: {
                            t = this.next();
                            selector.addIDCondition(this.getTokenValue(t, true));
                            continue block15;
                        }
                        case PERIOD: {
                            this.class_selector(selector);
                            continue block15;
                        }
                        case LBRACKET: {
                            this.attrib(selector);
                            continue block15;
                        }
                        case COLON: {
                            this.pseudo(selector);
                            continue block15;
                        }
                    }
                    break;
                }
                break;
            }
            default: {
                boolean found = false;
                block16: while (true) {
                    t = this.la();
                    switch (t.getType()) {
                        case HASH: {
                            t = this.next();
                            selector.addIDCondition(this.getTokenValue(t, true));
                            found = true;
                            continue block16;
                        }
                        case PERIOD: {
                            this.class_selector(selector);
                            found = true;
                            continue block16;
                        }
                        case LBRACKET: {
                            this.attrib(selector);
                            found = true;
                            continue block16;
                        }
                        case COLON: {
                            this.pseudo(selector);
                            found = true;
                            continue block16;
                        }
                    }
                    break;
                }
                if (found) break;
                throw new CSSParseException(t, new Token[]{Token.TK_HASH, Token.TK_PERIOD, Token.TK_LBRACKET, Token.TK_COLON}, this.getCurrentLine());
            }
        }
        return selector;
    }

    private NamespacePair typed_value(boolean matchAttribute) throws IOException {
        String prefix = null;
        String name = null;
        Token t = this.la();
        if (t == Token.TK_ASTERISK || t == Token.TK_IDENT) {
            this.next();
            if (t == Token.TK_IDENT) {
                name = this.getTokenValue(t, true);
            }
            t = this.la();
        } else if (t == Token.TK_VERTICAL_BAR) {
            prefix = "";
        } else {
            throw new CSSParseException(t, new Token[]{Token.TK_ASTERISK, Token.TK_IDENT, Token.TK_VERTICAL_BAR}, this.getCurrentLine());
        }
        if (t == Token.TK_VERTICAL_BAR) {
            this.next();
            t = this.next();
            if (t == Token.TK_ASTERISK || t == Token.TK_IDENT) {
                if (prefix == null) {
                    prefix = name;
                }
                if (t == Token.TK_IDENT) {
                    name = this.getTokenValue(t, true);
                }
            } else {
                throw new CSSParseException(t, new Token[]{Token.TK_ASTERISK, Token.TK_IDENT}, this.getCurrentLine());
            }
        }
        String namespaceURI = null;
        if (prefix != null && !prefix.equals("")) {
            namespaceURI = this._namespaces.get(prefix.toLowerCase(Locale.ROOT));
            if (namespaceURI == null) {
                throw new CSSParseException("There is no namespace with prefix " + prefix + " defined", this.getCurrentLine());
            }
        } else if (prefix == null && !matchAttribute) {
            namespaceURI = this._namespaces.get(null);
        }
        if (matchAttribute && name == null) {
            throw new CSSParseException("An attribute name is required", this.getCurrentLine());
        }
        return new NamespacePair(namespaceURI, name);
    }

    private void class_selector(Selector selector) throws IOException {
        Token t = this.next();
        if (t == Token.TK_PERIOD) {
            t = this.next();
            if (t != Token.TK_IDENT) {
                this.push(t);
                throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
            }
        } else {
            this.push(t);
            throw new CSSParseException(t, Token.TK_PERIOD, this.getCurrentLine());
        }
        selector.addClassCondition(this.getTokenValue(t, true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attrib(Selector selector) throws IOException {
        Token t = this.next();
        if (t == Token.TK_LBRACKET) {
            this.skip_whitespace();
            t = this.la();
            if (t != Token.TK_IDENT && t != Token.TK_ASTERISK && t != Token.TK_VERTICAL_BAR) throw new CSSParseException(t, new Token[]{Token.TK_IDENT, Token.TK_ASTERISK}, this.getCurrentLine());
            boolean existenceMatch = true;
            NamespacePair pair = this.typed_value(true);
            String attrNamespaceURI = pair.getNamespaceURI();
            String attrName = pair.getName();
            this.skip_whitespace();
            t = this.la();
            switch (t.getType()) {
                case EQUALS: 
                case DASHMATCH: 
                case INCLUDES: 
                case PREFIXMATCH: 
                case SUFFIXMATCH: 
                case SUBSTRINGMATCH: {
                    existenceMatch = false;
                    Token selectorType = this.next();
                    this.skip_whitespace();
                    t = this.next();
                    if (t == Token.TK_IDENT || t == Token.TK_STRING) {
                        String value = this.getTokenValue(t, true);
                        switch (selectorType.getType()) {
                            case EQUALS: {
                                selector.addAttributeEqualsCondition(attrNamespaceURI, attrName, value);
                                break;
                            }
                            case DASHMATCH: {
                                selector.addAttributeMatchesFirstPartCondition(attrNamespaceURI, attrName, value);
                                break;
                            }
                            case INCLUDES: {
                                selector.addAttributeMatchesListCondition(attrNamespaceURI, attrName, value);
                                break;
                            }
                            case PREFIXMATCH: {
                                selector.addAttributePrefixCondition(attrNamespaceURI, attrName, value);
                                break;
                            }
                            case SUFFIXMATCH: {
                                selector.addAttributeSuffixCondition(attrNamespaceURI, attrName, value);
                                break;
                            }
                            case SUBSTRINGMATCH: {
                                selector.addAttributeSubstringCondition(attrNamespaceURI, attrName, value);
                            }
                        }
                    } else {
                        this.push(t);
                        throw new CSSParseException(t, new Token[]{Token.TK_IDENT, Token.TK_STRING}, this.getCurrentLine());
                    }
                    this.skip_whitespace();
                    this.skip_whitespace();
                    t = this.la();
                }
            }
            if (existenceMatch) {
                selector.addAttributeExistsCondition(attrNamespaceURI, attrName);
            }
            if (t != Token.TK_RBRACKET) {
                throw new CSSParseException(t, new Token[]{Token.TK_EQUALS, Token.TK_INCLUDES, Token.TK_DASHMATCH, Token.TK_PREFIXMATCH, Token.TK_SUFFIXMATCH, Token.TK_SUBSTRINGMATCH, Token.TK_RBRACKET}, this.getCurrentLine());
            }
        } else {
            this.push(t);
            throw new CSSParseException(t, Token.TK_LBRACKET, this.getCurrentLine());
        }
        this.next();
    }

    private void addPseudoClassOrElement(Token t, Selector selector) {
        String value;
        switch (value = this.getTokenValue(t)) {
            case "link": {
                selector.addLinkCondition();
                break;
            }
            case "visited": {
                selector.setPseudoClass(2);
                break;
            }
            case "hover": {
                selector.setPseudoClass(4);
                break;
            }
            case "focus": {
                selector.setPseudoClass(16);
                break;
            }
            case "active": {
                selector.setPseudoClass(8);
                break;
            }
            case "first-child": {
                selector.addFirstChildCondition();
                break;
            }
            case "even": {
                selector.addEvenChildCondition();
                break;
            }
            case "odd": {
                selector.addOddChildCondition();
                break;
            }
            case "last-child": {
                selector.addLastChildCondition();
                break;
            }
            case "first-line": 
            case "first-letter": 
            case "before": 
            case "after": {
                selector.setPseudoElement(value);
                break;
            }
            default: {
                throw new CSSParseException(value + " is not a recognized pseudo-class", this.getCurrentLine());
            }
        }
    }

    private void addPseudoClassOrElementFunction(Token t, Selector selector) throws IOException {
        String f;
        String f0 = this.getTokenValue(t);
        switch (f = f0.substring(0, f0.length() - 1)) {
            case "lang": {
                this.skip_whitespace();
                t = this.next();
                if (t == Token.TK_IDENT) {
                    String lang = this.getTokenValue(t);
                    selector.addLangCondition(lang);
                    this.skip_whitespace();
                    t = this.next();
                    break;
                }
                this.push(t);
                throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
            }
            case "nth-child": {
                StringBuilder number = new StringBuilder();
                while ((t = this.next()) != null && (t == Token.TK_IDENT || t == Token.TK_S || t == Token.TK_NUMBER || t == Token.TK_DIMENSION || t == Token.TK_PLUS || t == Token.TK_MINUS)) {
                    number.append(this.getTokenValue(t));
                }
                try {
                    selector.addNthChildCondition(number.toString());
                    break;
                }
                catch (CSSParseException e) {
                    e.setLine(this.getCurrentLine());
                    this.push(t);
                    throw e;
                }
            }
            default: {
                this.push(t);
                throw new CSSParseException(f + " is not a valid function in this context", this.getCurrentLine());
            }
        }
        if (t != Token.TK_RPAREN) {
            this.push(t);
            throw new CSSParseException(t, Token.TK_RPAREN, this.getCurrentLine());
        }
    }

    private void addPseudoElement(Token t, Selector selector) {
        String value;
        switch (value = this.getTokenValue(t)) {
            case "first-line": 
            case "first-letter": 
            case "before": 
            case "after": {
                selector.setPseudoElement(value);
                break;
            }
            default: {
                throw new CSSParseException(value + " is not a recognized pseudo-element", this.getCurrentLine());
            }
        }
    }

    private void pseudo(Selector selector) throws IOException {
        block6: {
            Token t;
            block5: {
                t = this.next();
                if (t != Token.TK_COLON) break block5;
                t = this.next();
                switch (t.getType()) {
                    case COLON: {
                        t = this.next();
                        this.addPseudoElement(t, selector);
                        break block6;
                    }
                    case IDENT: {
                        this.addPseudoClassOrElement(t, selector);
                        break block6;
                    }
                    case FUNCTION: {
                        this.addPseudoClassOrElementFunction(t, selector);
                        break block6;
                    }
                    default: {
                        this.push(t);
                        throw new CSSParseException(t, new Token[]{Token.TK_IDENT, Token.TK_FUNCTION}, this.getCurrentLine());
                    }
                }
            }
            this.push(t);
            throw new CSSParseException(t, Token.TK_COLON, this.getCurrentLine());
        }
    }

    private boolean checkCSSName(@Nullable CSSName cssName, String propertyName) {
        if (cssName == null) {
            this._errorHandler.error(this._uri, propertyName + " is an unrecognized CSS property at line " + this.getCurrentLine() + ". Ignoring declaration.");
            return false;
        }
        if (!CSSName.isImplemented(cssName)) {
            this._errorHandler.error(this._uri, propertyName + " is not implemented at line " + this.getCurrentLine() + ". Ignoring declaration.");
            return false;
        }
        PropertyBuilder builder = CSSName.getPropertyBuilder(cssName);
        if (builder == null) {
            this._errorHandler.error(this._uri, "(bug) No property builder defined for " + propertyName + " at line " + this.getCurrentLine() + ". Ignoring declaration.");
            return false;
        }
        return true;
    }

    private void declaration(Ruleset ruleset, boolean inFontFace) throws IOException {
        block9: {
            try {
                Token t = this.la();
                if (t == Token.TK_IDENT) {
                    String propertyName = this.property();
                    CSSName cssName = CSSName.getByPropertyName(propertyName);
                    boolean valid = this.checkCSSName(cssName, propertyName);
                    t = this.next();
                    if (t == Token.TK_COLON) {
                        this.skip_whitespace();
                        List<PropertyValue> values = this.expr(CSSName.FONT_FAMILY.equals(cssName) || CSSName.FONT_SHORTHAND.equals(cssName) || CSSName.FS_PDF_FONT_ENCODING.equals(cssName));
                        boolean important = false;
                        t = this.la();
                        if (t == Token.TK_IMPORTANT_SYM) {
                            this.prio();
                            important = true;
                        }
                        if ((t = this.la()) != Token.TK_SEMICOLON && t != Token.TK_RBRACE && t != Token.TK_EOF) {
                            throw new CSSParseException(t, new Token[]{Token.TK_SEMICOLON, Token.TK_RBRACE}, this.getCurrentLine());
                        }
                        if (valid) {
                            try {
                                PropertyBuilder builder = CSSName.getPropertyBuilder(cssName);
                                ruleset.addAllProperties(builder.buildDeclarations(cssName, values, ruleset.getOrigin(), important, !inFontFace));
                            }
                            catch (CSSParseException e) {
                                e.setLine(this.getCurrentLine());
                                this.error(e, "declaration", true);
                            }
                        }
                        break block9;
                    }
                    this.push(t);
                    throw new CSSParseException(t, Token.TK_COLON, this.getCurrentLine());
                }
                throw new CSSParseException(t, Token.TK_IDENT, this.getCurrentLine());
            }
            catch (CSSParseException e) {
                this.error(e, "declaration", true);
                this.recover(false, true);
            }
        }
    }

    private void prio() throws IOException {
        Token t = this.next();
        if (t != Token.TK_IMPORTANT_SYM) {
            this.push(t);
            throw new CSSParseException(t, Token.TK_IMPORTANT_SYM, this.getCurrentLine());
        }
        this.skip_whitespace();
    }

    private List<PropertyValue> expr(boolean literal) throws IOException {
        boolean operator;
        Token t;
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>(10);
        result.add(this.term(literal, null));
        block6: while (true) {
            t = this.la();
            operator = false;
            Token operatorToken = null;
            switch (t.getType()) {
                case VIRGULE: 
                case COMMA: {
                    operatorToken = t;
                    this.operator();
                    t = this.la();
                    operator = true;
                }
            }
            switch (t.getType()) {
                case STRING: 
                case URI: 
                case IDENT: 
                case HASH: 
                case PLUS: 
                case FUNCTION: 
                case MINUS: 
                case NUMBER: 
                case PERCENTAGE: 
                case PX: 
                case CM: 
                case MM: 
                case IN: 
                case PT: 
                case PC: 
                case EMS: 
                case EXS: 
                case ANGLE: 
                case TIME: 
                case FREQ: {
                    result.add(this.term(literal, operatorToken));
                    continue block6;
                }
            }
            break;
        }
        if (operator) {
            throw new CSSParseException(t, new Token[]{Token.TK_NUMBER, Token.TK_PLUS, Token.TK_MINUS, Token.TK_PERCENTAGE, Token.TK_PX, Token.TK_EMS, Token.TK_EXS, Token.TK_PC, Token.TK_MM, Token.TK_CM, Token.TK_IN, Token.TK_PT, Token.TK_ANGLE, Token.TK_TIME, Token.TK_FREQ, Token.TK_STRING, Token.TK_IDENT, Token.TK_URI, Token.TK_HASH, Token.TK_FUNCTION}, this.getCurrentLine());
        }
        return result;
    }

    private String extractNumber(Token t) {
        char[] ch;
        String token = this.getTokenValue(t);
        int offset = 0;
        for (char c : ch = token.toCharArray()) {
            if (c < '0' || c > '9') break;
            ++offset;
        }
        if (ch[offset] == '.') {
            char c;
            for (int i = ++offset; i < ch.length && (c = ch[i]) >= '0' && c <= '9'; ++i) {
                ++offset;
            }
        }
        return token.substring(0, offset);
    }

    private String extractUnit(Token t) {
        String s = this.extractNumber(t);
        return this.getTokenValue(t).substring(s.length());
    }

    private String sign(float sign) {
        return sign == -1.0f ? "-" : "";
    }

    private PropertyValue term(boolean literal, @Nullable Token operatorToken) throws IOException {
        PropertyValue result;
        float sign = 1.0f;
        Token t = this.la();
        if (t == Token.TK_PLUS || t == Token.TK_MINUS) {
            sign = this.unary_operator();
            t = this.la();
        }
        switch (t.getType()) {
            case ANGLE: {
                String unit;
                short type = switch (unit = this.extractUnit(t)) {
                    case "deg" -> 11;
                    case "rad" -> 12;
                    default -> throw new CSSParseException("Unsupported CSS unit " + unit, this.getCurrentLine());
                };
                result = new PropertyValue(type, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t));
                this.next();
                this.skip_whitespace();
                break;
            }
            case TIME: 
            case FREQ: 
            case DIMENSION: {
                throw new CSSParseException("Unsupported CSS unit " + this.extractUnit(t), this.getCurrentLine());
            }
            case NUMBER: {
                result = new PropertyValue(1, sign * Float.parseFloat(this.getTokenValue(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case PERCENTAGE: {
                result = new PropertyValue(2, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case EMS: {
                result = new PropertyValue(3, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case EXS: {
                result = new PropertyValue(4, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case PX: {
                result = new PropertyValue(5, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case CM: {
                result = new PropertyValue(6, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case MM: {
                result = new PropertyValue(7, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case IN: {
                result = new PropertyValue(8, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case PT: {
                result = new PropertyValue(9, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case PC: {
                result = new PropertyValue(10, sign * Float.parseFloat(this.extractNumber(t)), this.sign(sign) + this.getTokenValue(t), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case STRING: {
                String s = this.getTokenValue(t);
                result = new PropertyValue(19, s, this.getRawTokenValue(), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case IDENT: {
                String value = this.getTokenValue(t, literal);
                result = new PropertyValue(21, value, value, operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case URI: {
                result = new PropertyValue(20, this.getTokenValue(t), this.getRawTokenValue(), operatorToken);
                this.next();
                this.skip_whitespace();
                break;
            }
            case HASH: {
                result = this.hexcolor(operatorToken);
                break;
            }
            case FUNCTION: {
                result = this.function(operatorToken);
                break;
            }
            default: {
                throw new CSSParseException(t, new Token[]{Token.TK_NUMBER, Token.TK_PERCENTAGE, Token.TK_PX, Token.TK_EMS, Token.TK_EXS, Token.TK_PC, Token.TK_MM, Token.TK_CM, Token.TK_IN, Token.TK_PT, Token.TK_ANGLE, Token.TK_TIME, Token.TK_FREQ, Token.TK_STRING, Token.TK_IDENT, Token.TK_URI, Token.TK_HASH, Token.TK_FUNCTION}, this.getCurrentLine());
            }
        }
        return result;
    }

    private PropertyValue function(Token operatorToken) throws IOException {
        PropertyValue result;
        Token t = this.next();
        if (t == Token.TK_FUNCTION) {
            String f = this.getTokenValue(t);
            this.skip_whitespace();
            List<PropertyValue> params = this.expr(false);
            t = this.next();
            if (t != Token.TK_RPAREN) {
                this.push(t);
                throw new CSSParseException(t, Token.TK_RPAREN, this.getCurrentLine());
            }
            if (f.equals("rgb(") || f.equals("rgba(")) {
                result = new PropertyValue(this.createRGBColorFromFunction(params), operatorToken);
            } else if (f.equals("cmyk(")) {
                if (!this.isSupportCMYKColors()) {
                    throw new CSSParseException("The current output device does not support CMYK colors", this.getCurrentLine());
                }
                result = new PropertyValue(this.createCMYKColorFromFunction(params), operatorToken);
            } else {
                result = new PropertyValue(new FSFunction(f.substring(0, f.length() - 1), params), operatorToken);
            }
        } else {
            this.push(t);
            throw new CSSParseException(t, Token.TK_FUNCTION, this.getCurrentLine());
        }
        this.skip_whitespace();
        return result;
    }

    private FSCMYKColor createCMYKColorFromFunction(List<PropertyValue> params) {
        if (params.size() != 4) {
            throw new CSSParseException("The cmyk() function must have exactly four parameters", this.getCurrentLine());
        }
        float[] colorComponents = new float[4];
        for (int i = 0; i < params.size(); ++i) {
            colorComponents[i] = this.parseCMYKColorComponent(params.get(i), i + 1);
        }
        return new FSCMYKColor(colorComponents[0], colorComponents[1], colorComponents[2], colorComponents[3]);
    }

    private float parseCMYKColorComponent(PropertyValue value, int paramNo) {
        float result;
        short type = value.getPrimitiveType();
        if (type == 1) {
            result = value.getFloatValue();
        } else if (type == 2) {
            result = value.getFloatValue() / 100.0f;
        } else {
            throw new CSSParseException("Parameter " + paramNo + " to the cmyk() function is not a number or a percentage", this.getCurrentLine());
        }
        if (result < 0.0f || result > 1.0f) {
            throw new CSSParseException("Parameter " + paramNo + " to the cmyk() function must be between zero and one", this.getCurrentLine());
        }
        return result;
    }

    private FSRGBColor createRGBColorFromFunction(List<PropertyValue> params) {
        if (params.size() != 3 && params.size() != 4) {
            throw new CSSParseException("The rgb() function must have three or four parameters", this.getCurrentLine());
        }
        int red = (int)this.calculateColor(params, 0);
        int green = (int)this.calculateColor(params, 1);
        int blue = (int)this.calculateColor(params, 2);
        float alpha = params.size() < 4 ? 1.0f : this.calculateColor(params, 3);
        return new FSRGBColor(red, green, blue, alpha);
    }

    private float calculateColor(List<PropertyValue> params, int index) {
        float f;
        PropertyValue value = params.get(index);
        short type = this.validateType(index, value);
        switch (type) {
            case 2: {
                float f2 = value.getFloatValue() / 100.0f * 255.0f;
                break;
            }
            default: {
                float f2 = f = value.getFloatValue();
            }
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 255.0f) {
            return 255.0f;
        }
        return f;
    }

    private short validateType(int index, PropertyValue value) {
        short type = value.getPrimitiveType();
        if (type != 2 && type != 1) {
            throw new CSSParseException("Parameter " + (index + 1) + " to the rgb() function is not a number or percentage", this.getCurrentLine());
        }
        if (type != 1 && index == 3) {
            throw new CSSParseException("Parameter alpha to the rgba() function is not a number", this.getCurrentLine());
        }
        return type;
    }

    private PropertyValue hexcolor(Token operatorToken) throws IOException {
        String s;
        Token t = this.next();
        if (t == Token.TK_HASH) {
            s = this.getTokenValue(t);
            if (s.length() != 3 && s.length() != 6 || !this.isHexString(s)) {
                this.push(t);
                throw new CSSParseException("#" + s + " is not a valid color definition", this.getCurrentLine());
            }
        } else {
            this.push(t);
            throw new CSSParseException(t, Token.TK_HASH, this.getCurrentLine());
        }
        FSRGBColor color = s.length() == 3 ? new FSRGBColor(this.convertToInteger(s.charAt(0), s.charAt(0)), this.convertToInteger(s.charAt(1), s.charAt(1)), this.convertToInteger(s.charAt(2), s.charAt(2))) : new FSRGBColor(this.convertToInteger(s.charAt(0), s.charAt(1)), this.convertToInteger(s.charAt(2), s.charAt(3)), this.convertToInteger(s.charAt(4), s.charAt(5)));
        PropertyValue result = new PropertyValue(color, operatorToken);
        this.skip_whitespace();
        return result;
    }

    private boolean isHexString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (CSSParser.isHexChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private int convertToInteger(char hexchar1, char hexchar2) {
        int result = this.convertToInteger(hexchar1);
        result <<= 4;
        return result |= this.convertToInteger(hexchar2);
    }

    private int convertToInteger(char hexchar1) {
        if (hexchar1 >= '0' && hexchar1 <= '9') {
            return hexchar1 - 48;
        }
        if (hexchar1 >= 'a' && hexchar1 <= 'f') {
            return hexchar1 - 97 + 10;
        }
        return hexchar1 - 65 + 10;
    }

    private void skip_whitespace() throws IOException {
        Token t;
        while ((t = this.next()) == Token.TK_S) {
        }
        this.push(t);
    }

    private void skip_whitespace_and_cdocdc() throws IOException {
        Token t;
        while ((t = this.next()) == Token.TK_S || t == Token.TK_CDO || t == Token.TK_CDC) {
        }
        this.push(t);
    }

    private Token next() throws IOException {
        if (this._saved != null) {
            Token result = this._saved;
            this._saved = null;
            return result;
        }
        return this._lexer.yylex();
    }

    private void push(Token t) {
        if (this._saved != null) {
            throw new RuntimeException("saved must be null");
        }
        this._saved = t;
    }

    private Token la() throws IOException {
        Token result = this.next();
        this.push(result);
        return result;
    }

    private void error(CSSParseException e, String what, boolean rethrowEOF) {
        if (!e.isCallerNotified()) {
            String message = e.getMessage() + " Skipping " + what + ".";
            this._errorHandler.error(this._uri, message);
        }
        e.setCallerNotified(true);
        if (e.isEOF() && rethrowEOF) {
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recover(boolean needBlock, boolean stopBeforeBlockClose) throws IOException {
        int braces = 0;
        boolean foundBlock = false;
        block5: while (true) {
            Token t;
            if ((t = this.next()) == Token.TK_EOF) {
                return;
            }
            switch (t.getType()) {
                case LBRACE: {
                    foundBlock = true;
                    ++braces;
                    break;
                }
                case RBRACE: {
                    if (braces == 0) {
                        if (!stopBeforeBlockClose) break;
                        this.push(t);
                        break block5;
                    }
                    if (--braces != 0) break;
                    break block5;
                }
                case SEMICOLON: {
                    if (braces == 0 && (!needBlock || foundBlock)) break block5;
                }
            }
        }
        this.skip_whitespace();
    }

    public void reset(Reader r) {
        this._saved = null;
        this._namespaces.clear();
        this._lexer.yyreset(r);
        this._lexer.setyyline(0);
    }

    private String getRawTokenValue() {
        return this._lexer.yytext();
    }

    private String getTokenValue(Token t) {
        return this.getTokenValue(t, false);
    }

    private String getTokenValue(Token t, boolean literal) {
        return switch (t.getType()) {
            case Token.Type.STRING -> CSSParser.processEscapes(this._lexer.yytext().toCharArray(), 1, this._lexer.yylength() - 1);
            case Token.Type.HASH -> CSSParser.processEscapes(this._lexer.yytext().toCharArray(), 1, this._lexer.yylength());
            case Token.Type.URI -> {
                int uriOffset;
                int firstSlashAfterProtocol;
                Object uriResult;
                char[] ch = this._lexer.yytext().toCharArray();
                int start = 4;
                while (ch[start] == '\t' || ch[start] == '\r' || ch[start] == '\n' || ch[start] == '\f') {
                    ++start;
                }
                if (ch[start] == '\'' || ch[start] == '\"') {
                    ++start;
                }
                int end = ch.length - 2;
                while (ch[end] == '\t' || ch[end] == '\r' || ch[end] == '\n' || ch[end] == '\f') {
                    --end;
                }
                if (ch[end] == '\'' || ch[end] == '\"') {
                    --end;
                }
                if (this.isRelativeURI((String)(uriResult = CSSParser.processEscapes(ch, start, end + 1))) && this._uri != null) {
                    int lastSlash = this._uri.lastIndexOf(47);
                    if (lastSlash != -1) {
                        uriResult = this._uri.substring(0, lastSlash + 1) + (String)uriResult;
                    }
                } else if (this.isServerRelativeURI((String)uriResult) && this._uri != null && (firstSlashAfterProtocol = this._uri.substring(uriOffset = this._uri.indexOf("://") + 3).indexOf(47)) != -1) {
                    uriResult = this._uri.substring(0, uriOffset + firstSlashAfterProtocol) + (String)uriResult;
                }
                yield uriResult;
            }
            case Token.Type.AT_RULE, Token.Type.IDENT, Token.Type.FUNCTION -> {
                int start = 0;
                int count = this._lexer.yylength();
                if (t.getType() == Token.Type.AT_RULE) {
                    ++start;
                }
                String result = CSSParser.processEscapes(this._lexer.yytext().toCharArray(), start, count);
                if (!literal) {
                    result = result.toLowerCase(Locale.ROOT);
                }
                yield result;
            }
            default -> this._lexer.yytext();
        };
    }

    private boolean isRelativeURI(String uri) {
        try {
            return !uri.isEmpty() && uri.charAt(0) != '/' && !new URI(uri).isAbsolute();
        }
        catch (URISyntaxException ignore) {
            return false;
        }
    }

    private boolean isServerRelativeURI(String uri) {
        try {
            return !uri.isEmpty() && uri.charAt(0) == '/' && !new URI(uri).isAbsolute();
        }
        catch (URISyntaxException ignore) {
            return false;
        }
    }

    private int getCurrentLine() {
        return this._lexer.yyline();
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static String processEscapes(char[] ch, int start, int end) {
        StringBuilder result = new StringBuilder(ch.length + 10);
        for (int i = start; i < end; ++i) {
            char c = ch[i];
            if (c == '\\') {
                if (i < end - 2 && ch[i + 1] == '\r' && ch[i + 2] == '\n') {
                    i += 2;
                    continue;
                }
                if (i + 1 < ch.length && (ch[i + 1] == '\n' || ch[i + 1] == '\r' || ch[i + 1] == '\f')) {
                    ++i;
                    continue;
                }
                if (i + 1 >= ch.length) {
                    result.append(c);
                    continue;
                }
                if (!CSSParser.isHexChar(ch[i + 1])) continue;
                int current = ++i;
                while (i < end && CSSParser.isHexChar(ch[i]) && i - current < 6) {
                    ++i;
                }
                int cvalue = Integer.parseInt(new String(ch, current, i - current), 16);
                if (cvalue < 65535) {
                    result.append((char)cvalue);
                }
                if (--i < end - 2 && ch[i + 1] == '\r' && ch[i + 2] == '\n') {
                    i += 2;
                    continue;
                }
                if (i >= end - 1 || ch[i + 1] != ' ' && ch[i + 1] != '\t' && ch[i + 1] != '\n' && ch[i + 1] != '\r' && ch[i + 1] != '\f') continue;
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public boolean isSupportCMYKColors() {
        return this._supportCMYKColors;
    }

    public void setSupportCMYKColors(boolean b) {
        this._supportCMYKColors = b;
    }

    private static class NamespacePair {
        private final String _namespaceURI;
        private final String _name;

        private NamespacePair(String namespaceURI, String name) {
            this._namespaceURI = namespaceURI;
            this._name = name;
        }

        public String getNamespaceURI() {
            return this._namespaceURI;
        }

        public String getName() {
            return this._name;
        }
    }
}

