/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.log;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.drake.net.Net;
import com.drake.net.log.LogRecorder;
import com.drake.net.log.MessageType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0003J\b\u0010&\u001a\u00020\u0004H\u0007J\"\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020\u000bH\u0002J;\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u000b2\b\u0010/\u001a\u0004\u0018\u00010\u00042\b\u00100\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u00101JD\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000407062\b\u00108\u001a\u0004\u0018\u00010\u0004H\u0007JD\u00109\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000407062\b\u00108\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/drake/net/log/LogRecorder;", "", "()V", "DELIMITER", "", "HEADER_DELIMITER", "", "KEY_PARTS_COUNT", "KEY_TAG", "KEY_VALUE", "LOG_LENGTH", "", "LOG_PREFIX", "SLOW_DOWN_PARTS_AFTER", "SPACE", "enabled", "", "getEnabled$annotations", "getEnabled", "()Z", "setEnabled", "(Z)V", "format", "Ljava/text/DateFormat;", "handler", "Lcom/drake/net/log/LogRecorder$LogBodyHandler;", "getHandler", "()Lcom/drake/net/log/LogRecorder$LogBodyHandler;", "handler$delegate", "Lkotlin/Lazy;", "previousTime", "Ljava/util/concurrent/atomic/AtomicLong;", "fastLog", "", "id", "type", "Lcom/drake/net/log/MessageType;", "message", "generateId", "largeLog", "content", "logWithHandler", "partsCount", "recordException", "requestMillis", "", "code", "response", "error", "(Ljava/lang/String;JLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "recordRequest", "url", "method", "headers", "", "", "body", "recordResponse", "LogBodyHandler", "net_release"})
public final class LogRecorder {
    @NotNull
    public static final LogRecorder INSTANCE = new LogRecorder();
    private static boolean enabled = true;
    @NotNull
    private static final Lazy handler$delegate = LazyKt.lazy((Function0)handler.2.INSTANCE);
    private static final int LOG_LENGTH = 4000;
    private static final int SLOW_DOWN_PARTS_AFTER = 20;
    @NotNull
    private static final String LOG_PREFIX = "OKPRFL";
    @NotNull
    private static final String DELIMITER = "_";
    private static final char HEADER_DELIMITER = ':';
    private static final char SPACE = ' ';
    @NotNull
    private static final String KEY_TAG = "TAG";
    @NotNull
    private static final String KEY_VALUE = "VALUE";
    @NotNull
    private static final String KEY_PARTS_COUNT = "PARTS_COUNT";
    @NotNull
    private static final DateFormat format = new SimpleDateFormat("ddhhmmssSSS", Locale.US);
    @NotNull
    private static final AtomicLong previousTime = new AtomicLong();

    private LogRecorder() {
    }

    public static final boolean getEnabled() {
        return enabled;
    }

    public static final void setEnabled(boolean bl) {
        enabled = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getEnabled$annotations() {
    }

    private final LogBodyHandler getHandler() {
        Lazy lazy = handler$delegate;
        return (LogBodyHandler)((Object)lazy.getValue());
    }

    @JvmStatic
    @NotNull
    public static final synchronized String generateId() {
        if (!enabled) {
            return "";
        }
        String string2 = format.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(Date())");
        long currentTime = Long.parseLong(string2);
        long previousTime = LogRecorder.previousTime.get();
        if (currentTime <= previousTime) {
            currentTime = ++previousTime;
        }
        LogRecorder.previousTime.set(currentTime);
        String string3 = Long.toString(currentTime, CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        return string3;
    }

    @JvmStatic
    public static final void recordRequest(@NotNull String id, @NotNull String url, @NotNull String method, @NotNull Map<String, ? extends List<String>> headers, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (!enabled) {
            return;
        }
        INSTANCE.fastLog(id, MessageType.REQUEST_METHOD, method);
        INSTANCE.fastLog(id, MessageType.REQUEST_URL, url);
        INSTANCE.fastLog(id, MessageType.REQUEST_TIME, String.valueOf(System.currentTimeMillis()));
        for (Map.Entry<String, ? extends List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            String header = value.toString();
            if (header.length() > 2) {
                String string2 = header.substring(1, header.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                header = string2;
            }
            INSTANCE.fastLog(id, MessageType.REQUEST_HEADER, key + ": " + header);
        }
        INSTANCE.largeLog(id, MessageType.REQUEST_BODY, body);
    }

    @JvmStatic
    public static final void recordResponse(@NotNull String id, long requestMillis, int code, @NotNull Map<String, ? extends List<String>> headers, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (!enabled) {
            return;
        }
        INSTANCE.largeLog(id, MessageType.RESPONSE_BODY, body);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_STATUS, String.valueOf(code), 0);
        for (Map.Entry<String, ? extends List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            String header = value.toString();
            if (header.length() > 2) {
                String string2 = header.substring(1, header.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                header = string2;
            }
            INSTANCE.logWithHandler(id, MessageType.RESPONSE_HEADER, key + ':' + header, 0);
        }
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_TIME, String.valueOf(System.currentTimeMillis() - requestMillis), 0);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_END, "-->", 0);
    }

    @JvmStatic
    public static final void recordException(@NotNull String id, long requestMillis, @Nullable Integer code, @Nullable String response, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!enabled) {
            return;
        }
        INSTANCE.largeLog(id, MessageType.RESPONSE_BODY, response);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_STATUS, String.valueOf(code), 0);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_ERROR, error, 0);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_TIME, String.valueOf(System.currentTimeMillis() - requestMillis), 0);
        INSTANCE.logWithHandler(id, MessageType.RESPONSE_END, "-->", 0);
    }

    @SuppressLint(value={"LogNotTimber"})
    private final void fastLog(String id, MessageType type, String message) {
        String tag = "OKPRFL_" + id + '_' + type.getType();
        if (message != null) {
            Log.v((String)tag, (String)message);
        }
    }

    private final void logWithHandler(String id, MessageType type, String message, int partsCount) {
        if (message == null) {
            return;
        }
        Message message2 = this.getHandler().obtainMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"handler.obtainMessage()");
        Message handlerMessage = message2;
        String tag = "OKPRFL_" + id + '_' + type.getType();
        Bundle bundle = new Bundle();
        bundle.putString(KEY_TAG, tag);
        bundle.putString(KEY_VALUE, message);
        bundle.putInt(KEY_PARTS_COUNT, partsCount);
        handlerMessage.setData(bundle);
        this.getHandler().sendMessage(handlerMessage);
    }

    private final void largeLog(String id, MessageType type, String content) {
        if (content == null) {
            return;
        }
        int contentLength2 = content.length();
        if (contentLength2 > 4000) {
            int i = 0;
            int parts = contentLength2 / 4000;
            if (i <= parts) {
                while (true) {
                    int start;
                    int end;
                    if ((end = (start = i * 4000) + 4000) > contentLength2) {
                        end = contentLength2;
                    }
                    String string2 = content.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    this.logWithHandler(id, type, string2, parts);
                    if (i != parts) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.logWithHandler(id, type, content, 0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/drake/net/log/LogRecorder$LogBodyHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Landroid/os/Looper;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "net_release"})
    private static final class LogBodyHandler
    extends Handler {
        public LogBodyHandler(@NotNull Looper looper) {
            Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
            super(looper);
        }

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Bundle bundle = msg.getData();
            if (bundle != null) {
                String string2;
                int partsCount = bundle.getInt(LogRecorder.KEY_PARTS_COUNT, 0);
                if (partsCount > 20) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        Net.debug(e);
                    }
                }
                if ((string2 = bundle.getString(LogRecorder.KEY_VALUE)) == null) {
                    string2 = "null";
                }
                String data = string2;
                String key = bundle.getString(LogRecorder.KEY_TAG);
                Log.v((String)key, (String)data);
            }
        }
    }
}

