/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.interceptor;

import com.drake.net.body.BodyExtensionKt;
import com.drake.net.interceptor.LogRecordInterceptor;
import com.drake.net.log.LogRecorder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/drake/net/interceptor/LogRecordInterceptor;", "Lokhttp3/Interceptor;", "enabled", "", "requestByteCount", "", "responseByteCount", "(ZJJ)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getRequestByteCount", "()J", "setRequestByteCount", "(J)V", "getResponseByteCount", "setResponseByteCount", "getRequestLog", "", "request", "Lokhttp3/Request;", "getResponseLog", "response", "Lokhttp3/Response;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "net_release"})
public class LogRecordInterceptor
implements Interceptor {
    private boolean enabled;
    private long requestByteCount;
    private long responseByteCount;

    @JvmOverloads
    public LogRecordInterceptor(boolean enabled, long requestByteCount, long responseByteCount) {
        this.enabled = enabled;
        this.requestByteCount = requestByteCount;
        this.responseByteCount = responseByteCount;
    }

    public /* synthetic */ LogRecordInterceptor(boolean bl, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0x100000L;
        }
        if ((n & 4) != 0) {
            l2 = 0x400000L;
        }
        this(bl, l, l2);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final long getRequestByteCount() {
        return this.requestByteCount;
    }

    public final void setRequestByteCount(long l) {
        this.requestByteCount = l;
    }

    public final long getResponseByteCount() {
        return this.responseByteCount;
    }

    public final void setResponseByteCount(long l) {
        this.responseByteCount = l;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        if (!this.enabled) {
            return chain.proceed(request);
        }
        String generateId = LogRecorder.generateId();
        LogRecorder.recordRequest(generateId, request.url().toString(), request.method(), request.headers().toMultimap(), this.getRequestLog(request));
        try {
            Response response = chain.proceed(request);
            LogRecorder.recordResponse(generateId, System.currentTimeMillis(), response.code(), response.headers().toMultimap(), this.getResponseLog(response));
            return response;
        }
        catch (Exception e) {
            String error = "Review LogCat for details, occurred exception: " + e.getClass().getSimpleName();
            LogRecorder.recordException(generateId, System.currentTimeMillis(), -1, null, error);
            throw e;
        }
    }

    @Nullable
    protected String getRequestLog(@NotNull Request request) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return null;
        }
        RequestBody body = requestBody;
        MediaType mediaType = body.contentType();
        if (body instanceof MultipartBody) {
            string2 = CollectionsKt.joinToString$default((Iterable)((MultipartBody)body).parts(), (CharSequence)"&", null, null, (int)0, null, (Function1)getRequestLog.1.INSTANCE, (int)30, null);
        } else if (body instanceof FormBody) {
            string2 = BodyExtensionKt.peekBytes(body, this.requestByteCount).utf8();
        } else {
            Object[] objectArray = new String[]{"plain", "json", "xml", "html"};
            MediaType mediaType2 = mediaType;
            string2 = ArraysKt.contains((Object[])objectArray, (Object)(mediaType2 != null ? mediaType2.subtype() : null)) ? BodyExtensionKt.peekBytes(body, this.requestByteCount).utf8() : mediaType + " does not support output logs";
        }
        return string2;
    }

    @Nullable
    protected String getResponseLog(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return null;
        }
        ResponseBody body = responseBody;
        MediaType mediaType = body.contentType();
        Object[] objectArray = new String[]{"plain", "json", "xml", "html"};
        MediaType mediaType2 = mediaType;
        boolean isPrintType = ArraysKt.contains((Object[])objectArray, (Object)(mediaType2 != null ? mediaType2.subtype() : null));
        return isPrintType ? BodyExtensionKt.peekBytes(body, this.responseByteCount).utf8() : mediaType + " does not support output logs";
    }

    @JvmOverloads
    public LogRecordInterceptor(boolean enabled, long requestByteCount) {
        this(enabled, requestByteCount, 0L, 4, null);
    }

    @JvmOverloads
    public LogRecordInterceptor(boolean enabled) {
        this(enabled, 0L, 0L, 6, null);
    }
}

