/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.convert;

import com.drake.net.NetConfig;
import com.drake.net.R;
import com.drake.net.convert.NetConverter;
import com.drake.net.exception.ConvertException;
import com.drake.net.exception.RequestParamsException;
import com.drake.net.exception.ResponseException;
import com.drake.net.exception.ServerResponseException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/drake/net/convert/JSONConvert;", "Lcom/drake/net/convert/NetConverter;", "success", "", "code", "message", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getMessage", "getSuccess", "onConvert", "R", "succeed", "Ljava/lang/reflect/Type;", "response", "Lokhttp3/Response;", "(Ljava/lang/reflect/Type;Lokhttp3/Response;)Ljava/lang/Object;", "parseBody", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "net_release"})
public abstract class JSONConvert
implements NetConverter {
    @NotNull
    private final String success;
    @NotNull
    private final String code;
    @NotNull
    private final String message;

    public JSONConvert(@NotNull String success, @NotNull String code, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)success, (String)"success");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.success = success;
        this.code = code;
        this.message = message;
    }

    public /* synthetic */ JSONConvert(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "0";
        }
        if ((n & 2) != 0) {
            string3 = "code";
        }
        if ((n & 4) != 0) {
            string4 = "msg";
        }
        this(string2, string3, string4);
    }

    @NotNull
    public final String getSuccess() {
        return this.success;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public <R> R onConvert(@NotNull Type succeed, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)succeed, (String)"succeed");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            return NetConverter.DEFAULT.onConvert(succeed, response);
        }
        catch (ConvertException e) {
            int code = response.code();
            boolean bl = 200 <= code ? code < 300 : false;
            if (bl) {
                R r;
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    return null;
                }
                Object bodyString = object;
                try {
                    JSONObject json = new JSONObject((String)bodyString);
                    String srvCode = json.getString(this.code);
                    if (!Intrinsics.areEqual((Object)srvCode, (Object)this.success)) {
                        String errorMessage = json.optString(this.message, NetConfig.INSTANCE.getApp().getString(R.string.no_error_message));
                        throw new ResponseException(response, errorMessage, null, srvCode, 4, null);
                    }
                    r = this.parseBody((String)bodyString, succeed);
                }
                catch (JSONException e2) {
                    r = this.parseBody((String)bodyString, succeed);
                }
                return r;
            }
            boolean bl2 = 400 <= code ? code < 500 : false;
            if (bl2) {
                throw new RequestParamsException(response, String.valueOf(code), null, null, 12, null);
            }
            if (code >= 500) {
                throw new ServerResponseException(response, String.valueOf(code), null, null, 12, null);
            }
            throw new ConvertException(response, "Http status code not within range", null, null, 12, null);
        }
    }

    @Nullable
    public abstract <R> R parseBody(@NotNull String var1, @NotNull Type var2);

    public JSONConvert() {
        this(null, null, null, 7, null);
    }
}

