/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.okhttp;

import com.drake.net.NetConfig;
import com.drake.net.convert.NetConverter;
import com.drake.net.interceptor.NetOkHttpInterceptor;
import com.drake.net.interceptor.RequestInterceptor;
import com.drake.net.interfaces.NetDialogFactory;
import com.drake.net.interfaces.NetErrorHandler;
import com.drake.net.utils.Https;
import com.drake.net.utils.HttpsKt;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a,\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\b\u001a;\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0019\"\u00020\u00162\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u001d"}, d2={"setConverter", "Lokhttp3/OkHttpClient$Builder;", "converter", "Lcom/drake/net/convert/NetConverter;", "setDebug", "enabled", "", "tag", "", "setDialogFactory", "dialogFactory", "Lcom/drake/net/interfaces/NetDialogFactory;", "setErrorHandler", "handler", "Lcom/drake/net/interfaces/NetErrorHandler;", "setRequestInterceptor", "interceptor", "Lcom/drake/net/interceptor/RequestInterceptor;", "setSSLCertificate", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "bksFile", "Ljava/io/InputStream;", "password", "certificates", "", "(Lokhttp3/OkHttpClient$Builder;[Ljava/io/InputStream;Ljava/io/InputStream;Ljava/lang/String;)Lokhttp3/OkHttpClient$Builder;", "toNetOkhttp", "trustSSLCertificate", "net_release"})
public final class OkHttpBuilderKt {
    @NotNull
    public static final OkHttpClient.Builder setDebug(@NotNull OkHttpClient.Builder $this$setDebug, boolean enabled, @NotNull String tag) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        OkHttpClient.Builder $this$setDebug_u24lambda_u2d0 = builder = $this$setDebug;
        boolean bl = false;
        NetConfig.INSTANCE.setDebug(enabled);
        NetConfig.INSTANCE.setTAG(tag);
        return builder;
    }

    public static /* synthetic */ OkHttpClient.Builder setDebug$default(OkHttpClient.Builder builder, boolean bl, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = NetConfig.INSTANCE.getTAG();
        }
        return OkHttpBuilderKt.setDebug(builder, bl, string2);
    }

    @NotNull
    public static final OkHttpClient.Builder toNetOkhttp(@NotNull OkHttpClient.Builder $this$toNetOkhttp) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$toNetOkhttp, (String)"<this>");
        OkHttpClient.Builder $this$toNetOkhttp_u24lambda_u2d1 = builder = $this$toNetOkhttp;
        boolean bl = false;
        List interceptors = $this$toNetOkhttp_u24lambda_u2d1.interceptors();
        if (!interceptors.contains(NetOkHttpInterceptor.INSTANCE)) {
            $this$toNetOkhttp_u24lambda_u2d1.addInterceptor((Interceptor)NetOkHttpInterceptor.INSTANCE);
        }
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder setSSLCertificate(@NotNull OkHttpClient.Builder $this$setSSLCertificate, @Nullable X509TrustManager trustManager, @Nullable InputStream bksFile, @Nullable String password) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setSSLCertificate, (String)"<this>");
        OkHttpClient.Builder $this$setSSLCertificate_u24lambda_u2d2 = builder = $this$setSSLCertificate;
        boolean bl = false;
        try {
            X509TrustManager x509TrustManager = trustManager;
            if (x509TrustManager == null) {
                x509TrustManager = Https.INSTANCE.getUnSafeTrustManager();
            }
            X509TrustManager trustManagerFinal = x509TrustManager;
            KeyManager[] keyManagers = HttpsKt.prepareKeyManager(bksFile, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{trustManagerFinal};
            sslContext.init(keyManagers, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
            $this$setSSLCertificate_u24lambda_u2d2.sslSocketFactory(sSLSocketFactory, trustManagerFinal);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        return builder;
    }

    public static /* synthetic */ OkHttpClient.Builder setSSLCertificate$default(OkHttpClient.Builder builder, X509TrustManager x509TrustManager, InputStream inputStream, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            inputStream = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return OkHttpBuilderKt.setSSLCertificate(builder, x509TrustManager, inputStream, string2);
    }

    @NotNull
    public static final OkHttpClient.Builder setSSLCertificate(@NotNull OkHttpClient.Builder $this$setSSLCertificate, @NotNull InputStream[] certificates, @Nullable InputStream bksFile, @Nullable String password) {
        X509TrustManager x509TrustManager;
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setSSLCertificate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        OkHttpClient.Builder $this$setSSLCertificate_u24lambda_u2d4 = builder = $this$setSSLCertificate;
        boolean bl = false;
        TrustManager[] trustManagerArray = HttpsKt.prepareTrustManager(Arrays.copyOf(certificates, certificates.length));
        if (trustManagerArray != null) {
            TrustManager[] it = trustManagerArray;
            boolean bl2 = false;
            x509TrustManager = HttpsKt.chooseTrustManager(it);
        } else {
            x509TrustManager = null;
        }
        X509TrustManager trustManager = x509TrustManager;
        OkHttpBuilderKt.setSSLCertificate($this$setSSLCertificate_u24lambda_u2d4, trustManager, bksFile, password);
        return builder;
    }

    public static /* synthetic */ OkHttpClient.Builder setSSLCertificate$default(OkHttpClient.Builder builder, InputStream[] inputStreamArray, InputStream inputStream, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            inputStream = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return OkHttpBuilderKt.setSSLCertificate(builder, inputStreamArray, inputStream, string2);
    }

    @NotNull
    public static final OkHttpClient.Builder trustSSLCertificate(@NotNull OkHttpClient.Builder $this$trustSSLCertificate) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$trustSSLCertificate, (String)"<this>");
        OkHttpClient.Builder $this$trustSSLCertificate_u24lambda_u2d5 = builder = $this$trustSSLCertificate;
        boolean bl = false;
        $this$trustSSLCertificate_u24lambda_u2d5.hostnameVerifier(Https.INSTANCE.getUnSafeHostnameVerifier());
        OkHttpBuilderKt.setSSLCertificate$default($this$trustSSLCertificate_u24lambda_u2d5, null, null, null, 6, null);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder setConverter(@NotNull OkHttpClient.Builder $this$setConverter, @NotNull NetConverter converter) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setConverter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        OkHttpClient.Builder $this$setConverter_u24lambda_u2d6 = builder = $this$setConverter;
        boolean bl = false;
        NetConfig.INSTANCE.setConverter(converter);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder setRequestInterceptor(@NotNull OkHttpClient.Builder $this$setRequestInterceptor, @NotNull RequestInterceptor interceptor) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setRequestInterceptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        OkHttpClient.Builder $this$setRequestInterceptor_u24lambda_u2d7 = builder = $this$setRequestInterceptor;
        boolean bl = false;
        NetConfig.INSTANCE.setRequestInterceptor(interceptor);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder setErrorHandler(@NotNull OkHttpClient.Builder $this$setErrorHandler, @NotNull NetErrorHandler handler2) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setErrorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        OkHttpClient.Builder $this$setErrorHandler_u24lambda_u2d8 = builder = $this$setErrorHandler;
        boolean bl = false;
        NetConfig.INSTANCE.setErrorHandler(handler2);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder setDialogFactory(@NotNull OkHttpClient.Builder $this$setDialogFactory, @NotNull NetDialogFactory dialogFactory) {
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setDialogFactory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        OkHttpClient.Builder $this$setDialogFactory_u24lambda_u2d9 = builder = $this$setDialogFactory;
        boolean bl = false;
        NetConfig.INSTANCE.setDialogFactory(dialogFactory);
        return builder;
    }
}

