/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.cookie;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/drake/net/cookie/PersistentCookieJar;", "Lokhttp3/CookieJar;", "context", "Landroid/content/Context;", "dbName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "getDbName", "()Ljava/lang/String;", "sqlHelper", "Landroid/database/sqlite/SQLiteOpenHelper;", "addAll", "", "url", "Lokhttp3/HttpUrl;", "cookies", "", "Lokhttp3/Cookie;", "clear", "getAll", "loadForRequest", "remove", "cookieName", "saveFromResponse", "net_release"})
public final class PersistentCookieJar
implements CookieJar {
    @NotNull
    private final Context context;
    @NotNull
    private final String dbName;
    @NotNull
    private SQLiteOpenHelper sqlHelper;

    public PersistentCookieJar(@NotNull Context context, @NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        this.context = context;
        this.dbName = dbName;
        Context context2 = this.context;
        String string2 = this.dbName;
        this.sqlHelper = new SQLiteOpenHelper(context2, string2){

            public void onCreate(@NotNull SQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                db.execSQL("CREATE TABLE IF NOT EXISTS cookies (url TEXT, name TEXT, cookie TEXT, PRIMARY KEY(url, name))");
            }

            public void onUpgrade(@Nullable SQLiteDatabase db, int oldVersion, int newVersion) {
                block0: {
                    SQLiteDatabase sQLiteDatabase = db;
                    if (sQLiteDatabase == null) break block0;
                    sQLiteDatabase.execSQL("DROP TABLE IF EXISTS cookies");
                }
            }
        };
    }

    public /* synthetic */ PersistentCookieJar(Context context, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "net_cookies";
        }
        this(context, string2);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getDbName() {
        return this.dbName;
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        SQLiteDatabase db = this.sqlHelper.getWritableDatabase();
        Iterable $this$forEach$iv = cookies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$addAll_u24lambda_u2d1_u24lambda_u2d0;
            ContentValues contentValues;
            Cookie cookie = (Cookie)element$iv;
            boolean bl = false;
            if (cookie.expiresAt() <= System.currentTimeMillis()) continue;
            ContentValues contentValues2 = contentValues = new ContentValues();
            String string2 = null;
            String string3 = "cookies";
            SQLiteDatabase sQLiteDatabase = db;
            boolean bl2 = false;
            $this$addAll_u24lambda_u2d1_u24lambda_u2d0.put("url", url.host());
            $this$addAll_u24lambda_u2d1_u24lambda_u2d0.put("name", cookie.name());
            $this$addAll_u24lambda_u2d1_u24lambda_u2d0.put("cookie", cookie.toString());
            Unit unit = Unit.INSTANCE;
            sQLiteDatabase.replace(string3, string2, contentValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Cookie> getAll(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        SQLiteDatabase db = this.sqlHelper.getWritableDatabase();
        Object object = new String[]{url.host()};
        object = (Closeable)db.rawQuery("SELECT * FROM cookies WHERE url = ?", object);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)object;
            boolean bl = false;
            List cookies = new ArrayList();
            while (cursor.moveToNext()) {
                String cookieColumn = cursor.getString(cursor.getColumnIndex("cookie"));
                Intrinsics.checkNotNullExpressionValue((Object)cookieColumn, (String)"cookieColumn");
                Cookie cookie = Cookie.Companion.parse(url, cookieColumn);
                if (cookie == null) continue;
                if (cookie.expiresAt() > System.currentTimeMillis()) {
                    cookies.add(cookie);
                    continue;
                }
                String[] stringArray = new String[]{url.host(), cookie.name()};
                db.delete("cookies", "url = ? AND name = ?", stringArray);
            }
            List list = cookies;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public final void remove(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String[] stringArray = new String[]{url.host()};
        this.sqlHelper.getWritableDatabase().delete("cookies", "url = ?", stringArray);
    }

    public final void remove(@NotNull HttpUrl url, @NotNull String cookieName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)cookieName, (String)"cookieName");
        String[] stringArray = new String[]{url.host(), cookieName};
        this.sqlHelper.getWritableDatabase().delete("cookies", "url = ? AND name = ?", stringArray);
    }

    public final void clear() {
        this.sqlHelper.getWritableDatabase().delete("cookies", null, null);
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getAll(url);
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        this.addAll(url, cookies);
    }
}

