/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.convert;

import com.drake.net.exception.ConvertException;
import com.drake.net.response.ResponseExtensionKt;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ%\u0010\u0002\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/drake/net/convert/NetConverter;", "", "onConvert", "R", "succeed", "Ljava/lang/reflect/Type;", "response", "Lokhttp3/Response;", "(Ljava/lang/reflect/Type;Lokhttp3/Response;)Ljava/lang/Object;", "DEFAULT", "net_release"})
public interface NetConverter {
    @NotNull
    public static final DEFAULT DEFAULT = com.drake.net.convert.NetConverter$DEFAULT.$$INSTANCE;

    @Nullable
    public <R> R onConvert(@NotNull Type var1, @NotNull Response var2) throws Throwable;

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/drake/net/convert/NetConverter$DEFAULT;", "Lcom/drake/net/convert/NetConverter;", "()V", "onConvert", "R", "succeed", "Ljava/lang/reflect/Type;", "response", "Lokhttp3/Response;", "(Ljava/lang/reflect/Type;Lokhttp3/Response;)Ljava/lang/Object;", "net_release"})
    public static final class DEFAULT
    implements NetConverter {
        static final /* synthetic */ DEFAULT $$INSTANCE;

        private DEFAULT() {
        }

        @Override
        @Nullable
        public <R> R onConvert(@NotNull Type succeed, @NotNull Response response) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)succeed, (String)"succeed");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (succeed == String.class && response.isSuccessful()) {
                ResponseBody responseBody = response.body();
                object = responseBody != null ? responseBody.string() : null;
            } else if (succeed == ByteString.class && response.isSuccessful()) {
                ResponseBody responseBody = response.body();
                object = responseBody != null ? responseBody.byteString() : null;
            } else if (succeed instanceof GenericArrayType && ((GenericArrayType)succeed).getGenericComponentType() == Byte.TYPE && response.isSuccessful()) {
                ResponseBody responseBody = response.body();
                object = (byte[])(responseBody != null ? responseBody.bytes() : null);
            } else if (succeed == File.class && response.isSuccessful()) {
                object = ResponseExtensionKt.file(response);
            } else if (succeed == Response.class) {
                object = response;
            } else {
                throw new ConvertException(response, "An exception occurred while converting the NetConverter.DEFAULT", null, null, 12, null);
            }
            return (R)object;
        }

        static {
            $$INSTANCE = new DEFAULT();
        }
    }
}

