/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.cache;

import com.drake.net.tag.NetTag;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpUtils;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00044567B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0018\u00010\u001aR\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0018J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020\u0018J\u0006\u0010%\u001a\u00020&J\u0015\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020&J\u001d\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020 H\u0000\u00a2\u0006\u0002\b0J\f\u00101\u001a\b\u0012\u0004\u0012\u00020302J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u00068"}, d2={"Lcom/drake/net/cache/ForceCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "cache", "Lokhttp3/internal/cache/DiskLruCache;", "(Lokhttp3/internal/cache/DiskLruCache;)V", "getCache", "()Lokhttp3/internal/cache/DiskLruCache;", "directory", "Ljava/io/File;", "()Ljava/io/File;", "isClosed", "", "()Z", "writeAbortCount", "", "getWriteAbortCount$net_release", "()I", "setWriteAbortCount$net_release", "(I)V", "writeSuccessCount", "getWriteSuccessCount$net_release", "setWriteSuccessCount$net_release", "abortQuietly", "", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "close", "delete", "evictAll", "flush", "get", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "get$net_release", "initialize", "maxSize", "", "put", "response", "put$net_release", "remove", "remove$net_release", "size", "update", "cached", "network", "update$net_release", "urls", "", "", "CacheResponseBody", "Companion", "Entry", "RealCacheRequest", "net_release"})
public final class ForceCache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;

    public ForceCache(@NotNull DiskLruCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @NotNull
    public final DiskLruCache getCache() {
        return this.cache;
    }

    public final int getWriteSuccessCount$net_release() {
        return this.writeSuccessCount;
    }

    public final void setWriteSuccessCount$net_release(int n) {
        this.writeSuccessCount = n;
    }

    public final int getWriteAbortCount$net_release() {
        return this.writeAbortCount;
    }

    public final void setWriteAbortCount$net_release(int n) {
        this.writeAbortCount = n;
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    @Nullable
    public final Response get$net_release(@NotNull Request request) {
        Entry _2;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(Companion.key(request));
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException _2) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            _2 = new Entry(snapshot3.getSource(0));
        }
        catch (IOException _3) {
            Util.closeQuietly((Closeable)((Closeable)snapshot3));
            return null;
        }
        Entry entry = _2;
        Response response = entry.response(snapshot3, request.body());
        Request $this$tagOf$iv = request;
        boolean $i$f$tagOf = false;
        NetTag.CacheValidTime cacheValidTime = (NetTag.CacheValidTime)$this$tagOf$iv.tag(NetTag.CacheValidTime.class);
        Long value = cacheValidTime != null ? Long.valueOf(cacheValidTime.unbox-impl()) : null;
        return value != null && System.currentTimeMillis() - response.receivedResponseAtMillis() > value ? (Response)null : response.newBuilder().request(request).build();
    }

    @NotNull
    public final Response put$net_release(@NotNull Response response) {
        CacheRequest cacheRequest;
        CacheRequest cacheRequest2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!response.isSuccessful()) {
            return response;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default((DiskLruCache)this.cache, (String)Companion.key(response.request()), (long)0L, (int)2, null);
            if (editor2 == null) {
                return response;
            }
            editor = editor2;
            entry.writeTo(editor);
            cacheRequest2 = new RealCacheRequest(editor);
        }
        catch (IOException _) {
            this.abortQuietly(editor);
            cacheRequest2 = null;
        }
        if ((cacheRequest = cacheRequest2) == null) {
            return response;
        }
        BufferedSink cacheBody = Okio.buffer((Sink)cacheRequest.body());
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return response;
        }
        ResponseBody responseBody2 = responseBody;
        BufferedSource source = responseBody2.source();
        Source cacheWritingSource2 = new Source(source, cacheRequest, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;
            {
                this.$source = $source;
                this.$cacheRequest = $cacheRequest;
                this.$cacheBody = $cacheBody;
            }

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                long bytesRead = 0L;
                try {
                    bytesRead = this.$source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(this.$cacheBody.getBuffer(), sink.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @NotNull
            public Timeout timeout() {
                return this.$source.timeout();
            }

            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard((Source)this, (int)100, (TimeUnit)TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
        };
        String contentType = Response.header$default((Response)response, (String)"Content-Type", null, (int)2, null);
        long contentLength2 = responseBody2.contentLength();
        return response.newBuilder().body((ResponseBody)new RealResponseBody(contentType, contentLength2, Okio.buffer((Source)cacheWritingSource2))).build();
    }

    public final void remove$net_release(@NotNull Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.cache.remove(Companion.key(request));
    }

    public final void update$net_release(@NotNull Response cached, @NotNull Response network) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type com.drake.net.cache.ForceCache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = snapshot.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            entry.writeTo(editor);
            editor.commit();
        }
        catch (IOException _) {
            this.abortQuietly(editor);
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @NotNull
    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            @NotNull
            private final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            private String nextUrl;
            private boolean canRemove;
            {
                this.delegate = $receiver.getCache().snapshots();
            }

            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try {
                        Closeable $this$use$iv = (Closeable)this.delegate.next();
                        boolean $i$f$use = false;
                        Object result$iv = null;
                        Throwable thrown$iv = null;
                        try {
                            DiskLruCache.Snapshot snapshot = (DiskLruCache.Snapshot)$this$use$iv;
                            boolean bl = false;
                            BufferedSource metadata = Okio.buffer((Source)snapshot.getSource(0));
                            this.nextUrl = metadata.readUtf8LineStrict();
                            return true;
                        }
                        catch (Throwable t$iv) {
                            block11: {
                                thrown$iv = t$iv;
                                try {
                                    Closeable closeable = $this$use$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv2) {
                                    if (thrown$iv == null) {
                                        thrown$iv = t$iv2;
                                        break block11;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                                }
                            }
                            Throwable throwable = thrown$iv;
                            if (throwable != null) {
                                throw throwable;
                            }
                            Intrinsics.checkNotNull(result$iv);
                            throw new KotlinNothingValueException();
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            @NotNull
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                Intrinsics.checkNotNull((Object)string);
                String result = string;
                this.nextUrl = null;
                this.canRemove = true;
                return result;
            }

            public void remove() {
                if (!this.canRemove) {
                    boolean bl = false;
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                this.delegate.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    @JvmName(name="directory")
    @NotNull
    public final File directory() {
        return this.cache.getDirectory();
    }

    @JvmStatic
    @NotNull
    public static final String key(@NotNull Request request) {
        return Companion.key(request);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/drake/net/cache/ForceCache$RealCacheRequest;", "Lokhttp3/internal/cache/CacheRequest;", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "(Lcom/drake/net/cache/ForceCache;Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "body", "Lokio/Sink;", "cacheOut", "done", "", "getDone", "()Z", "setDone", "(Z)V", "abort", "", "net_release"})
    private final class RealCacheRequest
    implements CacheRequest {
        @NotNull
        private final DiskLruCache.Editor editor;
        @NotNull
        private final Sink cacheOut;
        @NotNull
        private final Sink body;
        private boolean done;

        public RealCacheRequest(DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.cacheOut = this.editor.newSink(1);
            Sink sink = this.cacheOut;
            this.body = (Sink)new ForwardingSink(sink){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    ForceCache forceCache = ForceCache.this;
                    RealCacheRequest realCacheRequest = this;
                    ForceCache forceCache2 = ForceCache.this;
                    ForceCache forceCache3 = forceCache;
                    synchronized (forceCache3) {
                        boolean bl = false;
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = forceCache2.getWriteSuccessCount$net_release();
                        forceCache2.setWriteSuccessCount$net_release(n + 1);
                        int n2 = n;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ForceCache forceCache = ForceCache.this;
            ForceCache forceCache2 = ForceCache.this;
            ForceCache forceCache3 = forceCache;
            synchronized (forceCache3) {
                boolean bl = false;
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = forceCache2.getWriteAbortCount$net_release();
                forceCache2.setWriteAbortCount$net_release(n + 1);
                int n2 = n;
            }
            Util.closeQuietly((Closeable)((Closeable)this.cacheOut));
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @NotNull
        public Sink body() {
            return this.body;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010 \u001a\u00060!R\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0012\u0010*\u001a\u00020&2\n\u0010+\u001a\u00060,R\u00020\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/drake/net/cache/ForceCache$Entry;", "", "rawSource", "Lokio/Source;", "(Lokio/Source;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "code", "", "handshake", "Lokhttp3/Handshake;", "isHttps", "", "()Z", "message", "", "protocol", "Lokhttp3/Protocol;", "receivedResponseMillis", "", "requestMethod", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "url", "varyHeaders", "readCertificateList", "", "Ljava/security/cert/Certificate;", "source", "Lokio/BufferedSource;", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "requestBody", "Lokhttp3/RequestBody;", "writeCertList", "", "sink", "Lokio/BufferedSink;", "certificates", "writeTo", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Companion", "net_release"})
    private static final class Entry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String url;
        @NotNull
        private final Headers varyHeaders;
        @NotNull
        private final String requestMethod;
        @NotNull
        private final Protocol protocol;
        private final int code;
        @NotNull
        private final String message;
        @NotNull
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        @NotNull
        private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
        @NotNull
        private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

        private final boolean isHttps() {
            return StringsKt.startsWith$default((String)this.url, (String)"https://", (boolean)false, (int)2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(@NotNull Source rawSource) throws IOException {
            Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
            try {
                BufferedSource source = Okio.buffer((Source)rawSource);
                this.url = source.readUtf8LineStrict();
                this.requestMethod = source.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Companion.readInt$net_release(source);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    OkHttpUtils.addLenient(varyHeadersBuilder, source.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.Companion.parse(source.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Companion.readInt$net_release(source);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    OkHttpUtils.addLenient(responseHeadersBuilder, source.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                String string = sendRequestMillisString;
                this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                String string2 = receivedResponseMillisString;
                this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source.readUtf8LineStrict();
                    if (((CharSequence)blank).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + '\"');
                    }
                    String cipherSuiteString = source.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates = this.readCertificateList(source);
                    List<Certificate> localCertificates = this.readCertificateList(source);
                    TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.Companion.forJavaName(source.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, peerCertificates, localCertificates);
                } else {
                    this.handshake = null;
                }
            }
            finally {
                rawSource.close();
            }
        }

        public Entry(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.url = response.request().url().toString();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        public final void writeTo(@NotNull DiskLruCache.Editor editor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Closeable $this$use$iv = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            boolean $i$f$use = false;
            Unit result$iv = null;
            Throwable thrown$iv = null;
            try {
                int i;
                BufferedSink sink = (BufferedSink)$this$use$iv;
                boolean bl = false;
                sink.writeUtf8(this.url).writeByte(10);
                sink.writeUtf8(this.requestMethod).writeByte(10);
                sink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
                int n = this.varyHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                }
                sink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                sink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
                n = this.responseHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                }
                sink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                sink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                if (this.isHttps()) {
                    sink.writeByte(10);
                    Handshake handshake = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake);
                    sink.writeUtf8(handshake.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink, this.handshake.peerCertificates());
                    this.writeCertList(sink, this.handshake.localCertificates());
                    sink.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                result$iv = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                if (thrown$iv == null) {
                    thrown$iv = t$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
            }
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            Intrinsics.checkNotNull(result$iv);
        }

        private final List<Certificate> readCertificateList(BufferedSource source) throws IOException {
            int length = Companion.readInt$net_release(source);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    String line = source.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    ByteString byteString = ByteString.Companion.decodeBase64(line);
                    Intrinsics.checkNotNull((Object)byteString);
                    bytes.write(byteString);
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private final void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
            try {
                sink.writeDecimalLong((long)certificates.size()).writeByte(10);
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                    String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null).base64();
                    sink.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        @NotNull
        public final Response response(@NotNull DiskLruCache.Snapshot snapshot, @Nullable RequestBody requestBody) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength2 = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, requestBody).headers(this.varyHeaders).build();
            Response.Builder builder = new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis);
            return builder.cacheResponse(builder.build()).body((ResponseBody)new CacheResponseBody(snapshot, contentType, contentLength2)).build();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/drake/net/cache/ForceCache$Entry$Companion;", "", "()V", "RECEIVED_MILLIS", "", "SENT_MILLIS", "net_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0007\u001a\u00020\rH\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/drake/net/cache/ForceCache$CacheResponseBody;", "Lokhttp3/ResponseBody;", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "contentType", "", "contentLength", "(Lokhttp3/internal/cache/DiskLruCache$Snapshot;Ljava/lang/String;Ljava/lang/String;)V", "bodySource", "Lokio/BufferedSource;", "getSnapshot", "()Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "", "Lokhttp3/MediaType;", "source", "net_release"})
    private static final class CacheResponseBody
    extends ResponseBody {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;
        @NotNull
        private final BufferedSource bodySource;

        public CacheResponseBody(@NotNull DiskLruCache.Snapshot snapshot, @Nullable String contentType, @Nullable String contentLength2) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.snapshot = snapshot;
            this.contentType = contentType;
            this.contentLength = contentLength2;
            Source source = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer((Source)((Source)new ForwardingSource(source){

                public void close() throws IOException {
                    this.getSnapshot().close();
                    super.close();
                }
            }));
        }

        @NotNull
        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Nullable
        public MediaType contentType() {
            String string = this.contentType;
            return string != null ? MediaType.Companion.parse(string) : null;
        }

        public long contentLength() {
            String string = this.contentLength;
            return string != null ? Util.toLongOrDefault((String)string, (long)-1L) : -1L;
        }

        @NotNull
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tJ\n\u0010\u0018\u001a\u00020\u0013*\u00020\u0015J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a*\u00020\u000fH\u0002J\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/drake/net/cache/ForceCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_METADATA", "key", "", "request", "Lokhttp3/Request;", "readInt", "source", "Lokio/BufferedSource;", "readInt$net_release", "varyHeaders", "Lokhttp3/Headers;", "requestHeaders", "responseHeaders", "varyMatches", "", "cachedResponse", "Lokhttp3/Response;", "cachedRequest", "newRequest", "hasVaryAll", "varyFields", "", "net_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String key(@NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Request $this$tagOf$iv = request;
            boolean $i$f$tagOf = false;
            NetTag.CacheKey cacheKey = (NetTag.CacheKey)$this$tagOf$iv.tag(NetTag.CacheKey.class);
            String string = cacheKey != null ? cacheKey.unbox-impl() : null;
            if (string == null) {
                string = request.method() + request.url();
            }
            String key = string;
            return ByteString.Companion.encodeUtf8(key).sha1().hex();
        }

        public final int readInt$net_release(@NotNull BufferedSource source) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            try {
                long result = source.readDecimalLong();
                String line = source.readUtf8LineStrict();
                if (result < 0L || result > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    throw new IOException("expected an int but was \"" + result + line + '\"');
                }
                return (int)result;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean varyMatches(@NotNull Response cachedResponse, @NotNull Headers cachedRequest, @NotNull Request newRequest) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
                Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
                Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
                Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)cachedRequest.values(it), (Object)newRequest.headers(it)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean hasVaryAll(@NotNull Response $this$hasVaryAll) {
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return this.varyFields($this$hasVaryAll.headers()).contains("*");
        }

        private final Set<String> varyFields(Headers $this$varyFields) {
            Set result = null;
            int n = $this$varyFields.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i), (boolean)true)) continue;
                String value = $this$varyFields.value(i);
                if (result == null) {
                    result = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[]{','};
                for (String varyField : StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                    result.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set = result;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Headers varyHeaders(@NotNull Response $this$varyHeaders) {
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders(requestHeaders, responseHeaders);
        }

        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return Util.EMPTY_HEADERS;
            }
            Headers.Builder result = new Headers.Builder();
            int n = requestHeaders.size();
            for (int i = 0; i < n; ++i) {
                String fieldName = requestHeaders.name(i);
                if (!varyFields.contains(fieldName)) continue;
                result.add(fieldName, requestHeaders.value(i));
            }
            return result.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

