/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.widget.PopupDrawerLayout;

public abstract class DrawerPopupView
extends BasePopupView {
    PopupDrawerLayout drawerLayout = (PopupDrawerLayout)this.findViewById(R.id.drawerLayout);
    protected FrameLayout drawerContentContainer = (FrameLayout)this.findViewById(R.id.drawerContentContainer);

    public DrawerPopupView(@NonNull Context context) {
        super(context);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.drawerContentContainer, false);
        this.drawerContentContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_drawer_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.drawerLayout.enableShadow = this.popupInfo.hasShadowBg;
        this.drawerLayout.isCanClose = this.popupInfo.isDismissOnTouchOutside;
        this.drawerLayout.setOnCloseListener(new PopupDrawerLayout.OnCloseListener(){

            @Override
            public void onClose() {
                DrawerPopupView.this.doAfterDismiss();
            }

            @Override
            public void onOpen() {
                DrawerPopupView.super.doAfterShow();
            }

            @Override
            public void onDismissing(float fraction) {
                DrawerPopupView.this.drawerLayout.isDrawStatusBarShadow = DrawerPopupView.this.popupInfo.hasStatusBarShadow;
            }
        });
        this.getPopupImplView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupImplView().setTranslationY((float)this.popupInfo.offsetY);
        this.drawerLayout.setDrawerPosition(this.popupInfo.popupPosition == null ? PopupPosition.Left : this.popupInfo.popupPosition);
        this.drawerLayout.enableDrag = this.popupInfo.enableDrag;
        this.drawerLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DrawerPopupView.this.dismiss();
            }
        });
    }

    @Override
    protected void doAfterShow() {
    }

    @Override
    public void doShowAnimation() {
        this.drawerLayout.open();
    }

    @Override
    public void doDismissAnimation() {
    }

    @Override
    public int getAnimationDuration() {
        return 0;
    }

    @Override
    public void dismiss() {
        if (this.popupStatus == PopupStatus.Dismissing) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.clearFocus();
        this.drawerLayout.close();
        super.dismiss();
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return null;
    }

    @Override
    protected View getTargetSizeView() {
        return this.getPopupImplView();
    }
}

