/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;

public class FullScreenPopupView
extends CenterPopupView {
    public ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    Paint paint = new Paint();
    Rect shadowRect;
    int currColor = 0;

    public FullScreenPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected int getMaxWidth() {
        return 0;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.popupInfo.hasShadowBg = false;
    }

    @Override
    public void onNavigationBarChange(boolean show) {
        if (!show) {
            this.applyFull();
            this.getPopupContentView().setPadding(0, 0, 0, 0);
        } else {
            this.applySize(true);
        }
    }

    @Override
    protected void applySize(boolean isShowNavBar) {
        int actualNabBarHeight;
        int rotation = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
        View contentView = this.getPopupContentView();
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)contentView.getLayoutParams();
        params.gravity = 48;
        contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        int n = actualNabBarHeight = isShowNavBar || XPopupUtils.isNavBarVisible(this.dialog.getWindow()) ? XPopupUtils.getNavBarHeight() : 0;
        if (rotation == 0) {
            contentView.setPadding(contentView.getPaddingLeft(), contentView.getPaddingTop(), contentView.getPaddingRight(), 0);
        } else if (rotation == 1 || rotation == 3) {
            contentView.setPadding(contentView.getPaddingLeft(), contentView.getPaddingTop(), contentView.getPaddingRight(), 0);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.popupInfo.hasStatusBarShadow.booleanValue()) {
            this.paint.setColor(this.currColor);
            this.shadowRect = new Rect(0, 0, XPopupUtils.getWindowWidth(this.getContext()), XPopupUtils.getStatusBarHeight());
            canvas.drawRect(this.shadowRect, this.paint);
        }
    }

    @Override
    protected void doShowAnimation() {
        super.doShowAnimation();
        this.doStatusBarColorTransform(true);
    }

    @Override
    protected void doDismissAnimation() {
        super.doDismissAnimation();
        this.doStatusBarColorTransform(false);
    }

    public void doStatusBarColorTransform(boolean isShow) {
        if (this.popupInfo.hasStatusBarShadow.booleanValue()) {
            ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{isShow ? 0 : XPopup.statusBarShadowColor, isShow ? XPopup.statusBarShadowColor : 0});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    FullScreenPopupView.this.currColor = (Integer)animation.getAnimatedValue();
                    FullScreenPopupView.this.postInvalidate();
                }
            });
            animator.setDuration((long)XPopup.getAnimationDuration()).start();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.paint = null;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupContentView(), PopupAnimation.TranslateFromBottom);
    }
}

