/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public class PositionPopupView
extends BasePopupView {
    PartShadowContainer attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);

    public PositionPopupView(@NonNull Context context) {
        super(context);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), new Runnable(){

            @Override
            public void run() {
                if (PositionPopupView.this.popupInfo.isCenterHorizontal) {
                    float left = (float)(XPopupUtils.getWindowWidth(PositionPopupView.this.getContext()) - PositionPopupView.this.attachPopupContainer.getMeasuredWidth()) / 2.0f;
                    PositionPopupView.this.attachPopupContainer.setTranslationX(left);
                } else {
                    PositionPopupView.this.attachPopupContainer.setTranslationX(PositionPopupView.this.popupInfo.offsetX);
                }
                PositionPopupView.this.attachPopupContainer.setTranslationY(PositionPopupView.this.popupInfo.offsetY);
            }
        });
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new ScaleAlphaAnimator(this.getPopupContentView(), PopupAnimation.ScaleAlphaFromCenter);
    }
}

