/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import androidx.viewpager.widget.ViewPager;
import com.lxj.xpopup.interfaces.OnDragChangeListener;
import com.lxj.xpopup.photoview.PhotoView;

public class PhotoViewContainer
extends FrameLayout {
    private static final String TAG = "PhotoViewContainer";
    private ViewDragHelper dragHelper;
    public ViewPager viewPager;
    private int HideTopThreshold = 80;
    private int maxOffset;
    private OnDragChangeListener dragChangeListener;
    public boolean isReleasing = false;
    boolean isVertical = false;
    private float touchX;
    private float touchY;
    ViewDragHelper.Callback cb = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View view, int i) {
            return !PhotoViewContainer.this.isReleasing;
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            return 1;
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            int t = PhotoViewContainer.this.viewPager.getTop() + dy / 2;
            if (t >= 0) {
                return Math.min(t, PhotoViewContainer.this.maxOffset);
            }
            return -Math.min(-t, PhotoViewContainer.this.maxOffset);
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if (changedView != PhotoViewContainer.this.viewPager) {
                PhotoViewContainer.this.viewPager.offsetTopAndBottom(dy);
            }
            float fraction = (float)Math.abs(top) * 1.0f / (float)PhotoViewContainer.this.maxOffset;
            float pageScale = 1.0f - fraction * 0.2f;
            PhotoViewContainer.this.viewPager.setScaleX(pageScale);
            PhotoViewContainer.this.viewPager.setScaleY(pageScale);
            changedView.setScaleX(pageScale);
            changedView.setScaleY(pageScale);
            if (PhotoViewContainer.this.dragChangeListener != null) {
                PhotoViewContainer.this.dragChangeListener.onDragChange(dy, pageScale, fraction);
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            if (Math.abs(releasedChild.getTop()) > PhotoViewContainer.this.HideTopThreshold) {
                if (PhotoViewContainer.this.dragChangeListener != null) {
                    PhotoViewContainer.this.dragChangeListener.onRelease();
                }
            } else {
                PhotoViewContainer.this.dragHelper.smoothSlideViewTo((View)PhotoViewContainer.this.viewPager, 0, 0);
                PhotoViewContainer.this.dragHelper.smoothSlideViewTo(releasedChild, 0, 0);
                ViewCompat.postInvalidateOnAnimation((View)PhotoViewContainer.this);
            }
        }
    };

    public PhotoViewContainer(@NonNull Context context) {
        this(context, null);
    }

    public PhotoViewContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhotoViewContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.HideTopThreshold = this.dip2px(this.HideTopThreshold);
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.cb);
        this.setBackgroundColor(0);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.viewPager = (ViewPager)this.getChildAt(0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.maxOffset = this.getHeight() / 3;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1) {
            return super.dispatchTouchEvent(ev);
        }
        try {
            switch (ev.getAction()) {
                case 0: {
                    this.touchX = ev.getX();
                    this.touchY = ev.getY();
                    break;
                }
                case 2: {
                    float dx = ev.getX() - this.touchX;
                    float dy = ev.getY() - this.touchY;
                    this.viewPager.dispatchTouchEvent(ev);
                    this.isVertical = Math.abs(dy) > Math.abs(dx);
                    this.touchX = ev.getX();
                    this.touchY = ev.getY();
                    break;
                }
                case 1: 
                case 3: {
                    this.touchX = 0.0f;
                    this.touchY = 0.0f;
                    this.isVertical = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean isTopOrBottomEnd() {
        View view = this.getCurrentImageView();
        if (view instanceof PhotoView) {
            return ((PhotoView)view).attacher.isTopEnd || ((PhotoView)view).attacher.isBottomEnd;
        }
        return false;
    }

    private View getCurrentImageView() {
        FrameLayout fl = (FrameLayout)this.viewPager.getChildAt(this.viewPager.getCurrentItem());
        if (fl == null) {
            return null;
        }
        return fl.getChildAt(0);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean result = this.dragHelper.shouldInterceptTouchEvent(ev);
        if (ev.getPointerCount() > 1 && ev.getAction() == 2) {
            return false;
        }
        if (this.isTopOrBottomEnd() && this.isVertical) {
            return true;
        }
        return result && this.isVertical;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1) {
            return false;
        }
        try {
            this.dragHelper.processTouchEvent(ev);
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper.continueSettling(false)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public int dip2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setOnDragChangeListener(OnDragChangeListener listener) {
        this.dragChangeListener = listener;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isReleasing = false;
    }
}

