/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;

public class HorizontalAttachPopupView
extends AttachPopupView {
    float translationX = 0.0f;
    float translationY = 0.0f;

    public HorizontalAttachPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.defaultOffsetY = this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX == 0 ? XPopupUtils.dp2px(this.getContext(), 2.0f) : this.popupInfo.offsetX;
    }

    @Override
    public void doAttach() {
        if (this.popupInfo == null) {
            return;
        }
        final boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        final int w = this.getPopupContentView().getMeasuredWidth();
        final int h = this.getPopupContentView().getMeasuredHeight();
        if (this.popupInfo.touchPoint != null) {
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            this.popupInfo.touchPoint.x -= (float)this.getActivityContentLeft();
            this.isShowLeft = this.popupInfo.touchPoint.x > (float)XPopupUtils.getAppWidth(this.getContext()) / 2.0f;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxWidth = 0;
            maxWidth = isRTL ? (int)(this.isShowLeft ? this.popupInfo.touchPoint.x - (float)this.overflow : (float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow) : (int)(this.isShowLeft ? (float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow : (float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow);
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    HorizontalAttachPopupView.this.translationX = isRTL ? (HorizontalAttachPopupView.this.isShowLeft ? -((float)XPopupUtils.getAppWidth(HorizontalAttachPopupView.this.getContext()) - HorizontalAttachPopupView.this.popupInfo.touchPoint.x + (float)HorizontalAttachPopupView.this.defaultOffsetX) : -((float)XPopupUtils.getAppWidth(HorizontalAttachPopupView.this.getContext()) - HorizontalAttachPopupView.this.popupInfo.touchPoint.x - (float)HorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)HorizontalAttachPopupView.this.defaultOffsetX)) : (HorizontalAttachPopupView.this.isShowLeftToTarget() ? HorizontalAttachPopupView.this.popupInfo.touchPoint.x - (float)w - (float)HorizontalAttachPopupView.this.defaultOffsetX : HorizontalAttachPopupView.this.popupInfo.touchPoint.x + (float)HorizontalAttachPopupView.this.defaultOffsetX);
                    HorizontalAttachPopupView.this.translationY = HorizontalAttachPopupView.this.popupInfo.touchPoint.y - (float)h * 0.5f + (float)HorizontalAttachPopupView.this.defaultOffsetY;
                    HorizontalAttachPopupView.this.getPopupContentView().setTranslationX(HorizontalAttachPopupView.this.translationX);
                    HorizontalAttachPopupView.this.getPopupContentView().setTranslationY(HorizontalAttachPopupView.this.translationY);
                    HorizontalAttachPopupView.this.initAndStartAnimation();
                }
            });
        } else {
            final Rect rect = this.popupInfo.getAtViewRect();
            rect.left -= this.getActivityContentLeft();
            rect.right -= this.getActivityContentLeft();
            int centerX = (rect.left + rect.right) / 2;
            this.isShowLeft = centerX > XPopupUtils.getAppWidth(this.getContext()) / 2;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxWidth = 0;
            if (isRTL) {
                maxWidth = this.isShowLeft ? rect.left - this.overflow : XPopupUtils.getAppWidth(this.getContext()) - rect.right - this.overflow;
            } else {
                int n = maxWidth = this.isShowLeft ? XPopupUtils.getAppWidth(this.getContext()) - rect.left - this.overflow : XPopupUtils.getAppWidth(this.getContext()) - rect.right - this.overflow;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    HorizontalAttachPopupView.this.translationX = isRTL ? (HorizontalAttachPopupView.this.isShowLeft ? (float)(-(XPopupUtils.getAppWidth(HorizontalAttachPopupView.this.getContext()) - rect.left + HorizontalAttachPopupView.this.defaultOffsetX)) : (float)(-(XPopupUtils.getAppWidth(HorizontalAttachPopupView.this.getContext()) - rect.right - HorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - HorizontalAttachPopupView.this.defaultOffsetX))) : (HorizontalAttachPopupView.this.isShowLeftToTarget() ? (float)(rect.left - w - HorizontalAttachPopupView.this.defaultOffsetX) : (float)(rect.right + HorizontalAttachPopupView.this.defaultOffsetX));
                    HorizontalAttachPopupView.this.translationY = (float)rect.top + (float)(rect.height() - h) / 2.0f + (float)HorizontalAttachPopupView.this.defaultOffsetY;
                    HorizontalAttachPopupView.this.getPopupContentView().setTranslationX(HorizontalAttachPopupView.this.translationX);
                    HorizontalAttachPopupView.this.getPopupContentView().setTranslationY(HorizontalAttachPopupView.this.translationY);
                    HorizontalAttachPopupView.this.initAndStartAnimation();
                }
            });
        }
    }

    private boolean isShowLeftToTarget() {
        return (this.isShowLeft || this.popupInfo.popupPosition == PopupPosition.Left) && this.popupInfo.popupPosition != PopupPosition.Right;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowLeftToTarget() ? new ScrollScaleAnimator(this.getPopupContentView(), this.getAnimationDuration(), PopupAnimation.ScrollAlphaFromRight) : new ScrollScaleAnimator(this.getPopupContentView(), this.getAnimationDuration(), PopupAnimation.ScrollAlphaFromLeft);
        return animator;
    }
}

