/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;

public class CenterPopupView
extends BasePopupView {
    protected FrameLayout centerPopupContainer = (FrameLayout)this.findViewById(R.id.centerPopupContainer);
    protected int bindLayoutId;
    protected int bindItemLayoutId;
    protected View contentView;

    public CenterPopupView(@NonNull Context context) {
        super(context);
    }

    protected void addInnerContent() {
        this.contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.centerPopupContainer, false);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.contentView.getLayoutParams();
        params.gravity = 17;
        this.centerPopupContainer.addView(this.contentView, (ViewGroup.LayoutParams)params);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_center_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.centerPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        this.getPopupContentView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupContentView().setTranslationY((float)this.popupInfo.offsetY);
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), null);
    }

    @Override
    protected void doMeasure() {
        super.doMeasure();
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), null);
    }

    protected void applyTheme() {
        if (this.bindLayoutId == 0) {
            if (this.popupInfo.isDarkTheme) {
                this.applyDarkTheme();
            } else {
                this.applyLightTheme();
            }
        }
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        this.centerPopupContainer.setBackground(XPopupUtils.createDrawable(this.getResources().getColor(R.color._xpopup_dark_color), this.popupInfo.borderRadius));
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        this.centerPopupContainer.setBackground(XPopupUtils.createDrawable(this.getResources().getColor(R.color._xpopup_light_color), this.popupInfo.borderRadius));
    }

    @Override
    protected int getImplLayoutId() {
        return 0;
    }

    @Override
    protected int getMaxWidth() {
        if (this.popupInfo == null) {
            return 0;
        }
        return this.popupInfo.maxWidth == 0 ? (int)((float)XPopupUtils.getAppWidth(this.getContext()) * 0.72f) : this.popupInfo.maxWidth;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new ScaleAlphaAnimator(this.getPopupContentView(), this.getAnimationDuration(), PopupAnimation.ScaleAlphaFromCenter);
    }
}

