/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.lxj.easyadapter.EasyAdapter;
import com.lxj.easyadapter.MultiItemTypeAdapter;
import com.lxj.easyadapter.ViewHolder;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.BottomPopupView;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.CheckView;
import com.lxj.xpopup.widget.VerticalRecyclerView;
import java.util.Arrays;

public class BottomListPopupView
extends BottomPopupView {
    RecyclerView recyclerView;
    TextView tv_title;
    TextView tv_cancel;
    View vv_divider;
    protected int bindLayoutId;
    protected int bindItemLayoutId;
    CharSequence title;
    String[] data;
    int[] iconIds;
    private OnSelectListener selectListener;
    int checkedPosition = -1;

    public BottomListPopupView(@NonNull Context context, int bindLayoutId, int bindItemLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.bindItemLayoutId = bindItemLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId == 0 ? R.layout._xpopup_bottom_impl_list : this.bindLayoutId;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        if (this.bindLayoutId != 0) {
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.tv_cancel = (TextView)this.findViewById(R.id.tv_cancel);
        this.vv_divider = this.findViewById(R.id.vv_divider);
        if (this.tv_cancel != null) {
            this.tv_cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BottomListPopupView.this.dismiss();
                }
            });
        }
        if (this.tv_title != null) {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.tv_title.setVisibility(8);
                if (this.findViewById(R.id.xpopup_divider) != null) {
                    this.findViewById(R.id.xpopup_divider).setVisibility(8);
                }
            } else {
                this.tv_title.setText(this.title);
            }
        }
        EasyAdapter<String> adapter = new EasyAdapter<String>(Arrays.asList(this.data), this.bindItemLayoutId == 0 ? R.layout._xpopup_adapter_text_match : this.bindItemLayoutId){

            protected void bind(@NonNull ViewHolder holder, @NonNull String s, int position) {
                holder.setText(R.id.tv_text, (CharSequence)s);
                ImageView imageView = (ImageView)holder.getViewOrNull(R.id.iv_image);
                if (BottomListPopupView.this.iconIds != null && BottomListPopupView.this.iconIds.length > position) {
                    if (imageView != null) {
                        imageView.setVisibility(0);
                        imageView.setBackgroundResource(BottomListPopupView.this.iconIds[position]);
                    }
                } else if (imageView != null) {
                    imageView.setVisibility(8);
                }
                if (BottomListPopupView.this.checkedPosition != -1) {
                    if (holder.getViewOrNull(R.id.check_view) != null) {
                        holder.getView(R.id.check_view).setVisibility(position == BottomListPopupView.this.checkedPosition ? 0 : 8);
                        ((CheckView)holder.getView(R.id.check_view)).setColor(XPopup.getPrimaryColor());
                    }
                    ((TextView)holder.getView(R.id.tv_text)).setTextColor(position == BottomListPopupView.this.checkedPosition ? XPopup.getPrimaryColor() : BottomListPopupView.this.getResources().getColor(R.color._xpopup_title_color));
                } else {
                    if (holder.getViewOrNull(R.id.check_view) != null) {
                        holder.getView(R.id.check_view).setVisibility(8);
                    }
                    ((TextView)holder.getView(R.id.tv_text)).setGravity(17);
                }
                if (BottomListPopupView.this.bindItemLayoutId == 0) {
                    if (BottomListPopupView.this.popupInfo.isDarkTheme) {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(BottomListPopupView.this.getResources().getColor(R.color._xpopup_white_color));
                    } else {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(BottomListPopupView.this.getResources().getColor(R.color._xpopup_dark_color));
                    }
                }
            }
        };
        adapter.setOnItemClickListener((MultiItemTypeAdapter.OnItemClickListener)new MultiItemTypeAdapter.SimpleOnItemClickListener((EasyAdapter)adapter){
            final /* synthetic */ EasyAdapter val$adapter;
            {
                this.val$adapter = easyAdapter;
            }

            public void onItemClick(View view, RecyclerView.ViewHolder holder, int position) {
                if (BottomListPopupView.this.selectListener != null) {
                    BottomListPopupView.this.selectListener.onSelect(position, (String)this.val$adapter.getData().get(position));
                }
                if (BottomListPopupView.this.checkedPosition != -1) {
                    BottomListPopupView.this.checkedPosition = position;
                    this.val$adapter.notifyDataSetChanged();
                }
                if (BottomListPopupView.this.popupInfo.autoDismiss.booleanValue()) {
                    BottomListPopupView.this.dismiss();
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.applyTheme();
    }

    public BottomListPopupView setStringData(CharSequence title, String[] data, int[] iconIds) {
        this.title = title;
        this.data = data;
        this.iconIds = iconIds;
        return this;
    }

    public BottomListPopupView setOnSelectListener(OnSelectListener selectListener) {
        this.selectListener = selectListener;
        return this;
    }

    public BottomListPopupView setCheckedPosition(int position) {
        this.checkedPosition = position;
        return this;
    }

    protected void applyTheme() {
        if (this.bindLayoutId == 0) {
            if (this.popupInfo.isDarkTheme) {
                this.applyDarkTheme();
            } else {
                this.applyLightTheme();
            }
        }
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(true);
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        if (this.tv_cancel != null) {
            this.tv_cancel.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        }
        this.findViewById(R.id.xpopup_divider).setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_dark_divider));
        if (this.vv_divider != null) {
            this.vv_divider.setBackgroundColor(Color.parseColor((String)"#1B1B1B"));
        }
        this.getPopupImplView().setBackground(XPopupUtils.createDrawable(this.getResources().getColor(R.color._xpopup_dark_color), this.popupInfo.borderRadius, this.popupInfo.borderRadius, 0.0f, 0.0f));
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(false);
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_dark_color));
        if (this.tv_cancel != null) {
            this.tv_cancel.setTextColor(this.getResources().getColor(R.color._xpopup_dark_color));
        }
        this.findViewById(R.id.xpopup_divider).setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_divider));
        if (this.vv_divider != null) {
            this.vv_divider.setBackgroundColor(this.getResources().getColor(R.color._xpopup_white_color));
        }
        this.getPopupImplView().setBackground(XPopupUtils.createDrawable(this.getResources().getColor(R.color._xpopup_light_color), this.popupInfo.borderRadius, this.popupInfo.borderRadius, 0.0f, 0.0f));
    }
}

