/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.util.XPopupUtils;

public final class KeyboardUtils {
    public static int sDecorViewInvisibleHeightPre;
    private static final SparseArray<ViewTreeObserver.OnGlobalLayoutListener> listenerArray;
    private static int sDecorViewDelta;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static int getDecorViewInvisibleHeight(Window window) {
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        Log.d((String)"KeyboardUtils", (String)("getDecorViewInvisibleHeight: " + (decorView.getBottom() - outRect.bottom)));
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= XPopupUtils.getNavBarHeight() + XPopupUtils.getStatusBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void registerSoftInputChangedListener(final Window window, BasePopupView popupView, final OnSoftInputChangedListener listener) {
        if (popupView == null) {
            return;
        }
        int flags = window.getAttributes().flags;
        if ((flags & 0x200) != 0) {
            window.clearFlags(512);
        }
        FrameLayout contentView = (FrameLayout)window.findViewById(0x1020002);
        final int[] decorViewInvisibleHeightPre = new int[]{KeyboardUtils.getDecorViewInvisibleHeight(window)};
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = KeyboardUtils.getDecorViewInvisibleHeight(window);
                if (decorViewInvisibleHeightPre[0] != height) {
                    listener.onSoftInputChanged(height);
                    decorViewInvisibleHeightPre[0] = height;
                }
            }
        };
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        listenerArray.append(popupView.getId(), (Object)onGlobalLayoutListener);
    }

    public static void removeLayoutChangeListener(Window window, BasePopupView popupView) {
        if (popupView == null) {
            return;
        }
        View contentView = window.findViewById(0x1020002);
        if (contentView == null) {
            return;
        }
        ViewTreeObserver.OnGlobalLayoutListener tag = (ViewTreeObserver.OnGlobalLayoutListener)listenerArray.get(popupView.getId());
        if (tag != null) {
            contentView.getViewTreeObserver().removeOnGlobalLayoutListener(tag);
            tag = null;
            listenerArray.remove(popupView.getId());
        }
    }

    public static void showSoftInput(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, 0, (ResultReceiver)new SoftInputReceiver(view.getContext()));
        imm.toggleSoftInput(2, 1);
    }

    public static void toggleSoftInput(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(0, 0);
    }

    public static void hideSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(@NonNull Window window) {
        View view = window.getCurrentFocus();
        if (view == null) {
            View decorView = window.getDecorView();
            View focusView = decorView.findViewWithTag((Object)"keyboardTagView");
            if (focusView == null) {
                view = new EditText(window.getContext());
                view.setTag((Object)"keyboardTagView");
                ((ViewGroup)decorView).addView(view, 0, 0);
            } else {
                view = focusView;
            }
            view.requestFocus();
        }
        KeyboardUtils.hideSoftInput(view);
    }

    static {
        listenerArray = new SparseArray();
        sDecorViewDelta = 0;
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }

    private static class SoftInputReceiver
    extends ResultReceiver {
        private Context context;

        public SoftInputReceiver(Context context) {
            super(new Handler());
            this.context = context;
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            super.onReceiveResult(resultCode, resultData);
            if (resultCode == 1 || resultCode == 3) {
                KeyboardUtils.toggleSoftInput(this.context);
            }
            this.context = null;
        }
    }
}

