/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnConfirmListener;
import com.lxj.xpopup.util.XPopupUtils;

public class ConfirmPopupView
extends CenterPopupView
implements View.OnClickListener {
    OnCancelListener cancelListener;
    OnConfirmListener confirmListener;
    TextView tv_title;
    TextView tv_content;
    TextView tv_cancel;
    TextView tv_confirm;
    CharSequence title;
    CharSequence content;
    CharSequence hint;
    CharSequence cancelText;
    CharSequence confirmText;
    EditText et_input;
    View divider1;
    View divider2;
    public boolean isHideCancel = false;

    public ConfirmPopupView(@NonNull Context context, int bindLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId != 0 ? this.bindLayoutId : R.layout._xpopup_center_impl_confirm;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.tv_cancel = (TextView)this.findViewById(R.id.tv_cancel);
        this.tv_confirm = (TextView)this.findViewById(R.id.tv_confirm);
        this.tv_content.setMovementMethod(LinkMovementMethod.getInstance());
        this.et_input = (EditText)this.findViewById(R.id.et_input);
        this.divider1 = this.findViewById(R.id.xpopup_divider1);
        this.divider2 = this.findViewById(R.id.xpopup_divider2);
        this.tv_cancel.setOnClickListener((View.OnClickListener)this);
        this.tv_confirm.setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            this.tv_title.setText(this.title);
        } else {
            XPopupUtils.setVisible((View)this.tv_title, false);
        }
        if (!TextUtils.isEmpty((CharSequence)this.content)) {
            this.tv_content.setText(this.content);
        } else {
            XPopupUtils.setVisible((View)this.tv_content, false);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            this.tv_cancel.setText(this.cancelText);
        }
        if (!TextUtils.isEmpty((CharSequence)this.confirmText)) {
            this.tv_confirm.setText(this.confirmText);
        }
        if (this.isHideCancel) {
            XPopupUtils.setVisible((View)this.tv_cancel, false);
            XPopupUtils.setVisible(this.divider2, false);
        }
        this.applyTheme();
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_content_color));
        this.tv_content.setTextColor(this.getResources().getColor(R.color._xpopup_content_color));
        this.tv_cancel.setTextColor(Color.parseColor((String)"#666666"));
        this.tv_confirm.setTextColor(XPopup.getPrimaryColor());
        if (this.divider1 != null) {
            this.divider1.setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_divider));
        }
        if (this.divider2 != null) {
            this.divider2.setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_divider));
        }
    }

    public TextView getTitleTextView() {
        return (TextView)this.findViewById(R.id.tv_title);
    }

    public TextView getContentTextView() {
        return (TextView)this.findViewById(R.id.tv_content);
    }

    public TextView getCancelTextView() {
        return (TextView)this.findViewById(R.id.tv_cancel);
    }

    public TextView getConfirmTextView() {
        return (TextView)this.findViewById(R.id.tv_confirm);
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_content.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_cancel.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_confirm.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        if (this.divider1 != null) {
            this.divider1.setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_dark_divider));
        }
        if (this.divider2 != null) {
            this.divider2.setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_dark_divider));
        }
    }

    public ConfirmPopupView setListener(OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
        this.confirmListener = confirmListener;
        return this;
    }

    public ConfirmPopupView setTitleContent(CharSequence title, CharSequence content, CharSequence hint) {
        this.title = title;
        this.content = content;
        this.hint = hint;
        return this;
    }

    public ConfirmPopupView setCancelText(CharSequence cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ConfirmPopupView setConfirmText(CharSequence confirmText) {
        this.confirmText = confirmText;
        return this;
    }

    public void onClick(View v) {
        if (v == this.tv_cancel) {
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
            this.dismiss();
        } else if (v == this.tv_confirm) {
            if (this.confirmListener != null) {
                this.confirmListener.onConfirm();
            }
            if (this.popupInfo.autoDismiss.booleanValue()) {
                this.dismiss();
            }
        }
    }

    @Override
    protected int getMaxWidth() {
        return this.popupInfo.maxWidth == 0 ? super.getMaxWidth() : this.popupInfo.maxWidth;
    }

    @Override
    protected int getMaxHeight() {
        return this.popupInfo.maxWidth == 0 ? (int)((double)XPopupUtils.getAppHeight(this.getContext()) * 0.8) : this.popupInfo.maxWidth;
    }
}

