/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.lxj.xpopup.core.ImageViewerPopupView;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.photoview.OnMatrixChangedListener;
import com.lxj.xpopup.photoview.PhotoView;
import com.lxj.xpopup.util.ImageDownloadTarget;
import com.lxj.xpopup.util.SSIVListener;
import com.lxj.xpopup.util.XPopupUtils;
import java.io.File;

public class SmartGlideImageLoader
implements XPopupImageLoader {
    private int errImg;
    private boolean mBigImage;

    public SmartGlideImageLoader() {
    }

    public SmartGlideImageLoader(int errImgRes) {
        this.errImg = errImgRes;
    }

    public SmartGlideImageLoader(boolean bigImage, int errImgRes) {
        this(errImgRes);
        this.mBigImage = bigImage;
    }

    @Override
    public View loadImage(int position, @NonNull Object url, @NonNull ImageViewerPopupView popupView, @Nullable PhotoView snapshot, final @NonNull ProgressBar progressBar) {
        progressBar.setVisibility(0);
        Object imageView = this.mBigImage ? this.buildBigImageView(popupView, progressBar, position) : this.buildPhotoView(popupView, snapshot, position);
        Context context = imageView.getContext();
        if (snapshot != null && snapshot.getDrawable() != null && (Integer)snapshot.getTag() == position) {
            if (imageView instanceof PhotoView) {
                try {
                    ((PhotoView)((Object)imageView)).setImageDrawable(snapshot.getDrawable().getConstantState().newDrawable());
                }
                catch (Exception exception) {}
            } else {
                imageView.setImage(ImageSource.bitmap((Bitmap)XPopupUtils.view2Bitmap((View)snapshot)));
            }
        }
        Glide.with((View)imageView).downloadOnly().load(url).into((Target)new ImageDownloadTarget((View)imageView, context){
            final /* synthetic */ View val$imageView;
            final /* synthetic */ Context val$context;
            {
                this.val$imageView = view;
                this.val$context = context;
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                progressBar.setVisibility(8);
                if (this.val$imageView instanceof PhotoView) {
                    ((PhotoView)this.val$imageView).setImageResource(SmartGlideImageLoader.this.errImg);
                    ((PhotoView)this.val$imageView).setZoomable(false);
                } else {
                    ((SubsamplingScaleImageView)this.val$imageView).setImage(ImageSource.resource((int)SmartGlideImageLoader.this.errImg));
                }
            }

            @Override
            public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
                int maxW = XPopupUtils.getAppWidth(this.val$context) * 2;
                int maxH = XPopupUtils.getScreenHeight(this.val$context) * 2;
                int[] size = XPopupUtils.getImageSize(resource);
                int degree = XPopupUtils.getRotateDegree(resource.getAbsolutePath());
                if (this.val$imageView instanceof PhotoView) {
                    progressBar.setVisibility(8);
                    ((PhotoView)this.val$imageView).setZoomable(true);
                    Log.e((String)"tag", (String)("degree: " + degree));
                    if (size[0] > maxW || size[1] > maxH) {
                        Bitmap rawBmp = XPopupUtils.getBitmap(resource, maxW, maxH);
                        ((PhotoView)this.val$imageView).setImageBitmap(XPopupUtils.rotate(rawBmp, degree, (float)size[0] / 2.0f, (float)size[1] / 2.0f));
                    } else {
                        Glide.with((View)this.val$imageView).load(resource).apply(((RequestOptions)new RequestOptions().error(SmartGlideImageLoader.this.errImg)).override(size[0], size[1])).into((ImageView)((PhotoView)this.val$imageView));
                    }
                } else {
                    SubsamplingScaleImageView bigImageView = (SubsamplingScaleImageView)this.val$imageView;
                    boolean longImage = false;
                    if ((float)size[1] * 1.0f / (float)size[0] > (float)XPopupUtils.getScreenHeight(this.val$context) * 1.0f / (float)XPopupUtils.getAppWidth(this.val$context)) {
                        longImage = true;
                        bigImageView.setMinimumScaleType(4);
                    } else {
                        longImage = false;
                        bigImageView.setMinimumScaleType(1);
                    }
                    bigImageView.setOrientation(degree);
                    bigImageView.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)new SSIVListener(bigImageView, progressBar, SmartGlideImageLoader.this.errImg, longImage));
                    Bitmap preview = XPopupUtils.getBitmap(resource, XPopupUtils.getAppWidth(this.val$context), XPopupUtils.getScreenHeight(this.val$context));
                    bigImageView.setImage(ImageSource.uri((Uri)Uri.fromFile((File)resource)).dimensions(size[0], size[1]), preview != null ? ImageSource.cachedBitmap((Bitmap)preview) : null);
                }
            }
        });
        return imageView;
    }

    private SubsamplingScaleImageView buildBigImageView(final ImageViewerPopupView popupView, ProgressBar progressBar, final int realPosition) {
        SubsamplingScaleImageView ssiv = new SubsamplingScaleImageView(popupView.getContext());
        ssiv.setOnStateChangedListener((SubsamplingScaleImageView.OnStateChangedListener)new SubsamplingScaleImageView.DefaultOnStateChangedListener(){

            public void onCenterChanged(PointF newCenter, int origin) {
                super.onCenterChanged(newCenter, origin);
            }
        });
        ssiv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                popupView.dismiss();
            }
        });
        if (popupView.longPressListener != null) {
            ssiv.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    popupView.longPressListener.onLongPressed(popupView, realPosition);
                    return false;
                }
            });
        }
        return ssiv;
    }

    private PhotoView buildPhotoView(final ImageViewerPopupView popupView, final PhotoView snapshotView, final int realPosition) {
        final PhotoView photoView = new PhotoView(popupView.getContext());
        photoView.setZoomable(false);
        photoView.setOnMatrixChangeListener(new OnMatrixChangedListener(){

            @Override
            public void onMatrixChanged(RectF rect) {
                if (snapshotView != null) {
                    Matrix matrix = new Matrix();
                    photoView.getSuppMatrix(matrix);
                    snapshotView.setSuppMatrix(matrix);
                }
            }
        });
        photoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                popupView.dismiss();
            }
        });
        if (popupView.longPressListener != null) {
            photoView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    popupView.longPressListener.onLongPressed(popupView, realPosition);
                    return false;
                }
            });
        }
        return photoView;
    }

    @Override
    public void loadSnapshot(@NonNull Object uri, final @NonNull PhotoView snapshot, @Nullable ImageView srcView) {
        if (this.mBigImage) {
            if (srcView != null && srcView.getDrawable() != null) {
                try {
                    snapshot.setImageDrawable(srcView.getDrawable().getConstantState().newDrawable());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Glide.with((View)snapshot).downloadOnly().load(uri).into((Target)new ImageDownloadTarget(){

                @Override
                public void onLoadFailed(Drawable errorDrawable) {
                    super.onLoadFailed(errorDrawable);
                }

                @Override
                public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
                    super.onResourceReady(resource, transition);
                    int degree = XPopupUtils.getRotateDegree(resource.getAbsolutePath());
                    int maxW = XPopupUtils.getAppWidth(snapshot.getContext());
                    int maxH = XPopupUtils.getScreenHeight(snapshot.getContext());
                    int[] size = XPopupUtils.getImageSize(resource);
                    if (size[0] > maxW || size[1] > maxH) {
                        Bitmap rawBmp = XPopupUtils.getBitmap(resource, maxW, maxH);
                        snapshot.setImageBitmap(XPopupUtils.rotate(rawBmp, degree, (float)size[0] / 2.0f, (float)size[1] / 2.0f));
                    } else {
                        Glide.with((View)snapshot).load(resource).apply(new RequestOptions().override(size[0], size[1])).into((ImageView)snapshot);
                    }
                }
            });
        } else {
            ((RequestBuilder)Glide.with((View)snapshot).load(uri).override(Integer.MIN_VALUE)).into((ImageView)snapshot);
        }
    }

    @Override
    public File getImageFile(@NonNull Context context, @NonNull Object uri) {
        try {
            return (File)Glide.with((Context)context).downloadOnly().load(uri).submit().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

