/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.transition.ChangeBounds;
import androidx.transition.ChangeImageTransform;
import androidx.transition.ChangeTransform;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.interfaces.OnDragChangeListener;
import com.lxj.xpopup.interfaces.OnImageViewerLongPressListener;
import com.lxj.xpopup.interfaces.OnSrcViewUpdateListener;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.photoview.PhotoView;
import com.lxj.xpopup.util.XPermission;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.BlankView;
import com.lxj.xpopup.widget.HackyViewPager;
import com.lxj.xpopup.widget.PhotoViewContainer;
import java.util.ArrayList;
import java.util.List;

public class ImageViewerPopupView
extends BasePopupView
implements OnDragChangeListener,
View.OnClickListener {
    protected FrameLayout container;
    protected PhotoViewContainer photoViewContainer;
    protected BlankView placeholderView;
    protected TextView tv_pager_indicator;
    protected TextView tv_save;
    protected HackyViewPager pager;
    protected ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    protected List<Object> urls = new ArrayList<Object>();
    protected XPopupImageLoader imageLoader;
    protected OnSrcViewUpdateListener srcViewUpdateListener;
    protected int position;
    protected Rect rect = null;
    protected ImageView srcView;
    protected PhotoView snapshotView;
    protected boolean isShowPlaceholder = true;
    protected int placeholderColor = Color.parseColor((String)"#f1f1f1");
    protected int placeholderStrokeColor = -1;
    protected int placeholderRadius = -1;
    protected boolean isShowSaveBtn = true;
    protected boolean isShowIndicator = true;
    protected boolean isInfinite = false;
    protected View customView;
    protected int bgColor = Color.rgb((int)32, (int)36, (int)46);
    public OnImageViewerLongPressListener longPressListener;

    public ImageViewerPopupView(@NonNull Context context) {
        super(context);
        this.container = (FrameLayout)this.findViewById(R.id.container);
        if (this.getImplLayoutId() > 0) {
            this.customView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.container, false);
            this.customView.setVisibility(4);
            this.customView.setAlpha(0.0f);
            this.container.addView(this.customView);
        }
    }

    @Override
    protected int getInnerLayoutId() {
        return R.layout._xpopup_image_viewer_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.tv_pager_indicator = (TextView)this.findViewById(R.id.tv_pager_indicator);
        this.tv_save = (TextView)this.findViewById(R.id.tv_save);
        this.placeholderView = (BlankView)this.findViewById(R.id.placeholderView);
        this.photoViewContainer = (PhotoViewContainer)this.findViewById(R.id.photoViewContainer);
        this.photoViewContainer.setOnDragChangeListener(this);
        this.pager = (HackyViewPager)this.findViewById(R.id.pager);
        PhotoViewAdapter photoViewAdapter = new PhotoViewAdapter();
        this.pager.setAdapter(photoViewAdapter);
        this.pager.setCurrentItem(this.position);
        this.pager.setVisibility(4);
        this.addOrUpdateSnapshot();
        this.pager.setOffscreenPageLimit(2);
        this.pager.addOnPageChangeListener(photoViewAdapter);
        if (!this.isShowIndicator) {
            this.tv_pager_indicator.setVisibility(8);
        }
        if (!this.isShowSaveBtn) {
            this.tv_save.setVisibility(8);
        } else {
            this.tv_save.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setupPlaceholder() {
        this.placeholderView.setVisibility(this.isShowPlaceholder ? 0 : 4);
        if (this.isShowPlaceholder) {
            if (this.placeholderColor != -1) {
                this.placeholderView.color = this.placeholderColor;
            }
            if (this.placeholderRadius != -1) {
                this.placeholderView.radius = this.placeholderRadius;
            }
            if (this.placeholderStrokeColor != -1) {
                this.placeholderView.strokeColor = this.placeholderStrokeColor;
            }
            XPopupUtils.setWidthHeight(this.placeholderView, this.rect.width(), this.rect.height());
            this.placeholderView.setTranslationX(this.rect.left);
            this.placeholderView.setTranslationY(this.rect.top);
            this.placeholderView.invalidate();
        }
    }

    private void showPagerIndicator() {
        if (this.urls.size() > 1) {
            int posi = this.getRealPosition();
            this.tv_pager_indicator.setText((CharSequence)(posi + 1 + "/" + this.urls.size()));
        }
        if (this.isShowSaveBtn) {
            this.tv_save.setVisibility(0);
        }
    }

    private void addOrUpdateSnapshot() {
        if (this.srcView == null) {
            return;
        }
        if (this.snapshotView == null) {
            this.snapshotView = new PhotoView(this.getContext());
            this.snapshotView.setEnabled(false);
            this.photoViewContainer.addView((View)this.snapshotView);
            this.snapshotView.setScaleType(this.srcView.getScaleType());
            this.snapshotView.setTranslationX(this.rect.left);
            this.snapshotView.setTranslationY(this.rect.top);
            XPopupUtils.setWidthHeight((View)this.snapshotView, this.rect.width(), this.rect.height());
        }
        int realPosition = this.getRealPosition();
        this.snapshotView.setTag(realPosition);
        if (this.srcView != null && this.srcView.getDrawable() != null) {
            try {
                this.snapshotView.setImageDrawable(this.srcView.getDrawable().getConstantState().newDrawable());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setupPlaceholder();
        if (this.imageLoader != null) {
            this.imageLoader.loadSnapshot(this.urls.get(realPosition), this.snapshotView);
        }
    }

    @Override
    public void doShowAnimation() {
        if (this.srcView == null) {
            this.photoViewContainer.setBackgroundColor(this.bgColor);
            this.pager.setVisibility(0);
            this.showPagerIndicator();
            this.photoViewContainer.isReleasing = false;
            this.doAfterShow();
            return;
        }
        this.photoViewContainer.isReleasing = true;
        if (this.customView != null) {
            this.customView.setVisibility(0);
        }
        this.snapshotView.setVisibility(0);
        this.doAfterShow();
        this.snapshotView.post(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)ImageViewerPopupView.this.snapshotView.getParent()), (Transition)new TransitionSet().setDuration((long)ImageViewerPopupView.this.getAnimationDuration()).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).addListener((Transition.TransitionListener)new TransitionListenerAdapter(){

                    public void onTransitionEnd(@NonNull Transition transition) {
                        ImageViewerPopupView.this.pager.setVisibility(0);
                        ImageViewerPopupView.this.snapshotView.setVisibility(4);
                        ImageViewerPopupView.this.showPagerIndicator();
                        ImageViewerPopupView.this.photoViewContainer.isReleasing = false;
                    }
                }));
                ImageViewerPopupView.this.snapshotView.setTranslationY(0.0f);
                ImageViewerPopupView.this.snapshotView.setTranslationX(0.0f);
                ImageViewerPopupView.this.snapshotView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                XPopupUtils.setWidthHeight((View)ImageViewerPopupView.this.snapshotView, ImageViewerPopupView.this.photoViewContainer.getWidth(), ImageViewerPopupView.this.photoViewContainer.getHeight());
                ImageViewerPopupView.this.animateShadowBg(ImageViewerPopupView.this.bgColor);
                if (ImageViewerPopupView.this.customView != null) {
                    ImageViewerPopupView.this.customView.animate().alpha(1.0f).setDuration((long)ImageViewerPopupView.this.getAnimationDuration()).start();
                }
            }
        });
    }

    private void animateShadowBg(final int endColor) {
        final int start = ((ColorDrawable)this.photoViewContainer.getBackground()).getColor();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImageViewerPopupView.this.photoViewContainer.setBackgroundColor((Integer)ImageViewerPopupView.this.argbEvaluator.evaluate(animation.getAnimatedFraction(), (Object)start, (Object)endColor));
            }
        });
        animator.setDuration((long)this.getAnimationDuration()).setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.start();
    }

    @Override
    public void doDismissAnimation() {
        if (this.srcView == null) {
            this.photoViewContainer.setBackgroundColor(0);
            this.doAfterDismiss();
            this.pager.setVisibility(4);
            this.placeholderView.setVisibility(4);
            return;
        }
        this.tv_pager_indicator.setVisibility(4);
        this.tv_save.setVisibility(4);
        this.pager.setVisibility(4);
        this.photoViewContainer.isReleasing = true;
        this.snapshotView.setVisibility(0);
        this.doAfterDismiss();
        this.snapshotView.post(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)ImageViewerPopupView.this.snapshotView.getParent()), (Transition)new TransitionSet().setDuration((long)ImageViewerPopupView.this.getAnimationDuration()).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).addListener((Transition.TransitionListener)new TransitionListenerAdapter(){

                    public void onTransitionEnd(@NonNull Transition transition) {
                        ImageViewerPopupView.this.pager.setVisibility(4);
                        ImageViewerPopupView.this.snapshotView.setVisibility(0);
                        ImageViewerPopupView.this.pager.setScaleX(1.0f);
                        ImageViewerPopupView.this.pager.setScaleY(1.0f);
                        ImageViewerPopupView.this.snapshotView.setScaleX(1.0f);
                        ImageViewerPopupView.this.snapshotView.setScaleY(1.0f);
                        ImageViewerPopupView.this.placeholderView.setVisibility(4);
                    }
                }));
                ImageViewerPopupView.this.snapshotView.setScaleX(1.0f);
                ImageViewerPopupView.this.snapshotView.setScaleY(1.0f);
                ImageViewerPopupView.this.snapshotView.setTranslationY(ImageViewerPopupView.this.rect.top);
                ImageViewerPopupView.this.snapshotView.setTranslationX(ImageViewerPopupView.this.rect.left);
                ImageViewerPopupView.this.snapshotView.setScaleType(ImageViewerPopupView.this.srcView.getScaleType());
                XPopupUtils.setWidthHeight((View)ImageViewerPopupView.this.snapshotView, ImageViewerPopupView.this.rect.width(), ImageViewerPopupView.this.rect.height());
                ImageViewerPopupView.this.animateShadowBg(0);
                if (ImageViewerPopupView.this.customView != null) {
                    ImageViewerPopupView.this.customView.animate().alpha(0.0f).setDuration((long)ImageViewerPopupView.this.getAnimationDuration()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            super.onAnimationEnd(animation);
                            if (ImageViewerPopupView.this.customView != null) {
                                ImageViewerPopupView.this.customView.setVisibility(4);
                            }
                        }
                    }).start();
                }
            }
        });
    }

    @Override
    public void dismiss() {
        if (this.popupStatus != PopupStatus.Show) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.doDismissAnimation();
    }

    public ImageViewerPopupView setImageUrls(List<Object> urls) {
        this.urls = urls;
        return this;
    }

    public ImageViewerPopupView setSrcViewUpdateListener(OnSrcViewUpdateListener srcViewUpdateListener) {
        this.srcViewUpdateListener = srcViewUpdateListener;
        return this;
    }

    public ImageViewerPopupView setXPopupImageLoader(XPopupImageLoader imageLoader) {
        this.imageLoader = imageLoader;
        return this;
    }

    public ImageViewerPopupView isShowPlaceholder(boolean isShow) {
        this.isShowPlaceholder = isShow;
        return this;
    }

    public ImageViewerPopupView isShowIndicator(boolean isShow) {
        this.isShowIndicator = isShow;
        return this;
    }

    public ImageViewerPopupView isShowSaveButton(boolean isShowSaveBtn) {
        this.isShowSaveBtn = isShowSaveBtn;
        return this;
    }

    public ImageViewerPopupView isInfinite(boolean isInfinite) {
        this.isInfinite = isInfinite;
        return this;
    }

    public ImageViewerPopupView setPlaceholderColor(int color2) {
        this.placeholderColor = color2;
        return this;
    }

    public ImageViewerPopupView setPlaceholderRadius(int radius) {
        this.placeholderRadius = radius;
        return this;
    }

    public ImageViewerPopupView setPlaceholderStrokeColor(int strokeColor) {
        this.placeholderStrokeColor = strokeColor;
        return this;
    }

    public ImageViewerPopupView setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public ImageViewerPopupView setLongPressListener(OnImageViewerLongPressListener longPressListener) {
        this.longPressListener = longPressListener;
        return this;
    }

    public ImageViewerPopupView setSingleSrcView(ImageView srcView, Object url) {
        if (this.urls == null) {
            this.urls = new ArrayList<Object>();
        }
        this.urls.clear();
        this.urls.add(url);
        this.setSrcView(srcView, 0);
        return this;
    }

    public ImageViewerPopupView setSrcView(ImageView srcView, int position) {
        this.srcView = srcView;
        this.position = position;
        if (srcView != null) {
            int[] locations = new int[2];
            this.srcView.getLocationInWindow(locations);
            if (XPopupUtils.isLayoutRtl(this.getContext())) {
                int left = -(XPopupUtils.getWindowWidth(this.getContext()) - locations[0] - srcView.getWidth());
                this.rect = new Rect(left, locations[1], left + srcView.getWidth(), locations[1] + srcView.getHeight());
            } else {
                this.rect = new Rect(locations[0], locations[1], locations[0] + srcView.getWidth(), locations[1] + srcView.getHeight());
            }
        }
        return this;
    }

    public void updateSrcView(ImageView srcView) {
        this.setSrcView(srcView, this.position);
        this.addOrUpdateSnapshot();
    }

    @Override
    public void onRelease() {
        this.dismiss();
    }

    @Override
    public void onDragChange(int dy, float scale, float fraction) {
        this.tv_pager_indicator.setAlpha(1.0f - fraction);
        if (this.customView != null) {
            this.customView.setAlpha(1.0f - fraction);
        }
        if (this.isShowSaveBtn) {
            this.tv_save.setAlpha(1.0f - fraction);
        }
        this.photoViewContainer.setBackgroundColor((Integer)this.argbEvaluator.evaluate(fraction * 0.8f, (Object)this.bgColor, (Object)0));
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        this.srcView = null;
        this.srcViewUpdateListener = null;
    }

    public void onClick(View v) {
        if (v == this.tv_save) {
            this.save();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.pager.removeOnPageChangeListener((PhotoViewAdapter)this.pager.getAdapter());
        this.imageLoader = null;
    }

    protected int getRealPosition() {
        return this.isInfinite ? this.position % this.urls.size() : this.position;
    }

    protected void save() {
        XPermission.create(this.getContext(), "STORAGE").callback(new XPermission.SimpleCallback(){

            @Override
            public void onGranted() {
                XPopupUtils.saveBmpToAlbum(ImageViewerPopupView.this.getContext(), ImageViewerPopupView.this.imageLoader, ImageViewerPopupView.this.urls.get(ImageViewerPopupView.this.getRealPosition()));
            }

            @Override
            public void onDenied() {
            }
        }).request();
    }

    public class PhotoViewAdapter
    extends PagerAdapter
    implements ViewPager.OnPageChangeListener {
        public int getCount() {
            return ImageViewerPopupView.this.isInfinite ? 100000 : ImageViewerPopupView.this.urls.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
            return o == view;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            int realPosition = ImageViewerPopupView.this.isInfinite ? position % ImageViewerPopupView.this.urls.size() : position;
            FrameLayout fl = this.buildContainer(container.getContext());
            ProgressBar progressBar = this.buildProgressBar(container.getContext());
            View view = ImageViewerPopupView.this.imageLoader.loadImage(realPosition, ImageViewerPopupView.this.urls.get(realPosition), ImageViewerPopupView.this, ImageViewerPopupView.this.snapshotView, progressBar);
            fl.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            fl.addView((View)progressBar);
            container.addView((View)fl);
            return fl;
        }

        private FrameLayout buildContainer(Context context) {
            FrameLayout fl = new FrameLayout(context);
            fl.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            return fl;
        }

        private ProgressBar buildProgressBar(Context context) {
            ProgressBar progressBar = new ProgressBar(context);
            progressBar.setIndeterminate(true);
            int size = XPopupUtils.dp2px(ImageViewerPopupView.this.container.getContext(), 40.0f);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(size, size);
            params.gravity = 17;
            progressBar.setLayoutParams((ViewGroup.LayoutParams)params);
            progressBar.setVisibility(8);
            return progressBar;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int i) {
            ImageViewerPopupView.this.position = i;
            ImageViewerPopupView.this.showPagerIndicator();
            if (ImageViewerPopupView.this.srcViewUpdateListener != null) {
                ImageViewerPopupView.this.srcViewUpdateListener.onSrcViewUpdate(ImageViewerPopupView.this, ImageViewerPopupView.this.getRealPosition());
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    }
}

