/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.BubbleAttachPopupView;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.BubbleLayout;

public class BubbleHorizontalAttachPopupView
extends BubbleAttachPopupView {
    public BubbleHorizontalAttachPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initPopupContent() {
        this.bubbleContainer.setLook(BubbleLayout.Look.LEFT);
        super.initPopupContent();
        this.defaultOffsetY = this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX == 0 ? XPopupUtils.dp2px(this.getContext(), 2.0f) : this.popupInfo.offsetX;
    }

    @Override
    public void doAttach() {
        boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        float translationX = 0.0f;
        float translationY = 0.0f;
        int w = this.getPopupContentView().getMeasuredWidth();
        int h = this.getPopupContentView().getMeasuredHeight();
        if (this.popupInfo.touchPoint != null) {
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            boolean bl = this.isShowLeft = this.popupInfo.touchPoint.x > (float)(XPopupUtils.getWindowWidth(this.getContext()) / 2);
            translationX = isRTL ? (this.isShowLeft ? -((float)XPopupUtils.getWindowWidth(this.getContext()) - this.popupInfo.touchPoint.x + (float)this.defaultOffsetX) : -((float)XPopupUtils.getWindowWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.getPopupContentView().getMeasuredWidth() - (float)this.defaultOffsetX)) : (this.isShowLeftToTarget() ? this.popupInfo.touchPoint.x - (float)w - (float)this.defaultOffsetX : this.popupInfo.touchPoint.x + (float)this.defaultOffsetX);
            translationY = this.popupInfo.touchPoint.y - (float)h * 0.5f + (float)this.defaultOffsetY;
        } else {
            int[] locations = new int[2];
            this.popupInfo.getAtView().getLocationOnScreen(locations);
            Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
            int centerX = (rect.left + rect.right) / 2;
            boolean bl = this.isShowLeft = centerX > XPopupUtils.getWindowWidth(this.getContext()) / 2;
            translationX = isRTL ? (this.isShowLeft ? (float)(-(XPopupUtils.getWindowWidth(this.getContext()) - rect.left + this.defaultOffsetX)) : (float)(-(XPopupUtils.getWindowWidth(this.getContext()) - rect.right - this.getPopupContentView().getMeasuredWidth() - this.defaultOffsetX))) : (this.isShowLeftToTarget() ? (float)(rect.left - w - this.defaultOffsetX) : (float)(rect.right + this.defaultOffsetX));
            translationY = (float)rect.top + (float)(rect.height() - h) / 2.0f + (float)this.defaultOffsetY;
        }
        if (this.isShowLeftToTarget()) {
            this.bubbleContainer.setLook(BubbleLayout.Look.RIGHT);
        } else {
            this.bubbleContainer.setLook(BubbleLayout.Look.LEFT);
        }
        this.bubbleContainer.setLookPositionCenter(true);
        this.bubbleContainer.invalidate();
        this.getPopupContentView().setTranslationX(translationX);
        this.getPopupContentView().setTranslationY(translationY);
        this.initAndStartAnimation();
    }

    private boolean isShowLeftToTarget() {
        return (this.isShowLeft || this.popupInfo.popupPosition == PopupPosition.Left) && this.popupInfo.popupPosition != PopupPosition.Right;
    }
}

