/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.animator.PopupAnimator;

public class ShadowBgAnimator
extends PopupAnimator {
    public ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    public int startColor = 0;
    public boolean isZeroDuration = false;
    public int shadowColor;

    public ShadowBgAnimator(View target, int animationDuration, int shadowColor) {
        super(target, animationDuration);
        this.shadowColor = shadowColor;
    }

    public ShadowBgAnimator() {
    }

    @Override
    public void initAnimator() {
        this.targetView.setBackgroundColor(this.startColor);
    }

    @Override
    public void animateShow() {
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{this.startColor, this.shadowColor});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ShadowBgAnimator.this.targetView.setBackgroundColor(((Integer)animation.getAnimatedValue()).intValue());
            }
        });
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.setDuration(this.isZeroDuration ? 0L : (long)this.animationDuration).start();
    }

    @Override
    public void animateDismiss() {
        if (this.animating) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{this.shadowColor, this.startColor});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ShadowBgAnimator.this.targetView.setBackgroundColor(((Integer)animation.getAnimatedValue()).intValue());
            }
        });
        this.observerAnimator(animator);
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.setDuration(this.isZeroDuration ? 0L : (long)this.animationDuration).start();
    }

    public int calculateBgColor(float fraction) {
        return (Integer)this.argbEvaluator.evaluate(fraction, (Object)this.startColor, (Object)this.shadowColor);
    }
}

