/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;

public abstract class AttachPopupView
extends BasePopupView {
    protected int defaultOffsetY = 0;
    protected int defaultOffsetX = 0;
    protected FrameLayout attachPopupContainer;
    public boolean isShowUp;
    public boolean isShowLeft;
    float translationX = 0.0f;
    float translationY = 0.0f;
    float maxY = XPopupUtils.getAppHeight(this.getContext());
    int overflow = XPopupUtils.dp2px(this.getContext(), 10.0f);
    float centerY = 0.0f;

    public AttachPopupView(@NonNull Context context) {
        super(context);
        this.attachPopupContainer = (FrameLayout)this.findViewById(R.id.attachPopupContainer);
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.attachPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.atViewRect == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or watchView() must be called for AttachPopupView before show()\uff01");
        }
        this.defaultOffsetY = this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX;
        this.attachPopupContainer.setTranslationX((float)this.popupInfo.offsetX);
        this.attachPopupContainer.setTranslationY((float)this.popupInfo.offsetY);
        this.applyBg();
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                AttachPopupView.this.doAttach();
            }
        });
    }

    protected void applyBg() {
        if (!this.isCreated) {
            Drawable.ConstantState constantState;
            if (Build.VERSION.SDK_INT >= 21) {
                Drawable.ConstantState constantState2;
                if (this.getPopupImplView().getBackground() != null && (constantState2 = this.getPopupImplView().getBackground().getConstantState()) != null) {
                    Drawable newDrawable = constantState2.newDrawable(this.getResources());
                    this.attachPopupContainer.setBackground(newDrawable);
                    this.getPopupImplView().setBackground(null);
                }
                this.attachPopupContainer.setElevation((float)XPopupUtils.dp2px(this.getContext(), 20.0f));
            } else if (this.getPopupImplView().getBackground() != null && (constantState = this.getPopupImplView().getBackground().getConstantState()) != null) {
                Drawable newDrawable = constantState.newDrawable(this.getResources());
                this.attachPopupContainer.setBackground(newDrawable);
                this.getPopupImplView().setBackground(null);
            }
        }
    }

    public void doAttach() {
        if (this.popupInfo == null) {
            return;
        }
        int realNavHeight = XPopupUtils.isNavBarVisible(this.getHostWindow()) ? XPopupUtils.getNavBarHeight() : 0;
        this.maxY = XPopupUtils.getAppHeight(this.getContext()) - this.overflow - realNavHeight;
        final boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        if (this.popupInfo.touchPoint != null) {
            boolean isTallerThanWindowHeight;
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            this.centerY = this.popupInfo.touchPoint.y;
            boolean bl = isTallerThanWindowHeight = this.popupInfo.touchPoint.y + (float)this.getPopupContentView().getMeasuredHeight() > this.maxY;
            this.isShowUp = isTallerThanWindowHeight ? this.popupInfo.touchPoint.y > (float)(XPopupUtils.getScreenHeight(this.getContext()) / 2) : false;
            this.isShowLeft = this.popupInfo.touchPoint.x < (float)(XPopupUtils.getAppWidth(this.getContext()) / 2);
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = (int)(this.isShowUpToTarget() ? this.popupInfo.touchPoint.y - (float)XPopupUtils.getStatusBarHeight() - (float)this.overflow : (float)XPopupUtils.getScreenHeight(this.getContext()) - this.popupInfo.touchPoint.y - (float)this.overflow - (float)realNavHeight);
            int maxWidth = (int)(this.isShowLeft ? (float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow : this.popupInfo.touchPoint.x - (float)this.overflow);
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (AttachPopupView.this.popupInfo == null) {
                        return;
                    }
                    if (isRTL) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? -((float)XPopupUtils.getAppWidth(AttachPopupView.this.getContext()) - AttachPopupView.this.popupInfo.touchPoint.x - (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)AttachPopupView.this.defaultOffsetX) : -((float)XPopupUtils.getAppWidth(AttachPopupView.this.getContext()) - AttachPopupView.this.popupInfo.touchPoint.x + (float)AttachPopupView.this.defaultOffsetX);
                    } else {
                        float f = AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? AttachPopupView.this.popupInfo.touchPoint.x + (float)AttachPopupView.this.defaultOffsetX : AttachPopupView.this.popupInfo.touchPoint.x - (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)AttachPopupView.this.defaultOffsetX;
                    }
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (isRTL ? (AttachPopupView.this.translationX += (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (AttachPopupView.this.translationX -= (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f)) : (isRTL ? (AttachPopupView.this.translationX -= (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (AttachPopupView.this.translationX += (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f));
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? AttachPopupView.this.popupInfo.touchPoint.y - (float)AttachPopupView.this.getPopupContentView().getMeasuredHeight() - (float)AttachPopupView.this.defaultOffsetY : AttachPopupView.this.popupInfo.touchPoint.y + (float)AttachPopupView.this.defaultOffsetY;
                    AttachPopupView.this.translationX -= (float)AttachPopupView.this.getActivityContentLeft();
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                    AttachPopupView.this.initAndStartAnimation();
                }
            });
        } else {
            int maxWidth;
            final Rect rect = this.popupInfo.atViewRect;
            int centerX = (rect.left + rect.right) / 2;
            boolean isTallerThanWindowHeight = (float)(rect.bottom + this.getPopupContentView().getMeasuredHeight()) > this.maxY;
            this.centerY = (rect.top + rect.bottom) / 2;
            if (isTallerThanWindowHeight) {
                int upAvailableSpace = rect.top - XPopupUtils.getStatusBarHeight() - this.overflow;
                this.isShowUp = this.getPopupContentView().getMeasuredHeight() > upAvailableSpace ? (float)upAvailableSpace > this.maxY - (float)rect.bottom : true;
            } else {
                this.isShowUp = false;
            }
            this.isShowLeft = centerX < XPopupUtils.getAppWidth(this.getContext()) / 2;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = this.isShowUpToTarget() ? rect.top - XPopupUtils.getStatusBarHeight() - this.overflow : XPopupUtils.getScreenHeight(this.getContext()) - rect.bottom - this.overflow - realNavHeight;
            int n = maxWidth = this.isShowLeft ? XPopupUtils.getAppWidth(this.getContext()) - rect.left - this.overflow : rect.right - this.overflow;
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (AttachPopupView.this.popupInfo == null) {
                        return;
                    }
                    if (isRTL) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (float)(-(XPopupUtils.getAppWidth(AttachPopupView.this.getContext()) - rect.left - AttachPopupView.this.getPopupContentView().getMeasuredWidth() - AttachPopupView.this.defaultOffsetX)) : (float)(-(XPopupUtils.getAppWidth(AttachPopupView.this.getContext()) - rect.right + AttachPopupView.this.defaultOffsetX));
                    } else {
                        float f = AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (float)(rect.left + AttachPopupView.this.defaultOffsetX) : (float)(rect.right - AttachPopupView.this.getPopupContentView().getMeasuredWidth() - AttachPopupView.this.defaultOffsetX);
                    }
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (isRTL ? (AttachPopupView.this.translationX -= (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (AttachPopupView.this.translationX += (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f)) : (isRTL ? (AttachPopupView.this.translationX += (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (AttachPopupView.this.translationX -= (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f));
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? (float)(rect.top - AttachPopupView.this.getPopupContentView().getMeasuredHeight() - AttachPopupView.this.defaultOffsetY) : (float)(rect.bottom + AttachPopupView.this.defaultOffsetY);
                    AttachPopupView.this.translationX -= (float)AttachPopupView.this.getActivityContentLeft();
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                    AttachPopupView.this.initAndStartAnimation();
                }
            });
        }
    }

    protected void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    protected boolean isShowUpToTarget() {
        if (this.popupInfo.positionByWindowCenter) {
            return this.centerY > (float)(XPopupUtils.getAppHeight(this.getContext()) / 2);
        }
        return (this.isShowUp || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowUpToTarget() ? new ScrollScaleAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftBottom : PopupAnimation.ScrollAlphaFromRightBottom) : new ScrollScaleAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftTop : PopupAnimation.ScrollAlphaFromRightTop);
        return animator;
    }
}

