/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class PartShadowPopupView
extends BasePopupView {
    protected PartShadowContainer attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
    public boolean isShowUp;

    public PartShadowPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_partshadow_popup_view;
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected void initPopupContent() {
        if (this.attachPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.targetView = this.getPopupContentView();
        }
        this.getPopupContentView().setTranslationY((float)this.popupInfo.offsetY);
        this.getPopupImplView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupImplView().setTranslationY(0.0f);
        this.getPopupImplView().setVisibility(4);
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.doAttach();
            }
        });
    }

    private void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    public void doAttach() {
        int tx;
        if (this.popupInfo.getAtView() == null) {
            throw new IllegalArgumentException("atView must not be null for PartShadowPopupView\uff01");
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getPopupContentView().getLayoutParams();
        params.width = this.getMeasuredWidth();
        int[] locations = new int[2];
        this.popupInfo.getAtView().getLocationOnScreen(locations);
        Rect rect = new Rect(locations[0] - this.getActivityContentLeft(), locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth() - this.getActivityContentLeft(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
        if (this.popupInfo.isCenterHorizontal && this.getPopupImplView() != null) {
            tx = (rect.left + rect.right) / 2 - this.getPopupImplView().getMeasuredWidth() / 2;
            this.getPopupImplView().setTranslationX((float)tx);
        } else {
            tx = rect.left + this.popupInfo.offsetX;
            int realWidth = this.getActivityContentView().getMeasuredWidth();
            if (tx + this.getPopupImplView().getMeasuredWidth() > realWidth) {
                tx -= tx + this.getPopupImplView().getMeasuredWidth() - realWidth;
            }
            this.getPopupImplView().setTranslationX((float)tx);
        }
        int centerY = rect.top + rect.height() / 2;
        View implView = this.getPopupImplView();
        FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
        if ((centerY > this.getMeasuredHeight() / 2 || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom) {
            params.height = rect.top;
            this.isShowUp = true;
            implParams.gravity = 80;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
        } else {
            params.height = this.getMeasuredHeight() - rect.bottom;
            this.isShowUp = false;
            params.topMargin = rect.bottom;
            implParams.gravity = 48;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
        }
        this.getPopupContentView().setLayoutParams((ViewGroup.LayoutParams)params);
        implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        this.getPopupContentView().post(new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.initAndStartAnimation();
                PartShadowPopupView.this.getPopupImplView().setVisibility(0);
            }
        });
        this.attachPopupContainer.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
                return false;
            }
        });
        this.attachPopupContainer.setOnClickOutsideListener(new OnClickOutsideListener(){

            @Override
            public void onClickOutside() {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
            }
        });
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupImplView(), this.getAnimationDuration(), this.isShowUp ? PopupAnimation.TranslateFromBottom : PopupAnimation.TranslateFromTop);
    }

    @Override
    protected int getMaxWidth() {
        return XPopupUtils.getAppWidth(this.getContext());
    }
}

